/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.generalconfig;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.generalconfig.GeneralConfigPluginActivator;
import net.java.sip.communicator.plugin.generalconfig.Resources;
import org.jitsi.service.configuration.ConfigurationService;

public class SilkConfigForm
extends TransparentPanel {
    private static final String FEC_SAT_DEFAULT = "0.5";
    private static final boolean FEC_DEFAULT = true;
    private static final boolean FEC_FORCE_PL_DEFAULT = true;
    private static final boolean FEC_ADVERTISE_DEFAULT = false;
    private final JButton restoreButton = new JButton(Resources.getString("plugin.generalconfig.RESTORE"));
    private final JCheckBox fecCheckbox = new SIPCommCheckBox();
    private final JCheckBox assumePLCheckbox = new SIPCommCheckBox();
    private final JCheckBox advertiseFECCheckbox = new SIPCommCheckBox();
    private final JTextField SATField = new JTextField(6);
    private final ConfigurationService configurationService = GeneralConfigPluginActivator.getConfigurationService();

    public SilkConfigForm() {
        super((LayoutManager)new BorderLayout());
        Box box = Box.createVerticalBox();
        this.add(box, "North");
        TransparentPanel contentPanel = new TransparentPanel();
        contentPanel.setLayout((LayoutManager)new BorderLayout(10, 10));
        box.add((Component)contentPanel);
        TransparentPanel labelPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        TransparentPanel valuePanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        TransparentPanel southPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1, 2, 2));
        contentPanel.add((Component)labelPanel, (Object)"West");
        contentPanel.add((Component)valuePanel, (Object)"Center");
        contentPanel.add((Component)southPanel, (Object)"South");
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.SILK_USE_FEC")));
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.SILK_ALWAYS_ASSUME_PACKET_LOSS")));
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.SILK_SAT")));
        labelPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.SILK_ADVERTISE_FEC")));
        this.fecCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SilkConfigForm.this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.USE_FEC", (Object)SilkConfigForm.this.fecCheckbox.isSelected());
            }
        });
        this.fecCheckbox.setSelected(this.configurationService.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.USE_FEC", true));
        valuePanel.add((Component)this.fecCheckbox);
        this.assumePLCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SilkConfigForm.this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.AWLAYS_ASSUME_PACKET_LOSS", (Object)SilkConfigForm.this.assumePLCheckbox.isSelected());
            }
        });
        this.assumePLCheckbox.setSelected(this.configurationService.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.AWLAYS_ASSUME_PACKET_LOSS", true));
        valuePanel.add((Component)this.assumePLCheckbox);
        this.SATField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SilkConfigForm.this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.SPEECH_ACTIVITY_THRESHOLD", (Object)SilkConfigForm.this.SATField.getText());
            }
        });
        this.SATField.setText(this.configurationService.getString("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.SPEECH_ACTIVITY_THRESHOLD", FEC_SAT_DEFAULT));
        valuePanel.add((Component)this.SATField);
        this.advertiseFECCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SilkConfigForm.this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.ADVERTISE_FEC", (Object)SilkConfigForm.this.advertiseFECCheckbox.isSelected());
            }
        });
        this.advertiseFECCheckbox.setSelected(this.configurationService.getBoolean("net.java.sip.communicator.impl.neomedia.codec.audio.silk.ADVERTISE_FEC", false));
        valuePanel.add((Component)this.advertiseFECCheckbox);
        southPanel.add((Component)this.restoreButton);
        this.restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SilkConfigForm.this.restoreDefaults();
            }
        });
        southPanel.add((Component)new JLabel(Resources.getString("plugin.generalconfig.DEFAULT_LANGUAGE_RESTART_WARN")));
    }

    private void restoreDefaults() {
        this.fecCheckbox.setSelected(true);
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.USE_FEC", (Object)true);
        this.assumePLCheckbox.setSelected(true);
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.AWLAYS_ASSUME_PACKET_LOSS", (Object)true);
        this.SATField.setText(FEC_SAT_DEFAULT);
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.encoder.SPEECH_ACTIVITY_THRESHOLD", (Object)FEC_SAT_DEFAULT);
        this.advertiseFECCheckbox.setSelected(false);
        this.configurationService.setProperty("net.java.sip.communicator.impl.neomedia.codec.audio.silk.ADVERTISE_FEC", (Object)false);
    }
}

