/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.net.AutoProxyConnection;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.util.SRVRecord;
import org.easymock.EasyMock;

public class TestAutoProxyDetection
extends TestCase {
    private SipAccountIDImpl account;
    private TestedAutoProxyDetection.NetworkUtils nu;
    private SRVRecord srv1;
    private SRVRecord srv2;
    private SRVRecord srv3;
    private InetSocketAddress a1;
    private InetSocketAddress a2;
    private InetSocketAddress a3;
    private InetSocketAddress a4;
    private static final String DOMAIN = "example.com";
    private InetAddress ia1;
    private InetAddress ia2;
    private InetAddress ia3;
    private InetAddress ia4;
    private TestedAutoProxyDetection apd;

    public void setUp() {
        this.account = (SipAccountIDImpl)EasyMock.createMock(SipAccountIDImpl.class);
        EasyMock.expect((Object)this.account.getAccountPropertyString((Object)"USER_ID")).andReturn((Object)"unit@example.com");
        EasyMock.replay((Object[])new Object[]{this.account});
        this.nu = (TestedAutoProxyDetection.NetworkUtils)((Object)EasyMock.createMock(TestedAutoProxyDetection.NetworkUtils.class));
        this.apd = new TestedAutoProxyDetection(this.account, "UDP");
        this.apd.setNetworkUtils(this.nu);
        this.srv1 = (SRVRecord)EasyMock.createMock(SRVRecord.class);
        EasyMock.expect((Object)this.srv1.getTarget()).andReturn((Object)"proxy1.example.com");
        EasyMock.expect((Object)this.srv1.getPort()).andReturn((Object)5060);
        this.srv2 = (SRVRecord)EasyMock.createMock(SRVRecord.class);
        EasyMock.expect((Object)this.srv2.getTarget()).andReturn((Object)"proxy2.example.com");
        EasyMock.expect((Object)this.srv2.getPort()).andReturn((Object)5061);
        this.srv3 = (SRVRecord)EasyMock.createMock(SRVRecord.class);
        EasyMock.expect((Object)this.srv3.getTarget()).andReturn((Object)"proxy3.example.com");
        EasyMock.expect((Object)this.srv3.getPort()).andReturn((Object)5062);
        try {
            this.ia1 = InetAddress.getByAddress("proxy1.example.com", new byte[]{127, 0, 0, 1});
            this.ia2 = InetAddress.getByAddress("proxy2.example.com", new byte[]{127, 0, 0, 2});
            this.ia3 = InetAddress.getByAddress("proxy3.example.com", new byte[]{127, 0, 0, 3});
            this.ia4 = InetAddress.getByAddress("proxy4.example.com", new byte[]{127, 0, 0, 4});
        }
        catch (UnknownHostException e) {
            TestAutoProxyDetection.fail((String)("unable to initialize: " + e.getMessage()));
        }
        this.a1 = new InetSocketAddress(this.ia1, 5060);
        this.a2 = new InetSocketAddress(this.ia2, 5061);
        this.a3 = new InetSocketAddress(this.ia3, 5062);
        this.a4 = new InetSocketAddress(this.ia4, 5063);
    }

    private void prepareOneNaptrOneSrv() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[][]{{"0", "udp", "_sip._udp.example.com"}});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._udp.example.com")).andReturn((Object)new SRVRecord[]{this.srv1});
    }

    private void prepareOneNaptrTwoSrv() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[][]{{"0", "udp", "_sip._udp.example.com"}});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._udp.example.com")).andReturn((Object)new SRVRecord[]{this.srv1, this.srv2});
    }

    public void testOneNaptrNoSrv() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[][]{{"0", "udp", "_sip._udp.example.com"}});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._udp.example.com")).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.nu});
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu});
    }

    public void testOneNaptrOneSrvOneA() throws ParseException, DnssecException {
        this.prepareOneNaptrOneSrv();
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1});
    }

    public void testOneNaptrOneSrvTwoA() throws ParseException, DnssecException {
        this.prepareOneNaptrOneSrv();
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1, this.a2});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1});
    }

    public void testOneNaptrTwoSrvOneA() throws ParseException, DnssecException {
        this.prepareOneNaptrTwoSrv();
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy2.example.com", 5061)).andReturn((Object)new InetSocketAddress[]{this.a2});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1, this.srv2});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1, this.srv2});
    }

    public void testOneNaptrTwoSrvTwoA() throws ParseException, DnssecException {
        this.prepareOneNaptrTwoSrv();
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1, this.a2});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy2.example.com", 5061)).andReturn((Object)new InetSocketAddress[]{this.a3, this.a4});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1, this.srv2});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a3, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a4, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1, this.srv2});
    }

    public void testThreeNaptrOneSrvEachOneAEach() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[][]{{"0", "udp", "_sip._udp.example.com"}, {"0", "tcp", "_sip._tcp.example.com"}, {"0", "tls", "_sips._tcp.example.com"}});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._udp.example.com")).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._tcp.example.com")).andReturn((Object)new SRVRecord[]{this.srv2});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sips._tcp.example.com")).andReturn((Object)new SRVRecord[]{this.srv3});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy2.example.com", 5061)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy3.example.com", 5062)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1, this.srv2, this.srv3});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"TCP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"TLS", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1, this.srv2, this.srv3});
    }

    public void testNoSrvOneA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getAandAAAARecords(DOMAIN, 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.replay((Object[])new Object[]{this.nu});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu});
    }

    public void testOneSrvNoA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1});
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1});
    }

    public void testOneSrvOneA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1});
    }

    public void testOneSrvTwoA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1, this.a2});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1});
    }

    public void testTwoSrvOneA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn((Object)new SRVRecord[]{this.srv2});
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy2.example.com", 5061)).andReturn((Object)new InetSocketAddress[]{this.a2});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1, this.srv2});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"TLS", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1, this.srv2});
    }

    public void testTwoSameSrvOneA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn((Object)new SRVRecord[]{this.srv1, this.srv2});
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy2.example.com", 5061)).andReturn((Object)new InetSocketAddress[]{this.a2});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1, this.srv2});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"TLS", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertEquals((int)5060, (int)this.apd.getAddress().getPort());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"TLS", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertEquals((int)5061, (int)this.apd.getAddress().getPort());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1, this.srv2});
    }

    public void testNoA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getAandAAAARecords(DOMAIN, 5060)).andReturn((Object)new InetSocketAddress[0]);
        EasyMock.replay((Object[])new Object[]{this.nu});
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu});
    }

    public void testOneA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getAandAAAARecords(DOMAIN, 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.replay((Object[])new Object[]{this.nu});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu});
    }

    public void testTwoA() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[0][]);
        EasyMock.expect((Object)this.nu.getSRVRecords("sips", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "TCP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getSRVRecords("sip", "UDP", DOMAIN)).andReturn(null);
        EasyMock.expect((Object)this.nu.getAandAAAARecords(DOMAIN, 5060)).andReturn((Object)new InetSocketAddress[]{this.a1, this.a2});
        EasyMock.replay((Object[])new Object[]{this.nu});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a2, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu});
    }

    public void testNotReturningSameAddressTwice() throws ParseException, DnssecException {
        EasyMock.expect((Object)this.srv1.getTarget()).andReturn((Object)"proxy1.example.com");
        EasyMock.expect((Object)this.srv1.getPort()).andReturn((Object)5060);
        EasyMock.expect((Object)this.nu.getNAPTRRecords(DOMAIN)).andReturn((Object)new String[][]{{"0", "udp", "_sip._udp.example.com"}, {"1", "udp", "_sip._udp.example.com"}});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._udp.example.com")).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getSRVRecords("_sip._udp.example.com")).andReturn((Object)new SRVRecord[]{this.srv1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.expect((Object)this.nu.getAandAAAARecords("proxy1.example.com", 5060)).andReturn((Object)new InetSocketAddress[]{this.a1});
        EasyMock.replay((Object[])new Object[]{this.nu, this.srv1});
        TestAutoProxyDetection.assertTrue((boolean)this.apd.getNextAddress());
        TestAutoProxyDetection.assertEquals((Object)this.a1, (Object)this.apd.getAddress());
        TestAutoProxyDetection.assertEquals((String)"UDP", (String)this.apd.getTransport());
        TestAutoProxyDetection.assertFalse((boolean)this.apd.getNextAddress());
        EasyMock.verify((Object[])new Object[]{this.account, this.nu, this.srv1});
    }

    private static class TestedAutoProxyDetection
    extends AutoProxyConnection {
        public TestedAutoProxyDetection(SipAccountIDImpl account, String defaultTransport) {
            super(account, defaultTransport);
        }

        public void setNetworkUtils(AutoProxyConnection.LocalNetworkUtils nu) {
            super.setNetworkUtils(nu);
        }

        public static class NetworkUtils
        extends AutoProxyConnection.LocalNetworkUtils {
        }
    }
}

