/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.sip;

import gov.nist.javax.sip.address.SipUri;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapClient;
import net.java.sip.communicator.impl.protocol.sip.xcap.XCapClientImpl;
import net.java.sip.communicator.impl.protocol.sip.xcap.model.prescontent.ContentType;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredAccountInfo;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.slick.protocol.sip.SipSlickFixture;
import net.java.sip.communicator.slick.protocol.sip.TestOperationSetServerStoredInfoData;
import net.java.sip.communicator.util.Base64;

public class TestOperationSetServerStoredInfo
extends TestCase {
    private SipSlickFixture fixture = new SipSlickFixture();
    private OperationSetServerStoredAccountInfo opSetServerStoredAccountInfo = null;
    private XCapClient xCapClient;

    public TestOperationSetServerStoredInfo(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
        Map supportedOperationSets = this.fixture.provider1.getSupportedOperationSets();
        if (supportedOperationSets == null || supportedOperationSets.size() < 1) {
            throw new NullPointerException("No OperationSet implementations are supported by this SIP implementation.");
        }
        this.opSetServerStoredAccountInfo = (OperationSetServerStoredAccountInfo)supportedOperationSets.get(OperationSetServerStoredAccountInfo.class.getName());
        if (this.opSetServerStoredAccountInfo == null) {
            throw new NullPointerException("No implementation for Account Info was found");
        }
        if (!this.opSetServerStoredAccountInfo.isDetailClassSupported(ServerStoredDetails.ImageDetail.class)) {
            throw new NullPointerException("OperationSet does't support avatars");
        }
        this.xCapClient = this.createXCapClient();
        if (!this.xCapClient.isConnected()) {
            throw new NullPointerException("XCAP client is not connected");
        }
        if (!this.xCapClient.isPresContentSupported()) {
            throw new NullPointerException("XCAP server doesn't support pres-content");
        }
        ArrayList details = new ArrayList();
        Iterator detailIterator = this.opSetServerStoredAccountInfo.getAllAvailableDetails();
        while (detailIterator.hasNext()) {
            details.add(detailIterator.next());
        }
        for (ServerStoredDetails.GenericDetail detail : details) {
            this.opSetServerStoredAccountInfo.removeDetail(detail);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.fixture.tearDown();
        this.xCapClient.disconnect();
    }

    public static Test suite() {
        if (System.getProperty("accounts.sip.account1.OPT_CLIST_SERVER_URI") != null) {
            return new TestSuite(TestOperationSetServerStoredInfo.class);
        }
        return new TestSuite();
    }

    private XCapClient createXCapClient() throws Exception {
        String userName = System.getProperty("accounts.sip.account1.USER_ID");
        String password = System.getProperty("accounts.sip.account1.PASSWORD");
        String xCapServerUri = System.getProperty("accounts.sip.account1.OPT_CLIST_SERVER_URI");
        XCapClientImpl xCapClient = new XCapClientImpl();
        xCapClient.connect(new URI(xCapServerUri), ((ProtocolProviderServiceSipImpl)this.fixture.provider1).parseAddressString(userName), ((SipUri)((ProtocolProviderServiceSipImpl)this.fixture.provider1).parseAddressString(userName)).getUser(), password);
        return xCapClient;
    }

    public void testReadInfo() throws Exception {
        byte[] imageContent = TestOperationSetServerStoredInfoData.IMAGE_CONTENT_1;
        ServerStoredDetails.ImageDetail imageDetail1 = new ServerStoredDetails.ImageDetail(null, imageContent);
        this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)imageDetail1);
        Iterator storedDetails = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.ImageDetail.class);
        TestOperationSetServerStoredInfo.assertNotNull((String)"Stored details cannot be null", (Object)storedDetails);
        TestOperationSetServerStoredInfo.assertTrue((String)"Stored details doesn't have ImageDetail", (boolean)storedDetails.hasNext());
        ServerStoredDetails.GenericDetail storedImageDetail = (ServerStoredDetails.GenericDetail)storedDetails.next();
        TestOperationSetServerStoredInfo.assertTrue((String)"Stored details is not ImageDetail", (boolean)(storedImageDetail instanceof ServerStoredDetails.ImageDetail));
        byte[] savedContent = ((ServerStoredDetails.ImageDetail)storedImageDetail).getBytes();
        TestOperationSetServerStoredInfo.assertEquals((String)"The ImageDetail we set is not set or not read properly", (int)imageContent.length, (int)savedContent.length);
        for (int i = 0; i < imageContent.length; ++i) {
            TestOperationSetServerStoredInfo.assertSame((String)"The ImageDetail we set has not the same content", (Object)imageContent[i], (Object)savedContent[i]);
        }
        ContentType presContent = this.xCapClient.getPresContent("sip_communicator");
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content cannot be null", (Object)presContent);
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content data cannot be null", (Object)presContent.getData());
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content data value cannot be null", (Object)presContent.getData().getValue());
        byte[] serverContent = Base64.decode((String)presContent.getData().getValue());
        TestOperationSetServerStoredInfo.assertEquals((String)"The ImageDetail we set is not set or not read properly", (int)imageContent.length, (int)serverContent.length);
        for (int i = 0; i < imageContent.length; ++i) {
            TestOperationSetServerStoredInfo.assertSame((String)"The ImageDetail we set has not the same content", (Object)imageContent[i], (Object)serverContent[i]);
        }
    }

    public void testWriteInfo() throws Exception {
        byte[] imageContent = TestOperationSetServerStoredInfoData.IMAGE_CONTENT_1;
        ServerStoredDetails.ImageDetail imageDetail = new ServerStoredDetails.ImageDetail(null, imageContent);
        this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)imageDetail);
        ContentType presContent = this.xCapClient.getPresContent("sip_communicator");
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content cannot be null", (Object)presContent);
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content data cannot be null", (Object)presContent.getData());
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content data value cannot be null", (Object)presContent.getData().getValue());
        byte[] serverContent = Base64.decode((String)presContent.getData().getValue());
        TestOperationSetServerStoredInfo.assertEquals((String)"The ImageDetail we set is not set or not read properly", (int)imageContent.length, (int)serverContent.length);
        for (int i = 0; i < imageContent.length; ++i) {
            TestOperationSetServerStoredInfo.assertSame((String)"The ImageDetail we set has not the same content", (Object)imageContent[i], (Object)serverContent[i]);
        }
        this.opSetServerStoredAccountInfo.removeDetail((ServerStoredDetails.GenericDetail)imageDetail);
    }

    public void testRemoveInfo() throws Exception {
        byte[] imageContent = TestOperationSetServerStoredInfoData.IMAGE_CONTENT_1;
        ServerStoredDetails.ImageDetail imageDetail = new ServerStoredDetails.ImageDetail(null, imageContent);
        this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)imageDetail);
        boolean removeResult = this.opSetServerStoredAccountInfo.removeDetail((ServerStoredDetails.GenericDetail)imageDetail);
        TestOperationSetServerStoredInfo.assertTrue((String)"The result of remove operation cannot be false", (boolean)removeResult);
        Iterator storedDetails = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.ImageDetail.class);
        TestOperationSetServerStoredInfo.assertNotNull((String)"Stored details cannot be null", (Object)storedDetails);
        TestOperationSetServerStoredInfo.assertFalse((String)"Stored details cannot have ImageDetail", (boolean)storedDetails.hasNext());
        ContentType presContent = this.xCapClient.getPresContent("sip_communicator");
        TestOperationSetServerStoredInfo.assertNull((String)"Pres-content cannot be not null", (Object)presContent);
    }

    public void testReplaceInfo() throws Exception {
        byte[] imageContent1 = TestOperationSetServerStoredInfoData.IMAGE_CONTENT_1;
        byte[] imageContent2 = TestOperationSetServerStoredInfoData.IMAGE_CONTENT_2;
        ServerStoredDetails.ImageDetail imageDetail1 = new ServerStoredDetails.ImageDetail(null, imageContent1);
        ServerStoredDetails.ImageDetail imageDetail2 = new ServerStoredDetails.ImageDetail(null, imageContent2);
        this.opSetServerStoredAccountInfo.addDetail((ServerStoredDetails.GenericDetail)imageDetail1);
        boolean replaceResult = this.opSetServerStoredAccountInfo.replaceDetail((ServerStoredDetails.GenericDetail)imageDetail1, (ServerStoredDetails.GenericDetail)imageDetail2);
        TestOperationSetServerStoredInfo.assertTrue((String)"The result of replace operation cannot be false", (boolean)replaceResult);
        Iterator storedDetails = this.opSetServerStoredAccountInfo.getDetails(ServerStoredDetails.ImageDetail.class);
        TestOperationSetServerStoredInfo.assertNotNull((String)"Stored details cannot be null", (Object)storedDetails);
        TestOperationSetServerStoredInfo.assertTrue((String)"Stored details doesn't have ImageDetail", (boolean)storedDetails.hasNext());
        ServerStoredDetails.GenericDetail imageDetail = (ServerStoredDetails.GenericDetail)storedDetails.next();
        TestOperationSetServerStoredInfo.assertTrue((String)"Stored details is not ImageDetail", (boolean)(imageDetail instanceof ServerStoredDetails.ImageDetail));
        byte[] savedContent = ((ServerStoredDetails.ImageDetail)imageDetail).getBytes();
        TestOperationSetServerStoredInfo.assertEquals((String)"The ImageDetail we set is not set or not read properly", (int)imageContent2.length, (int)savedContent.length);
        for (int i = 0; i < imageContent2.length; ++i) {
            TestOperationSetServerStoredInfo.assertSame((String)"The ImageDetail we set has not the same content", (Object)imageContent2[i], (Object)savedContent[i]);
        }
        ContentType presContent = this.xCapClient.getPresContent("sip_communicator");
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content cannot be null", (Object)presContent);
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content data cannot be null", (Object)presContent.getData());
        TestOperationSetServerStoredInfo.assertNotNull((String)"Pres-content data value cannot be null", (Object)presContent.getData().getValue());
        byte[] serverContent = Base64.decode((String)presContent.getData().getValue());
        TestOperationSetServerStoredInfo.assertEquals((String)"The ImageDetail we set is not set or not read properly", (int)imageContent2.length, (int)serverContent.length);
        for (int i = 0; i < imageContent2.length; ++i) {
            TestOperationSetServerStoredInfo.assertSame((String)"The ImageDetail we set has not the same content", (Object)imageContent2[i], (Object)serverContent[i]);
        }
        this.opSetServerStoredAccountInfo.removeDetail((ServerStoredDetails.GenericDetail)imageDetail2);
    }
}

