/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.provisioning;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.ScreenInformation;
import net.java.sip.communicator.plugin.provisioning.ProvisioningActivator;
import net.java.sip.communicator.service.httputil.HttpUtils;
import net.java.sip.communicator.service.provisioning.ProvisioningService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.OrderedProperties;
import org.apache.http.NameValuePair;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;
import org.jitsi.util.StringUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ProvisioningServiceImpl
implements ProvisioningService {
    private static final Logger logger = Logger.getLogger(ProvisioningServiceImpl.class);
    public static final String PROVISIONING_UUID_PROP = "net.java.sip.communicator.UUID";
    private static final String PROPERTY_PROVISIONING_URL = "net.java.sip.communicator.plugin.provisioning.URL";
    static final String PROPERTY_PROVISIONING_USERNAME = "net.java.sip.communicator.plugin.provisioning.auth.USERNAME";
    static final String PROPERTY_PROVISIONING_PASSWORD = "net.java.sip.communicator.plugin.provisioning.auth";
    private static final String PROVISIONING_METHOD_PROP = "net.java.sip.communicator.plugin.provisioning.METHOD";
    private static final String PROPERTY_PROVISIONING_MANDATORY = "net.java.sip.communicator.plugin.provisioning.MANDATORY";
    private static final String PROVISIONING_ALLOW_PREFIX_PROP = "provisioning.ALLOW_PREFIX";
    private static final String PROVISIONING_ENFORCE_PREFIX_PROP = "provisioning.ENFORCE_PREFIX";
    private List<String> allowedPrefixes = new ArrayList<String>();
    private static String provUsername = null;
    private static String provPassword = null;
    private static final String SYSTEM_PROP_PREFIX = "${system}.";

    public ProvisioningServiceImpl() {
        String uuid = (String)ProvisioningActivator.getConfigurationService().getProperty(PROVISIONING_UUID_PROP);
        if (uuid == null || uuid.equals("")) {
            uuid = UUID.randomUUID().toString();
            ProvisioningActivator.getConfigurationService().setProperty(PROVISIONING_UUID_PROP, (Object)uuid);
        }
    }

    void start(String url) {
        InputStream data;
        if (url == null) {
            url = this.getProvisioningUri();
        }
        if (!StringUtils.isNullOrEmpty((String)url) && (data = this.retrieveConfigurationFile(url)) != null) {
            ProvisioningActivator.getConfigurationService().setProperty(PROPERTY_PROVISIONING_URL, (Object)url);
            this.updateConfiguration(data);
        }
    }

    @Override
    public String getProvisioningMethod() {
        String provMethod = ProvisioningActivator.getConfigurationService().getString(PROVISIONING_METHOD_PROP);
        if ((provMethod == null || provMethod.length() <= 0) && (provMethod = ProvisioningActivator.getResourceService().getSettingsString("plugin.provisioning.DEFAULT_PROVISIONING_METHOD")) != null && provMethod.length() > 0) {
            this.setProvisioningMethod(provMethod);
        }
        return provMethod;
    }

    @Override
    public void setProvisioningMethod(String provisioningMethod) {
        ProvisioningActivator.getConfigurationService().setProperty(PROVISIONING_METHOD_PROP, (Object)provisioningMethod);
    }

    @Override
    public String getProvisioningUri() {
        String provUri = ProvisioningActivator.getConfigurationService().getString(PROPERTY_PROVISIONING_URL);
        if ((provUri == null || provUri.length() <= 0) && (provUri = ProvisioningActivator.getResourceService().getSettingsString("plugin.provisioning.DEFAULT_PROVISIONING_URI")) != null && provUri.length() > 0) {
            this.setProvisioningUri(provUri);
        }
        return provUri;
    }

    public void setProvisioningUri(String uri) {
        ProvisioningActivator.getConfigurationService().setProperty(PROPERTY_PROVISIONING_URL, (Object)uri);
    }

    @Override
    public String getProvisioningUsername() {
        return provUsername;
    }

    @Override
    public String getProvisioningPassword() {
        return provPassword;
    }

    private InputStream retrieveConfigurationFile(String url) {
        return this.retrieveConfigurationFile(url, null);
    }

    /*
     * WARNING - void declaration
     */
    private InputStream retrieveConfigurationFile(String url, List<NameValuePair> parameters) {
        try {
            String value;
            String arg = null;
            String[] args = null;
            URL u = new URL(url);
            InetAddress ipaddr = ProvisioningActivator.getNetworkAddressManagerService().getLocalHost(InetAddress.getByName(u.getHost()));
            Pattern p = Pattern.compile("\\$\\{env\\.([^\\}]*)\\}");
            Matcher m = p.matcher(url);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                value = System.getenv(m.group(1));
                if (value == null) continue;
                m.appendReplacement(sb, Matcher.quoteReplacement(value));
            }
            m.appendTail(sb);
            url = sb.toString();
            p = Pattern.compile("\\$\\{system\\.([^\\}]*)\\}");
            m = p.matcher(url);
            sb = new StringBuffer();
            while (m.find()) {
                value = System.getProperty(m.group(1));
                if (value == null) continue;
                m.appendReplacement(sb, Matcher.quoteReplacement(value));
            }
            m.appendTail(sb);
            url = sb.toString();
            if (url.indexOf("${home.location}") != -1) {
                url = url.replace("${home.location}", ProvisioningActivator.getConfigurationService().getScHomeDirLocation());
            }
            if (url.indexOf("${home.name}") != -1) {
                url = url.replace("${home.name}", ProvisioningActivator.getConfigurationService().getScHomeDirName());
            }
            if (url.indexOf("${uuid}") != -1) {
                url = url.replace("${uuid}", (String)ProvisioningActivator.getConfigurationService().getProperty(PROVISIONING_UUID_PROP));
            }
            if (url.indexOf("${osname}") != -1) {
                url = url.replace("${osname}", System.getProperty("os.name"));
            }
            if (url.indexOf("${arch}") != -1) {
                url = url.replace("${arch}", System.getProperty("os.arch"));
            }
            if (url.indexOf("${resx}") != -1 || url.indexOf("${resy}") != -1) {
                Rectangle screen = ScreenInformation.getScreenBounds();
                if (url.indexOf("${resx}") != -1) {
                    url = url.replace("${resx}", String.valueOf(screen.width));
                }
                if (url.indexOf("${resy}") != -1) {
                    url = url.replace("${resy}", String.valueOf(screen.height));
                }
            }
            if (url.indexOf("${build}") != -1) {
                url = url.replace("${build}", System.getProperty("sip-communicator.version"));
            }
            if (url.indexOf("${locale}") != -1) {
                String locale = ProvisioningActivator.getConfigurationService().getString("net.java.sip.communicator.service.resources.DefaultLocale");
                if (locale == null) {
                    locale = "";
                }
                url = url.replace("${locale}", locale);
            }
            if (url.indexOf("${ipaddr}") != -1) {
                url = url.replace("${ipaddr}", ipaddr.getHostAddress());
            }
            if (url.indexOf("${hostname}") != -1) {
                String name = OSUtils.IS_WINDOWS ? System.getenv("COMPUTERNAME") : ipaddr.getHostName();
                url = url.replace("${hostname}", name);
            }
            if (url.indexOf("${hwaddr}") != -1 && ipaddr != null) {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                block8: while (en.hasMoreElements()) {
                    NetworkInterface iface = en.nextElement();
                    Enumeration<InetAddress> enInet = iface.getInetAddresses();
                    while (enInet.hasMoreElements()) {
                        byte[] hw;
                        InetAddress inet = enInet.nextElement();
                        if (!inet.equals(ipaddr) || (hw = ProvisioningActivator.getNetworkAddressManagerService().getHardwareAddress(iface)) == null || hw.length == 0) continue;
                        StringBuffer buf = new StringBuffer();
                        for (int n : hw) {
                            int hi = n >= 0 ? n : n + 256;
                            String t = new String(hi <= 15 ? "0" : "");
                            t = t + Integer.toHexString(hi);
                            buf.append(t);
                            buf.append(":");
                        }
                        buf.deleteCharAt(buf.length() - 1);
                        url = url.replace("${hwaddr}", buf.toString());
                        continue block8;
                    }
                }
            }
            if (url.contains("?")) {
                if (url.indexOf(63) + 1 != url.length()) {
                    arg = url.substring(url.indexOf(63) + 1);
                    args = arg.split("&");
                }
                url = url.substring(0, url.indexOf(63));
            }
            ArrayList<Object> paramNames = null;
            ArrayList<String> paramValues = null;
            int usernameIx = -1;
            int passwordIx = -1;
            if (args != null && args.length > 0) {
                paramNames = new ArrayList<Object>(args.length);
                paramValues = new ArrayList<String>(args.length);
                String usernameParam = "${username}";
                String passwordParam = "${password}";
                for (int i = 0; i < args.length; ++i) {
                    void var19_34;
                    String s = args[i];
                    int equalsIndex = s.indexOf("=");
                    Object var19_32 = null;
                    if (equalsIndex > -1) {
                        String string = s.substring(0, equalsIndex);
                    }
                    String preloadedParamValue = ProvisioningServiceImpl.getParamValue(parameters, (String)var19_34);
                    if (s.indexOf(usernameParam) != -1) {
                        s = preloadedParamValue != null ? s.replace(usernameParam, preloadedParamValue) : s.replace(usernameParam, "");
                        usernameIx = paramNames.size();
                    } else if (s.indexOf(passwordParam) != -1) {
                        s = preloadedParamValue != null ? s.replace(passwordParam, preloadedParamValue) : s.replace(passwordParam, "");
                        passwordIx = paramNames.size();
                    }
                    if (equalsIndex > -1) {
                        paramNames.add(var19_34);
                        paramValues.add(s.substring(equalsIndex + 1));
                        continue;
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Invalid provisioning request parameter: \"" + s + "\", is replaced by \"" + s + "=\""));
                    }
                    paramNames.add(s);
                    paramValues.add("");
                }
            }
            HttpUtils.HTTPResponseResult res = null;
            Throwable errorWhileProvisioning = null;
            try {
                res = HttpUtils.postForm((String)url, (String)PROPERTY_PROVISIONING_USERNAME, (String)PROPERTY_PROVISIONING_PASSWORD, paramNames, paramValues, (int)usernameIx, (int)passwordIx, (HttpUtils.RedirectHandler)new HttpUtils.RedirectHandler(){

                    public boolean handleRedirect(String location, List<NameValuePair> parameters) {
                        if (!this.hasParams(location)) {
                            return false;
                        }
                        ProvisioningServiceImpl.this.retrieveConfigurationFile(location, parameters);
                        return true;
                    }

                    public boolean hasParams(String location) {
                        return location.contains("${");
                    }
                });
            }
            catch (Throwable t) {
                logger.error((Object)"Error posting form", t);
                errorWhileProvisioning = t;
            }
            if (res == null) {
                if (ProvisioningActivator.getConfigurationService().getBoolean(PROPERTY_PROVISIONING_MANDATORY, false)) {
                    String errorMsg = errorWhileProvisioning != null ? errorWhileProvisioning.getLocalizedMessage() : "";
                    ErrorDialog ed = new ErrorDialog(null, ProvisioningActivator.getResourceService().getI18NString("plugin.provisioning.PROV_FAILED"), ProvisioningActivator.getResourceService().getI18NString("plugin.provisioning.PROV_FAILED_MSG", new String[]{errorMsg}), errorWhileProvisioning);
                    ed.setModal(true);
                    ed.showDialog();
                    for (Bundle b : ProvisioningActivator.bundleContext.getBundles()) {
                        try {
                            if (ProvisioningActivator.bundleContext.equals(b.getBundleContext())) continue;
                            b.stop();
                        }
                        catch (BundleException ex) {
                            logger.error((Object)("Failed to being gentle stop " + b.getLocation()), (Throwable)ex);
                        }
                    }
                }
                return null;
            }
            String[] userPass = res.getCredentials();
            if (userPass[0] != null && userPass[1] != null) {
                provUsername = userPass[0];
                provPassword = userPass[1];
            }
            InputStream in = res.getContent();
            if (!OSUtils.IS_ANDROID) {
                ProgressMonitorInputStream pin = new ProgressMonitorInputStream(null, u.toString(), in);
                ProgressMonitor progressMonitor = pin.getProgressMonitor();
                progressMonitor.setMaximum((int)res.getContentLength());
                return pin;
            }
            return in;
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Error retrieving provisioning file!", (Throwable)e);
            }
            return null;
        }
    }

    private static String getParamValue(List<NameValuePair> parameters, String paramName) {
        if (parameters == null || paramName == null) {
            return null;
        }
        for (NameValuePair nv : parameters) {
            if (!nv.getName().equals(paramName)) continue;
            return nv.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfiguration(InputStream data) {
        OrderedProperties fileProps = new OrderedProperties();
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(data);
            fileProps.load(in);
            for (Map.Entry<Object, Object> entry : fileProps.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (key.trim().length() == 0) continue;
                if (key.equals(PROVISIONING_ALLOW_PREFIX_PROP)) {
                    String[] prefixes;
                    for (String s : prefixes = ((String)value).split("\\|")) {
                        this.allowedPrefixes.add(s);
                    }
                    continue;
                }
                if (key.equals(PROVISIONING_ENFORCE_PREFIX_PROP)) {
                    this.checkEnforcePrefix((String)value);
                    continue;
                }
                if (!this.isPrefixAllowed(key)) continue;
                this.processProperty(key, value);
            }
            try {
                ProvisioningActivator.getConfigurationService().storeConfiguration();
                ProvisioningActivator.getConfigurationService().reloadConfiguration();
            }
            catch (Exception e) {
                logger.error((Object)"Cannot reload configuration");
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Error during load of provisioning file");
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean isPrefixAllowed(String key) {
        if (this.allowedPrefixes.size() > 0) {
            for (String s : this.allowedPrefixes) {
                if (!key.startsWith(s)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void processProperty(String key, Object value) {
        if (value instanceof String && value.equals("${null}")) {
            ProvisioningActivator.getConfigurationService().removeProperty(key);
        } else {
            if (key.endsWith(".PASSWORD")) {
                ProvisioningActivator.getCredentialsStorageService().storePassword(key.substring(0, key.lastIndexOf(".")), (String)value);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(key + "=<password hidden>"));
                }
                return;
            }
            if (key.startsWith(SYSTEM_PROP_PREFIX)) {
                String sysKey = key.substring(SYSTEM_PROP_PREFIX.length(), key.length());
                System.setProperty(sysKey, (String)value);
            } else {
                ProvisioningActivator.getConfigurationService().setProperty(key, value);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)(key + "=" + value));
        }
    }

    private void checkEnforcePrefix(String enforcePrefix) {
        ConfigurationService config = ProvisioningActivator.getConfigurationService();
        String[] prefixes = null;
        if (enforcePrefix == null) {
            return;
        }
        prefixes = enforcePrefix.split("\\|");
        for (String key : config.getAllPropertyNames()) {
            boolean isValid = false;
            for (String k : prefixes) {
                if (!key.startsWith(k)) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            config.removeProperty(key);
        }
    }
}

