/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.List;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicInstantMessagingJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.AbstractOperationSetTypingNotifications;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.ChatState;
import org.jivesoftware.smackx.MessageEventManager;
import org.jivesoftware.smackx.MessageEventNotificationListener;
import org.jivesoftware.smackx.MessageEventRequestListener;
import org.jivesoftware.smackx.packet.ChatStateExtension;

public class OperationSetTypingNotificationsJabberImpl
extends AbstractOperationSetTypingNotifications<ProtocolProviderServiceJabberImpl> {
    private static final Logger logger = Logger.getLogger(OperationSetTypingNotificationsJabberImpl.class);
    private OperationSetPersistentPresenceJabberImpl opSetPersPresence = null;
    private OperationSetBasicInstantMessagingJabberImpl opSetBasicIM = null;
    private ProviderRegListener providerRegListener = new ProviderRegListener();
    private MessageEventManager messageEventManager = null;
    private SmackChatStateListener smackChatStateListener = null;

    OperationSetTypingNotificationsJabberImpl(ProtocolProviderServiceJabberImpl provider) {
        super((ProtocolProviderService)provider);
        provider.addRegistrationStateChangeListener(this.providerRegListener);
    }

    public void sendTypingNotification(Contact notifiedContact, int typingState) throws IllegalStateException, IllegalArgumentException {
        this.assertConnected();
        if (!(notifiedContact instanceof ContactJabberImpl)) {
            throw new IllegalArgumentException("The specified contact is not a Jabber contact." + notifiedContact);
        }
        this.sendXep85ChatState(notifiedContact, typingState);
    }

    private void sendXep85ChatState(Contact contact, int state) {
        if (this.opSetBasicIM == null || ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null) {
            return;
        }
        String toJID = this.opSetBasicIM.getRecentJIDForAddress(contact.getAddress());
        if (toJID == null) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Sending XEP-0085 chat state=" + state + " to " + toJID));
        }
        ChatState chatState = state == 1 ? ChatState.composing : (state == 4 ? ChatState.inactive : (state == 3 ? ChatState.paused : ChatState.gone));
        this.setCurrentState(chatState, toJID);
    }

    private void setCurrentState(ChatState chatState, String jid) {
        String threadID = this.opSetBasicIM.getThreadIDForAddress(jid);
        if (threadID == null) {
            return;
        }
        Message message = new Message();
        ChatStateExtension extension = new ChatStateExtension(chatState);
        message.addExtension((PacketExtension)extension);
        message.setTo(jid);
        message.setType(Message.Type.chat);
        message.setThread(threadID);
        message.setFrom(((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().getUser());
        ((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection().sendPacket((Packet)message);
    }

    protected void assertConnected() throws IllegalStateException {
        if (this.parentProvider != null && !((ProtocolProviderServiceJabberImpl)this.parentProvider).isRegistered() && this.opSetPersPresence.getPresenceStatus().isOnline()) {
            this.opSetPersPresence.fireProviderStatusChangeEvent(this.opSetPersPresence.getPresenceStatus(), (PresenceStatus)((ProtocolProviderServiceJabberImpl)this.parentProvider).getJabberStatusEnum().getStatus("Offline"));
        }
        super.assertConnected();
    }

    private class SmackChatStateListener
    implements PacketListener {
        private SmackChatStateListener() {
        }

        public void stateChanged(ChatState state, Message message) {
            Object sourceContact;
            String fromJID = message.getFrom();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(fromJID + " entered the " + state.name() + " state."));
            }
            String fromID = StringUtils.parseBareAddress((String)fromJID);
            boolean isPrivateMessagingAddress = false;
            OperationSetMultiUserChat mucOpSet = (OperationSetMultiUserChat)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetMultiUserChat.class);
            if (mucOpSet != null) {
                List chatRooms = mucOpSet.getCurrentlyJoinedChatRooms();
                for (ChatRoom chatRoom : chatRooms) {
                    if (!chatRoom.getName().equals(fromID)) continue;
                    isPrivateMessagingAddress = true;
                    break;
                }
            }
            if ((sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(isPrivateMessagingAddress ? message.getFrom() : fromID)) == null) {
                if (message.getError() != null) {
                    sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(message.getFrom());
                }
                if (sourceContact == null) {
                    sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(message.getFrom(), isPrivateMessagingAddress);
                }
            }
            int evtCode = 0;
            if (ChatState.composing.equals((Object)state)) {
                evtCode = 1;
            } else if (ChatState.paused.equals((Object)state) || ChatState.active.equals((Object)state)) {
                evtCode = 3;
            } else if (ChatState.inactive.equals((Object)state) || ChatState.gone.equals((Object)state)) {
                evtCode = 4;
            }
            if (message.getError() != null) {
                OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsDeliveryFailedEvent((Contact)sourceContact, evtCode);
            } else if (evtCode != 0) {
                OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, evtCode);
            } else {
                logger.warn((Object)"Unknown typing state!");
            }
        }

        public void processPacket(Packet packet) {
            Message msg = (Message)packet;
            ChatStateExtension ext = (ChatStateExtension)msg.getExtension("http://jabber.org/protocol/chatstates");
            if (ext == null) {
                return;
            }
            this.stateChanged(ChatState.valueOf((String)ext.getElementName()), msg);
        }
    }

    private class IncomingMessageEventsListener
    implements MessageEventNotificationListener {
        private IncomingMessageEventsListener() {
        }

        public void deliveredNotification(String from, String packetID) {
        }

        public void displayedNotification(String from, String packetID) {
        }

        public void composingNotification(String from, String packetID) {
            String fromID = StringUtils.parseBareAddress((String)from);
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(fromID);
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(from);
            }
            OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, 1);
        }

        public void offlineNotification(String from, String packetID) {
        }

        public void cancelledNotification(String from, String packetID) {
            String fromID = StringUtils.parseBareAddress((String)from);
            Object sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.findContactByID(fromID);
            if (sourceContact == null) {
                sourceContact = OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence.createVolatileContact(from);
            }
            OperationSetTypingNotificationsJabberImpl.this.fireTypingNotificationsEvent((Contact)sourceContact, 4);
        }
    }

    private class JabberMessageEventRequestListener
    implements MessageEventRequestListener {
        private JabberMessageEventRequestListener() {
        }

        public void deliveredNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
            messageEventManager.sendDeliveredNotification(from, packetID);
        }

        public void displayedNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
            messageEventManager.sendDisplayedNotification(from, packetID);
        }

        public void composingNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
        }

        public void offlineNotificationRequested(String from, String packetID, MessageEventManager messageEventManager) {
        }
    }

    private class ProviderRegListener
    implements RegistrationStateChangeListener {
        private ProviderRegListener() {
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("The provider changed state from: " + evt.getOldState() + " to: " + evt.getNewState()));
            }
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                OperationSetTypingNotificationsJabberImpl.this.opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetPersistentPresence.class);
                OperationSetTypingNotificationsJabberImpl.this.opSetBasicIM = (OperationSetBasicInstantMessagingJabberImpl)((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getOperationSet(OperationSetBasicInstantMessaging.class);
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager = new MessageEventManager(((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection());
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager.addMessageEventRequestListener((MessageEventRequestListener)new JabberMessageEventRequestListener());
                OperationSetTypingNotificationsJabberImpl.this.messageEventManager.addMessageEventNotificationListener((MessageEventNotificationListener)new IncomingMessageEventsListener());
                if (OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener == null) {
                    OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener = new SmackChatStateListener();
                }
                ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().addPacketListener((PacketListener)OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener, (PacketFilter)new PacketTypeFilter(Message.class));
            } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
                if (((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection() != null) {
                    ((ProtocolProviderServiceJabberImpl)OperationSetTypingNotificationsJabberImpl.this.parentProvider).getConnection().removePacketListener((PacketListener)OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener);
                }
                OperationSetTypingNotificationsJabberImpl.this.smackChatStateListener = null;
                if (OperationSetTypingNotificationsJabberImpl.this.messageEventManager != null) {
                    OperationSetTypingNotificationsJabberImpl.this.messageEventManager.destroy();
                    OperationSetTypingNotificationsJabberImpl.this.messageEventManager = null;
                }
            }
        }
    }
}

