/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets;

import com.explodingpixels.macwidgets.SourceListCategory;
import com.explodingpixels.macwidgets.SourceListItem;
import com.explodingpixels.macwidgets.SourceListModelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceListModel {
    private List<SourceListCategory> fCategories = new ArrayList<SourceListCategory>();
    private List<SourceListModelListener> fListeners = new ArrayList<SourceListModelListener>();
    private PropertyChangeListener fPropertyChangeListener = this.createSourceListItemListener();

    public List<SourceListCategory> getCategories() {
        return Collections.unmodifiableList(this.fCategories);
    }

    public void addCategory(SourceListCategory category) {
        this.addCategory(category, this.fCategories.size());
    }

    public void addCategory(SourceListCategory category, int index) {
        this.fCategories.add(index, category);
        this.fireCategoryAdded(category, index);
    }

    public void removeCategory(SourceListCategory category) {
        boolean removed = this.fCategories.remove(category);
        if (!removed) {
            throw new IllegalArgumentException("The given category does not exist in this model.");
        }
        this.fireCategoryRemoved(category);
    }

    public void removeCategoryAt(int index) {
        SourceListCategory category = this.fCategories.remove(index);
        if (category == null) {
            throw new IllegalArgumentException("There is no category at the index " + index + ".");
        }
        this.fireCategoryRemoved(category);
    }

    public void addItemToCategory(SourceListItem item, SourceListCategory category) {
        this.addItemToCategory(item, category, category.getItemCount());
    }

    public void addItemToCategory(SourceListItem item, SourceListCategory category, int index) {
        this.validateCategoryIsInModel(category);
        category.addItem(index, item);
        item.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fireItemAddedToCategory(item, category, index);
    }

    public void addItemToItem(SourceListItem childItem, SourceListItem parentItem) {
        this.addItemToItem(childItem, parentItem, parentItem.getChildItems().size());
    }

    public void addItemToItem(SourceListItem childItem, SourceListItem parentItem, int index) {
        this.validateItemIsInModel(parentItem);
        parentItem.addItem(index, childItem);
        childItem.addPropertyChangeListener(this.fPropertyChangeListener);
        this.fireItemAddedToItem(childItem, parentItem, index);
    }

    public void removeItemFromCategory(SourceListItem item, SourceListCategory category) {
        this.validateItemIsInModel(item);
        this.validateCategoryIsInModel(category);
        category.removeItem(item);
        item.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fireItemRemovedFromCategory(item, category);
    }

    public void removeItemFromCategoryAtIndex(SourceListCategory category, int index) {
        this.removeItemFromCategory(category.getItem(index), category);
    }

    public void removeItemFromItem(SourceListItem childItem, SourceListItem parentItem) {
        this.validateItemIsInModel(childItem);
        this.validateItemIsInModel(parentItem);
        parentItem.removeItem(childItem);
        childItem.removePropertyChangeListener(this.fPropertyChangeListener);
        this.fireItemRemovedFromItem(childItem, parentItem);
    }

    public void removeItemFromItem(SourceListItem parentItem, int index) {
        this.validateItemIsInModel(parentItem);
        SourceListItem itemRemoved = parentItem.removeItem(index);
        this.fireItemRemovedFromItem(itemRemoved, parentItem);
    }

    private PropertyChangeListener createSourceListItemListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SourceListItem item = (SourceListItem)event.getSource();
                SourceListModel.this.fireItemChanged(item);
            }
        };
    }

    private void validateCategoryIsInModel(SourceListCategory category) {
        if (!this.fCategories.contains(category)) {
            throw new IllegalArgumentException("The " + category.getText() + " category is not part of this model.");
        }
    }

    public void validateItemIsInModel(SourceListItem item) {
        SourceListCategory category;
        boolean found = false;
        Iterator<SourceListCategory> i$ = this.fCategories.iterator();
        while (i$.hasNext() && !(found = (category = i$.next()).containsItem(item))) {
        }
        if (!found) {
            throw new IllegalArgumentException("The given item is not part of this model.");
        }
    }

    private void fireCategoryAdded(SourceListCategory category, int index) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.categoryAdded(category, index);
        }
    }

    private void fireCategoryRemoved(SourceListCategory category) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.categoryRemoved(category);
        }
    }

    private void fireItemAddedToCategory(SourceListItem item, SourceListCategory category, int index) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.itemAddedToCategory(item, category, index);
        }
    }

    private void fireItemRemovedFromCategory(SourceListItem item, SourceListCategory category) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.itemRemovedFromCategory(item, category);
        }
    }

    private void fireItemAddedToItem(SourceListItem childItem, SourceListItem parentItem, int index) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.itemAddedToItem(childItem, parentItem, index);
        }
    }

    private void fireItemRemovedFromItem(SourceListItem childItem, SourceListItem parentItem) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.itemRemovedFromItem(childItem, parentItem);
        }
    }

    private void fireItemChanged(SourceListItem item) {
        for (SourceListModelListener listener : this.fListeners) {
            listener.itemChanged(item);
        }
    }

    public void addSourceListModelListener(SourceListModelListener listener) {
        this.fListeners.add(listener);
    }

    public void removeSourceListModelListener(SourceListModelListener listener) {
        this.fListeners.remove(listener);
    }
}

