/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.lookandfeel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;
import net.java.sip.communicator.util.skin.Skinnable;

public class SIPCommScrollBarUI
extends MetalScrollBarUI
implements Skinnable {
    private BufferedImage horizontalThumb;
    private BufferedImage verticalThumb;
    private BufferedImage horizontalThumbHandle;
    private BufferedImage verticalThumbHandle;

    public SIPCommScrollBarUI() {
        this.loadSkin();
    }

    public static ComponentUI createUI(JComponent c) {
        return new SIPCommScrollBarUI();
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        g.translate(trackBounds.x, trackBounds.y);
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                trackBounds.width += 2;
                if (!leftToRight) {
                    g.translate(-1, 0);
                }
            }
            g.setColor(this.trackColor);
            g.fillRect(0, 0, trackBounds.width - 2, trackBounds.height);
            g.setColor(this.trackHighlightColor);
            g.drawRect(0, 0, trackBounds.width - 2, trackBounds.height);
            if (!this.isFreeStanding) {
                trackBounds.width -= 2;
                if (!leftToRight) {
                    g.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                trackBounds.height += 2;
            }
            g.setColor(this.trackColor);
            g.fillRect(0, 0, trackBounds.width, trackBounds.height - 2);
            g.setColor(this.trackHighlightColor);
            g.drawRect(0, 0, trackBounds.width, trackBounds.height - 2);
            if (!this.isFreeStanding) {
                trackBounds.height -= 2;
            }
        }
        g.translate(-trackBounds.x, -trackBounds.y);
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        if (!c.isEnabled()) {
            return;
        }
        boolean leftToRight = c.getComponentOrientation().isLeftToRight();
        g.translate(thumbBounds.x, thumbBounds.y);
        int indentWidth = 10;
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                thumbBounds.width += 2;
                if (!leftToRight) {
                    g.translate(-1, 0);
                }
            }
            int imgWidth = this.verticalThumb.getWidth();
            int imgHeight = this.verticalThumb.getHeight();
            BufferedImage topImage = this.verticalThumb.getSubimage(0, 0, imgWidth, indentWidth);
            BufferedImage middleImage = this.verticalThumb.getSubimage(0, indentWidth, imgWidth, imgHeight - 2 * indentWidth);
            BufferedImage bottomImage = this.verticalThumb.getSubimage(0, imgHeight - indentWidth, imgWidth, indentWidth);
            g.drawImage(topImage, 0, 0, thumbBounds.width - 2, indentWidth, null);
            g.drawImage(middleImage, thumbBounds.x, indentWidth, thumbBounds.width - 2, thumbBounds.height - indentWidth, null);
            g.drawImage(bottomImage, thumbBounds.x, thumbBounds.height - indentWidth, thumbBounds.width - 2, indentWidth, null);
            g.drawImage(this.verticalThumbHandle, thumbBounds.width / 2 - this.verticalThumbHandle.getWidth() / 2, thumbBounds.height / 2 - this.verticalThumbHandle.getHeight() / 2, this.verticalThumbHandle.getWidth(), this.verticalThumbHandle.getHeight(), null);
            if (!this.isFreeStanding) {
                thumbBounds.width -= 2;
                if (!leftToRight) {
                    g.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                thumbBounds.height += 2;
            }
            int imgWidth = this.horizontalThumb.getWidth();
            int imgHeight = this.horizontalThumb.getHeight();
            BufferedImage leftImage = this.horizontalThumb.getSubimage(0, 0, indentWidth, imgHeight);
            BufferedImage middleImage = this.horizontalThumb.getSubimage(indentWidth, 0, imgWidth - 2 * indentWidth, imgHeight);
            BufferedImage rightImage = this.horizontalThumb.getSubimage(imgWidth - indentWidth, 0, indentWidth, imgHeight);
            g.drawImage(leftImage, 0, 0, indentWidth, thumbBounds.height - 2, null);
            g.drawImage(middleImage, indentWidth, thumbBounds.y, thumbBounds.width - indentWidth, thumbBounds.height - 2, null);
            g.drawImage(rightImage, thumbBounds.width - indentWidth, thumbBounds.y, indentWidth, thumbBounds.height - 2, null);
            g.drawImage(this.horizontalThumbHandle, thumbBounds.width / 2 - this.horizontalThumbHandle.getWidth() / 2, thumbBounds.height / 2 - this.horizontalThumbHandle.getHeight() / 2, this.horizontalThumbHandle.getWidth(), this.horizontalThumbHandle.getHeight(), null);
            if (!this.isFreeStanding) {
                thumbBounds.height -= 2;
            }
        }
        g.translate(-thumbBounds.x, -thumbBounds.y);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.verticalThumbHandle.getHeight() + 4);
        }
        return new Dimension(this.horizontalThumbHandle.getWidth() + 4, this.scrollBarWidth);
    }

    public void loadSkin() {
        this.horizontalThumb = (BufferedImage)UIManager.get("ScrollBar.horizontalThumbIcon");
        this.verticalThumb = (BufferedImage)UIManager.get("ScrollBar.verticalThumbIcon");
        this.horizontalThumbHandle = (BufferedImage)UIManager.get("ScrollBar.horizontalThumbHandleIcon");
        this.verticalThumbHandle = (BufferedImage)UIManager.get("ScrollBar.verticalThumbHandleIcon");
    }
}

