/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.ChooseCallAccountPopupMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.plugin.desktoputil.event.TextFieldChangeListener;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.skin.Skinnable;

public class CallButton
extends SIPCommButton
implements Skinnable,
TextFieldChangeListener {
    private Image image;
    private Image pressedImage;
    private Image rolloverImage;
    private final MainFrame mainFrame;
    private final String defaultTooltip = GuiActivator.getResources().getI18NString("service.gui.CALL_NAME_OR_NUMBER");

    public CallButton(final MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.loadSkin();
        mainFrame.addSearchFieldListener(this);
        this.setToolTipText(this.defaultTooltip);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<ProtocolProviderService> telephonyProviders = CallManager.getTelephonyProviders();
                String searchText = mainFrame.getCurrentSearchText();
                if (telephonyProviders.size() == 1) {
                    CallManager.createCall(telephonyProviders.get(0), searchText);
                } else if (telephonyProviders.size() > 1) {
                    ChooseCallAccountPopupMenu chooseAccountDialog = new ChooseCallAccountPopupMenu((JComponent)((Object)CallButton.this), searchText, telephonyProviders);
                    chooseAccountDialog.setLocation(CallButton.this.getLocation());
                    chooseAccountDialog.showPopupMenu();
                }
            }
        });
    }

    public void loadSkin() {
        this.image = GuiActivator.getResources().getImage(ImageLoader.CALL_BUTTON_SMALL.getId()).getImage();
        this.pressedImage = GuiActivator.getResources().getImage(ImageLoader.CALL_BUTTON_SMALL_PRESSED.getId()).getImage();
        this.rolloverImage = GuiActivator.getResources().getImage(ImageLoader.CALL_BUTTON_SMALL_ROLLOVER.getId()).getImage();
        this.setBackgroundImage(this.image);
        this.setPressedImage(this.pressedImage);
        this.setRolloverImage(this.rolloverImage);
    }

    public void textInserted() {
        this.updateTooltip();
    }

    public void textRemoved() {
        this.updateTooltip();
    }

    private void updateTooltip() {
        String searchText = this.mainFrame.getCurrentSearchText();
        if (searchText != null && searchText.length() > 0) {
            this.setToolTipText(GuiActivator.getResources().getI18NString("service.gui.CALL") + " " + searchText);
        } else {
            this.setToolTipText(this.defaultTooltip);
        }
    }
}

