/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.customcontrols.SIPCommNotificationsButton;
import net.java.sip.communicator.impl.gui.main.UINotification;
import net.java.sip.communicator.impl.gui.main.UINotificationGroup;
import net.java.sip.communicator.impl.gui.main.UINotificationListener;
import net.java.sip.communicator.impl.gui.main.UINotificationManager;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.util.GuiUtils;
import net.java.sip.communicator.util.skin.Skinnable;

public class CallHistoryButton
extends SIPCommNotificationsButton
implements UINotificationListener,
ActionListener,
Skinnable {
    private static final String callHistoryToolTip = GuiActivator.getResources().getI18NString("service.gui.CALL_HISTORY_TOOL_TIP");
    private static final String showContactListToolTip = GuiActivator.getResources().getI18NString("service.gui.SHOW_CONTACT_LIST_TOOL_TIP");

    public CallHistoryButton() {
        super("");
        UINotificationManager.addNotificationListener(this);
        this.setToolTipText(callHistoryToolTip);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isToggleDisabled() && GuiActivator.getContactList().getCurrentFilter().equals(TreeContactList.historyFilter)) {
            return;
        }
        if (!this.isToggleDisabled() && this.isHistoryVisible() && !this.hasNotifications()) {
            GuiActivator.getContactList().setDefaultFilter(TreeContactList.presenceFilter);
            GuiActivator.getContactList().applyDefaultFilter();
            this.setHistoryVisible(false);
        } else {
            GuiActivator.getContactList().setDefaultFilter(TreeContactList.historyFilter);
            GuiActivator.getContactList().applyDefaultFilter();
            UINotificationManager.removeAllNotifications();
            this.setHistoryVisible(true);
        }
        this.setHistoryView();
        GuiActivator.getContactList().requestFocusInWindow();
        this.repaint();
    }

    @Override
    public void notificationReceived(UINotification notification) {
        Collection<UINotificationGroup> notificationGroups = UINotificationManager.getNotificationGroups();
        if (!this.isHistoryVisible() && notificationGroups.size() > 0) {
            this.setNotificationView(notificationGroups);
        } else {
            this.setHistoryView();
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void notificationCleared(UINotification notification) {
    }

    private void setHistoryView() {
        this.clearNotifications();
        if (!this.isToggleDisabled() && this.isHistoryVisible()) {
            this.setToolTipText(showContactListToolTip);
        } else {
            this.setToolTipText(callHistoryToolTip);
        }
    }

    private void setNotificationView(final Collection<UINotificationGroup> notificationGroups) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CallHistoryButton.this.setNotificationView(notificationGroups);
                }
            });
            return;
        }
        int notificationCount = 0;
        Iterator<UINotificationGroup> groupsIter = notificationGroups.iterator();
        String tooltipText = "<html>";
        while (groupsIter.hasNext()) {
            UINotificationGroup group = groupsIter.next();
            tooltipText = tooltipText + "<b>" + group.getGroupDisplayName() + "</b><br/>";
            notificationCount += group.getUnreadNotificationsCount();
            int visibleNotifsPerGroup = 5;
            Iterator<UINotification> notifsIter = group.getUnreadNotifications();
            while (notifsIter.hasNext() && visibleNotifsPerGroup > 0) {
                UINotification missedCall = notifsIter.next();
                tooltipText = tooltipText + GuiUtils.formatTime((long)missedCall.getTime()) + "   " + missedCall.getDisplayName() + "<br/>";
                if (--visibleNotifsPerGroup != 0 || !notifsIter.hasNext()) continue;
                tooltipText = tooltipText + GuiActivator.getResources().getI18NString("service.gui.MISSED_CALLS_MORE_TOOL_TIP", new String[]{new Integer(notificationCount - 5).toString()});
            }
        }
        this.setToolTipText(tooltipText + "</html>");
        this.setNotifications(notificationCount);
    }

    private boolean isHistoryVisible() {
        return this.isDefaultViewVisible();
    }

    private void setHistoryVisible(boolean value) {
        this.setDefaultViewVisible(value);
    }

    @Override
    public void loadSkin() {
        this.defaultImage = ImageLoader.getImage(ImageLoader.CALL_HISTORY_BUTTON);
        if (!this.isToggleDisabled()) {
            this.pressedImage = ImageLoader.getImage(ImageLoader.CALL_HISTORY_BUTTON_PRESSED);
        }
        this.setHistoryView();
        super.loadSkin();
    }
}

