/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.DTMFHandler;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.resources.ResourceManagementService;

public class DialPanel
extends JPanel
implements MouseListener,
Skinnable {
    private final JPanel dialPadPanel;
    private final DTMFHandler dtmfHandler;

    public DialPanel(DTMFHandler dtmfHandler) {
        this.dtmfHandler = dtmfHandler;
        ResourceManagementService r = GuiActivator.getResources();
        int hgap = r.getSettingsInt("impl.gui.DIAL_PAD_HORIZONTAL_GAP");
        int vgap = r.getSettingsInt("impl.gui.DIAL_PAD_VERTICAL_GAP");
        int width = r.getSettingsInt("impl.gui.DIAL_PAD_WIDTH");
        int height = r.getSettingsInt("impl.gui.DIAL_PAD_HEIGHT");
        this.dialPadPanel = new JPanel(new GridLayout(4, 3, hgap, vgap));
        this.dialPadPanel.setOpaque(false);
        this.dialPadPanel.setPreferredSize(new Dimension(width, height));
        this.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.add((Component)this.dialPadPanel, "Center");
        this.loadSkin();
    }

    private JButton createDialButton(Image bgImage, ImageID iconImage, String name) {
        SIPCommButton button = new SIPCommButton(bgImage, (Image)ImageLoader.getImage(iconImage));
        button.setAlignmentY(0.0f);
        button.setName(name);
        button.setOpaque(false);
        button.addMouseListener(this);
        return button;
    }

    public void loadSkin() {
        this.dialPadPanel.removeAll();
        BufferedImage bgImage = ImageLoader.getImage(ImageLoader.DIAL_BUTTON_BG);
        DTMFHandler.DTMFToneInfo[] availableTones = DTMFHandler.AVAILABLE_TONES;
        for (int i = 0; i < availableTones.length; ++i) {
            DTMFHandler.DTMFToneInfo info = availableTones[i];
            if (info.imageID == null) continue;
            this.dialPadPanel.add(this.createDialButton(bgImage, info.imageID, info.tone.getValue()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        this.dtmfHandler.startSendingDtmfTone(ev.getComponent().getName());
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        this.dtmfHandler.stopSendingDtmfTone();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        BufferedImage bgImage = ImageLoader.getImage(ImageLoader.MAIN_WINDOW_BACKGROUND);
        if (bgImage != null) {
            ResourceManagementService r = GuiActivator.getResources();
            boolean isTextureBackground = Boolean.parseBoolean(r.getSettingsString("impl.gui.IS_CONTACT_LIST_TEXTURE_BG_ENABLED"));
            int width = this.getWidth();
            int height = this.getHeight();
            if (isTextureBackground) {
                Rectangle rect = new Rectangle(0, 0, bgImage.getWidth(null), bgImage.getHeight(null));
                TexturePaint texture = new TexturePaint(bgImage, rect);
                g2.setPaint(texture);
                g2.fillRect(0, 0, width, height);
            } else {
                g.setColor(new Color(r.getColor("contactListBackground")));
                g.fillRect(0, 0, width, height);
                g2.drawImage((Image)bgImage, width - bgImage.getWidth(), height - bgImage.getHeight(), this);
            }
        }
    }
}

