/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.ViewportLayout;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CallTransferHandler;
import net.java.sip.communicator.impl.gui.main.call.ConferenceCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceCallPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferenceFocusPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.ConferencePeerPanel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;

public class AudioConferenceCallPanel
extends BasicConferenceCallPanel {
    private static final Dimension SCROLL_PANE_MINIMUM_SIZE = new Dimension(400, 100);
    private final GridBagConstraints constraints;
    private final TransparentPanel mainPanel;
    private final JScrollPane scrollPane;
    private final Runnable scrollToBottomRunnable = new Runnable(){

        @Override
        public void run() {
            JScrollBar verticalScrollBar = AudioConferenceCallPanel.this.scrollPane.getVerticalScrollBar();
            if (verticalScrollBar != null) {
                verticalScrollBar.setValue(verticalScrollBar.getMaximum());
            }
        }
    };

    public AudioConferenceCallPanel(CallPanel callPanel, CallConference callConference) {
        super(callPanel, callConference);
        this.mainPanel = new TransparentPanel();
        this.mainPanel.setLayout((LayoutManager)new GridBagLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setViewportView((Component)this.mainPanel);
        this.scrollPane.setOpaque(false);
        this.scrollPane.getViewport().setOpaque(false);
        this.scrollPane.setBorder(null);
        this.scrollPane.setMinimumSize(SCROLL_PANE_MINIMUM_SIZE);
        this.mainPanel.setTransferHandler((TransferHandler)((Object)new CallTransferHandler(callConference)));
        this.add((Component)this.scrollPane, "Center");
        this.constraints = new GridBagConstraints();
        this.constraints.fill = 1;
        this.constraints.gridx = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(0, 0, 3, 0);
        this.initializeComplete();
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane == null ? null : this.scrollPane.getVerticalScrollBar();
    }

    @Override
    protected ConferenceCallPeerRenderer updateViewFromModel(ConferenceCallPeerRenderer callPeerPanel, CallPeer callPeer) {
        if (callPeer == null) {
            Call call;
            List calls = this.callConference.getCalls();
            Call call2 = call = calls.isEmpty() ? null : (Call)calls.get(0);
            if (callPeerPanel instanceof ConferencePeerPanel) {
                if (!((ConferencePeerPanel)callPeerPanel).getCall().equals((Object)call)) {
                    callPeerPanel = null;
                }
            } else {
                callPeerPanel = null;
            }
            if (callPeerPanel == null && call != null) {
                callPeerPanel = new ConferencePeerPanel((BasicConferenceCallPanel)this, call, false);
            }
        } else if (callPeer.isConferenceFocus() || callPeer.getConferenceMemberCount() > 0) {
            if (!(callPeerPanel instanceof ConferenceFocusPanel)) {
                callPeerPanel = new ConferenceFocusPanel(this, callPeer);
            }
        } else if (!(callPeerPanel instanceof ConferencePeerPanel)) {
            callPeerPanel = new ConferencePeerPanel(this, callPeer);
        }
        return callPeerPanel;
    }

    @Override
    protected void viewForModelAdded(ConferenceCallPeerRenderer callPeerPanel, CallPeer callPeer) {
        this.constraints.gridy = callPeer == null ? 0 : this.constraints.gridy + 1;
        this.mainPanel.add(callPeerPanel.getComponent(), (Object)this.constraints);
        SwingUtilities.invokeLater(this.scrollToBottomRunnable);
        Window parentWindow = SwingUtilities.getWindowAncestor((Component)this.mainPanel);
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    @Override
    protected void viewForModelRemoved(ConferenceCallPeerRenderer callPeerPanel, CallPeer callPeer) {
        this.mainPanel.remove(callPeerPanel.getComponent());
        Window parentWindow = SwingUtilities.getWindowAncestor((Component)this.mainPanel);
        if (parentWindow != null) {
            parentWindow.pack();
        }
    }

    private static class MyViewportLayout
    extends ViewportLayout {
        static final MyViewportLayout SHARED_INSTANCE = new MyViewportLayout();

        private MyViewportLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            JViewport vp = (JViewport)parent;
            Component view = vp.getView();
            Scrollable scrollableView = null;
            if (view == null) {
                return;
            }
            if (view instanceof Scrollable) {
                scrollableView = (Scrollable)((Object)view);
            }
            Dimension viewPrefSize = view.getPreferredSize();
            Dimension vpSize = vp.getSize();
            Dimension extentSize = vp.toViewCoordinates(vpSize);
            Dimension viewSize = new Dimension(viewPrefSize);
            if (scrollableView != null) {
                if (scrollableView.getScrollableTracksViewportWidth()) {
                    viewSize.width = vpSize.width;
                }
                if (scrollableView.getScrollableTracksViewportHeight()) {
                    viewSize.height = vpSize.height;
                }
            }
            Point viewPosition = vp.getViewPosition();
            if (scrollableView == null || vp.getParent() == null || vp.getParent().getComponentOrientation().isLeftToRight()) {
                if (viewPosition.x + extentSize.width > viewSize.width) {
                    viewPosition.x = Math.max(0, viewSize.width - extentSize.width);
                }
            } else {
                viewPosition.x = extentSize.width > viewSize.width ? viewSize.width - extentSize.width : Math.max(0, Math.min(viewSize.width - extentSize.width, viewPosition.x));
            }
            if (viewPosition.y + extentSize.height > viewSize.height) {
                viewPosition.y = Math.max(0, viewSize.height - extentSize.height);
            }
            if (scrollableView == null) {
                if (viewPosition.x == 0 && vpSize.width > viewPrefSize.width) {
                    viewSize.width = vpSize.width;
                }
                if (viewPosition.y == 0 && vpSize.height > viewPrefSize.height) {
                    viewSize.height = vpSize.height;
                }
            }
            if (vpSize.width < viewSize.width) {
                viewSize.width = vpSize.width;
            } else if (vpSize.height < viewSize.height) {
                viewSize.height = vpSize.height;
            }
            vp.setViewPosition(viewPosition);
            vp.setViewSize(viewSize);
        }
    }

    private static class MyViewport
    extends JViewport {
        private MyViewport() {
        }

        @Override
        protected LayoutManager createLayoutManager() {
            return MyViewportLayout.SHARED_INSTANCE;
        }
    }
}

