/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.call.ConferenceCallPeerRenderer;
import net.java.sip.communicator.impl.gui.main.call.SecurityPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceCallPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.BasicConferenceParticipantPanel;
import net.java.sip.communicator.impl.gui.main.call.conference.CallPeerMenu;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenuBar;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.gui.call.CallPeerRenderer;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.ConferenceMember;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityNegotiationStartedEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityStatusEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityTimeoutEvent;
import net.java.sip.communicator.service.protocol.event.ConferenceMembersSoundLevelEvent;
import net.java.sip.communicator.service.protocol.event.ConferenceMembersSoundLevelListener;
import net.java.sip.communicator.service.protocol.event.SoundLevelListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.call.CallPeerAdapter;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.ZrtpControl;
import org.jitsi.service.resources.ResourceManagementService;

public class ConferencePeerPanel
extends BasicConferenceParticipantPanel<Object>
implements ConferenceCallPeerRenderer,
Skinnable {
    private static final long serialVersionUID = 0L;
    private final Call call;
    private final CallPeer callPeer;
    private final CallPeerAdapter callPeerAdapter;
    private CallPeerMenu callPeerMenu;
    private final JLabel dtmfLabel = new JLabel();
    private final JLabel holdStatusLabel = new JLabel();
    private final JLabel muteStatusLabel = new JLabel();
    private SecurityPanel<?> securityPanel;
    private final SoundLevelListenerImpl soundLevelListener = new SoundLevelListenerImpl();

    public ConferencePeerPanel(BasicConferenceCallPanel callRenderer, Call call, boolean video) {
        super(callRenderer, call, video);
        if (call == null) {
            throw new NullPointerException("call");
        }
        this.call = call;
        this.callPeer = null;
        this.callPeerAdapter = null;
        String globalDisplayName = null;
        GlobalDisplayDetailsService displayDetailsService = GuiActivator.getGlobalDisplayDetailsService();
        if (displayDetailsService != null) {
            byte[] globalAccountImage = displayDetailsService.getGlobalDisplayAvatar();
            if (globalAccountImage != null && globalAccountImage.length > 0) {
                this.setPeerImage(globalAccountImage);
            }
            globalDisplayName = displayDetailsService.getGlobalDisplayName();
        }
        ResourceManagementService resources = GuiActivator.getResources();
        this.setPeerName(globalDisplayName != null && globalDisplayName.length() > 0 ? globalDisplayName + " (" + call.getProtocolProvider().getAccountID().getDisplayName() + ")" : call.getProtocolProvider().getAccountID().getDisplayName());
        this.setTitleBackground(video ? Color.DARK_GRAY : new Color(resources.getColor("service.gui.CALL_LOCAL_USER_BACKGROUND")));
        if (ConferencePeerPanel.isSoundLevelIndicatorEnabled()) {
            call.addLocalUserSoundLevelListener((SoundLevelListener)this.soundLevelListener);
        }
    }

    public ConferencePeerPanel(BasicConferenceCallPanel callRenderer, CallPeer callPeer) {
        this(callRenderer, callPeer, false);
    }

    public ConferencePeerPanel(BasicConferenceCallPanel callRenderer, CallPeer callPeer, boolean video) {
        super(callRenderer, callPeer, video);
        if (callPeer == null) {
            throw new NullPointerException("callPeer");
        }
        this.call = null;
        this.callPeer = callPeer;
        this.securityPanel = SecurityPanel.create(this, callPeer, null);
        this.setMute(callPeer.isMute());
        this.setPeerImage(CallManager.getPeerImage(callPeer));
        this.setPeerName(callPeer.getDisplayName());
        this.initStatusBar(callPeer);
        this.callPeerMenu = new CallPeerMenu(callPeer, callRenderer);
        SIPCommMenuBar menuBar = new SIPCommMenuBar();
        menuBar.setLayout((LayoutManager)new FlowLayout(1, 0, 0));
        menuBar.add((JMenu)((Object)this.callPeerMenu));
        this.addToNameBar((Component)menuBar);
        this.setTitleBackground(video ? Color.DARK_GRAY : new Color(GuiActivator.getResources().getColor("service.gui.CALL_PEER_NAME_BACKGROUND")));
        this.initSecuritySettings();
        this.callPeerAdapter = new CallPeerAdapter(this.callPeer, (CallPeerRenderer)this);
        if (ConferencePeerPanel.isSoundLevelIndicatorEnabled()) {
            this.callPeer.addStreamSoundLevelListener((SoundLevelListener)this.soundLevelListener);
        }
    }

    public void dispose() {
        if (this.callPeerAdapter != null) {
            this.callPeerAdapter.dispose();
        }
        if (this.callPeer != null) {
            this.callPeer.removeConferenceMembersSoundLevelListener((ConferenceMembersSoundLevelListener)this.soundLevelListener);
            this.callPeer.removeStreamSoundLevelListener((SoundLevelListener)this.soundLevelListener);
        }
        if (this.call != null) {
            this.call.removeLocalUserSoundLevelListener((SoundLevelListener)this.soundLevelListener);
        }
    }

    public Call getCall() {
        return this.callPeer == null ? this.call : this.callPeer.getCall();
    }

    public String getCallPeerContactAddress() {
        return this.callPeer.getURI();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void initSecuritySettings() {
        this.securityStatusLabel.setSecurityOff();
        CallPeerSecurityStatusEvent securityEvent = this.callPeer.getCurrentSecuritySettings();
        if (securityEvent != null && securityEvent instanceof CallPeerSecurityOnEvent) {
            CallPeerSecurityOnEvent securityOnEvt = (CallPeerSecurityOnEvent)securityEvent;
            this.securityOn(securityOnEvt);
        }
        this.securityStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        this.securityStatusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ConferencePeerPanel.this.setSecurityPanelVisible(!ConferencePeerPanel.this.getCallPanel().getCallWindow().getFrame().getGlassPane().isVisible());
            }
        });
    }

    private void initStatusBar(CallPeer callPeer) {
        this.initSecurityStatusLabel();
        this.setParticipantState(callPeer.getState().getLocalizedStateString());
        this.addToStatusBar(this.holdStatusLabel);
        this.addToStatusBar(this.muteStatusLabel);
        this.addToStatusBar(this.dtmfLabel);
    }

    public boolean isLocalVideoVisible() {
        return false;
    }

    static boolean isSoundLevelIndicatorEnabled() {
        return !GuiActivator.getConfigurationService().getBoolean("net.java.sip.communicator.impl.gui.main.call.DISABLE_SOUND_LEVEL_INDICATORS", false);
    }

    @Override
    public void loadSkin() {
        this.setTitleBackground(new Color(GuiActivator.getResources().getColor("service.gui.CALL_LOCAL_USER_BACKGROUND")));
        if (this.muteStatusLabel.getIcon() != null) {
            this.muteStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.MUTE_STATUS_ICON)));
        }
        if (this.holdStatusLabel.getIcon() != null) {
            this.holdStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HOLD_STATUS_ICON)));
        }
        if (this.callPeerMenu != null) {
            this.callPeerMenu.loadSkin();
        }
    }

    public void printDTMFTone(char dtmfChar) {
        this.dtmfLabel.setText(this.dtmfLabel.getText() + dtmfChar);
    }

    private void redispatchMouseEvent(Component glassPane, MouseEvent e) {
        Point componentPoint;
        Object component;
        Point glassPanePoint = e.getPoint();
        Point securityPanelPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, this.securityPanel);
        if (securityPanelPoint.y > 0) {
            component = this.securityPanel;
            componentPoint = securityPanelPoint;
        } else {
            Container contentPane = this.getCallPanel().getCallWindow().getFrame().getContentPane();
            Point containerPoint = SwingUtilities.convertPoint(glassPane, glassPanePoint, contentPane);
            component = SwingUtilities.getDeepestComponentAt(contentPane, containerPoint.x, containerPoint.y);
            componentPoint = SwingUtilities.convertPoint(contentPane, glassPanePoint, component);
        }
        if (component != null) {
            ((Component)component).dispatchEvent(new MouseEvent((Component)component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
        e.consume();
    }

    public void securityNegotiationStarted(CallPeerSecurityNegotiationStartedEvent securityNegotiationStartedEvent) {
    }

    @Override
    public void securityOff(CallPeerSecurityOffEvent evt) {
        super.securityOff(evt);
        if (this.securityPanel != null) {
            this.securityPanel.securityOff(evt);
        }
    }

    @Override
    public void securityOn(CallPeerSecurityOnEvent evt) {
        super.securityOn(evt);
        if (evt == null) {
            return;
        }
        SrtpControl srtpControl = evt.getSecurityController();
        if (this.securityPanel == null) {
            return;
        }
        if (this.securityPanel.getSecurityControl() == null || !srtpControl.getClass().isInstance(this.securityPanel.getSecurityControl())) {
            this.setSecurityPanelVisible(false);
            this.securityPanel = SecurityPanel.create(this, this.callPeer, srtpControl);
        }
        this.securityPanel.securityOn(evt);
        boolean isSecurityLowPriority = Boolean.parseBoolean(GuiActivator.getResources().getSettingsString("impl.gui.I_DONT_CARE_THAT_MUCH_ABOUT_SECURITY"));
        if (srtpControl instanceof ZrtpControl && !((ZrtpControl)srtpControl).isSecurityVerified() && !isSecurityLowPriority) {
            this.setSecurityPanelVisible(true);
        }
    }

    @Override
    public void securityPending() {
        super.securityPending();
    }

    public void securityTimeout(CallPeerSecurityTimeoutEvent evt) {
        if (Boolean.parseBoolean(GuiActivator.getResources().getSettingsString("impl.gui.PARANOIA_UI"))) {
            try {
                CallPeer peer = (CallPeer)evt.getSource();
                OperationSetBasicTelephony telephony = (OperationSetBasicTelephony)peer.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
                telephony.hangupCallPeer(peer, 609, "Encryption Required!");
            }
            catch (OperationFailedException ex) {
                Logger.getLogger(this.getClass()).error((Object)"Failed to hangup peer", (Throwable)ex);
            }
        }
    }

    @Override
    public void setErrorReason(String reason) {
        super.setErrorReason(reason);
    }

    public void setLocalVideoVisible(boolean isVisible) {
    }

    public void setMute(boolean isMute) {
        if (isMute) {
            this.muteStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.MUTE_STATUS_ICON)));
        } else {
            this.muteStatusLabel.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void setOnHold(boolean isOnHold) {
        if (isOnHold) {
            this.holdStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HOLD_STATUS_ICON)));
        } else {
            this.holdStatusLabel.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    public void setPeerImage(byte[] icon) {
        if (this.callPeer == null || !this.callPeer.isConferenceFocus()) {
            this.setParticipantImage(icon);
        }
    }

    public void setPeerName(String name) {
        this.setParticipantName(name);
    }

    public void setPeerState(CallPeerState oldState, CallPeerState newState, String stateString) {
        this.setParticipantState(stateString);
    }

    public void setSecurityPanelVisible(boolean isVisible) {
        final JFrame callFrame = this.getCallPanel().getCallWindow().getFrame();
        final JPanel glassPane = (JPanel)callFrame.getGlassPane();
        if (!isVisible) {
            this.securityPanel.setVisible(false);
            glassPane.setVisible(false);
            glassPane.removeAll();
        } else {
            glassPane.setLayout(null);
            glassPane.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ConferencePeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    ConferencePeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    ConferencePeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    ConferencePeerPanel.this.redispatchMouseEvent(glassPane, e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    ConferencePeerPanel.this.redispatchMouseEvent(glassPane, e);
                }
            });
            Point securityLabelPoint = this.securityStatusLabel.getLocation();
            Point newPoint = SwingUtilities.convertPoint(this.securityStatusLabel.getParent(), securityLabelPoint.x, securityLabelPoint.y, callFrame);
            this.securityPanel.setBeginPoint(new Point((int)newPoint.getX() + 15, 0));
            this.securityPanel.setBounds(0, (int)newPoint.getY() - 5, callFrame.getWidth(), 110);
            glassPane.add((Component)((Object)this.securityPanel));
            this.securityPanel.setVisible(true);
            glassPane.setVisible(true);
            glassPane.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (glassPane.isVisible()) {
                        glassPane.setVisible(false);
                        callFrame.removeComponentListener(this);
                    }
                }
            });
        }
    }

    private class SoundLevelListenerImpl
    implements ConferenceMembersSoundLevelListener,
    SoundLevelListener {
        private SoundLevelListenerImpl() {
        }

        public void soundLevelChanged(ConferenceMembersSoundLevelEvent ev) {
            for (Map.Entry e : ev.getLevels().entrySet()) {
                if (!CallManager.addressesAreEqual(((ConferenceMember)e.getKey()).getAddress(), ConferencePeerPanel.this.callPeer.getAddress())) continue;
                ConferencePeerPanel.this.updateSoundBar((Integer)e.getValue());
                break;
            }
        }

        public void soundLevelChanged(Object source, int level) {
            if (source.equals(ConferencePeerPanel.this.participant)) {
                int conferenceMemberCount;
                if (ConferencePeerPanel.this.callPeer != null && (conferenceMemberCount = ConferencePeerPanel.this.callPeer.getConferenceMemberCount()) > 2) {
                    return;
                }
                ConferencePeerPanel.this.updateSoundBar(level);
            }
        }
    }
}

