/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.chat.ChatWindowManager;
import net.java.sip.communicator.impl.gui.main.contactlist.CommonRightButtonMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.plugin.desktoputil.SIPCommScrollPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.contacteventhandler.ContactEventHandler;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListService;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.event.ContactListEvent;
import net.java.sip.communicator.service.gui.event.ContactListListener;
import net.java.sip.communicator.service.muc.ChatRoomWrapper;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationEvent;
import net.java.sip.communicator.service.protocol.event.TypingNotificationsListener;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ContactListPane
extends SIPCommScrollPane
implements MessageListener,
TypingNotificationsListener,
FileTransferListener,
ContactListListener,
PluginComponentListener {
    private static final long serialVersionUID = 0L;
    private final MainFrame mainFrame;
    private TreeContactList contactList;
    private final TypingTimer typingTimer = new TypingTimer();
    private CommonRightButtonMenu commonRightButtonMenu;
    private final Logger logger = Logger.getLogger(ContactListPane.class);
    private final ChatWindowManager chatWindowManager;

    public ContactListPane(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.chatWindowManager = GuiActivator.getUIService().getChatWindowManager();
        this.setHorizontalScrollBarPolicy(31);
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        this.initPluginComponents();
    }

    public void initList(MetaContactListService contactListService) {
        this.contactList = new TreeContactList(this.mainFrame);
        GuiActivator.setContactList(this.contactList);
        this.contactList.applyFilter(TreeContactList.presenceFilter);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        transparentPanel.add((Component)this.contactList, (Object)"North");
        this.setViewportView((Component)transparentPanel);
        transparentPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.contactList.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.contactList.addContactListListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    ContactListPane.this.commonRightButtonMenu = new CommonRightButtonMenu(ContactListPane.this.mainFrame);
                    ContactListPane.this.commonRightButtonMenu.setInvoker((Component)((Object)ContactListPane.this));
                    ContactListPane.this.commonRightButtonMenu.setLocation(e.getX() + ContactListPane.this.mainFrame.getX() + 5, e.getY() + ContactListPane.this.mainFrame.getY() + 105);
                    ContactListPane.this.commonRightButtonMenu.setVisible(true);
                }
            }
        });
    }

    public TreeContactList getContactList() {
        return this.contactList;
    }

    public void contactClicked(ContactListEvent evt) {
        if (evt.getClickCount() < 2) {
            return;
        }
        UIContact descriptor = evt.getSourceContact();
        if (descriptor.getDescriptor() instanceof MetaContact) {
            boolean isOfflineMessagingSupported;
            MetaContact metaContact = (MetaContact)descriptor.getDescriptor();
            Contact defaultContact = metaContact.getDefaultContact(OperationSetBasicInstantMessaging.class);
            if (defaultContact == null && (defaultContact = metaContact.getDefaultContact(OperationSetSmsMessaging.class)) == null) {
                return;
            }
            ProtocolProviderService defaultProvider = defaultContact.getProtocolProvider();
            OperationSetBasicInstantMessaging defaultIM = (OperationSetBasicInstantMessaging)defaultProvider.getOperationSet(OperationSetBasicInstantMessaging.class);
            boolean bl = isOfflineMessagingSupported = defaultIM != null && !defaultIM.isOfflineMessagingSupported();
            if (!(defaultContact.getPresenceStatus().getStatus() >= 1 || isOfflineMessagingSupported && defaultProvider.isRegistered())) {
                Iterator protoContacts = metaContact.getContacts();
                while (protoContacts.hasNext()) {
                    Contact contact = (Contact)protoContacts.next();
                    ProtocolProviderService protoContactProvider = contact.getProtocolProvider();
                    OperationSetBasicInstantMessaging protoContactIM = (OperationSetBasicInstantMessaging)protoContactProvider.getOperationSet(OperationSetBasicInstantMessaging.class);
                    if (protoContactIM == null || !protoContactIM.isOfflineMessagingSupported() || !protoContactProvider.isRegistered()) continue;
                    defaultContact = contact;
                }
            }
            ContactEventHandler contactHandler = this.mainFrame.getContactHandler(defaultContact.getProtocolProvider());
            contactHandler.contactClicked(defaultContact, evt.getClickCount());
        } else if (descriptor.getDescriptor() instanceof SourceContact) {
            SourceContact contact = (SourceContact)descriptor.getDescriptor();
            List imDetails = contact.getContactDetails(OperationSetBasicInstantMessaging.class);
            List mucDetails = contact.getContactDetails(OperationSetMultiUserChat.class);
            if (imDetails != null && imDetails.size() > 0) {
                ProtocolProviderService pps = ((ContactDetail)imDetails.get(0)).getPreferredProtocolProvider(OperationSetBasicInstantMessaging.class);
                if (pps != null) {
                    GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress(), pps);
                } else {
                    GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress());
                }
            } else if (mucDetails != null && mucDetails.size() > 0) {
                ChatRoomWrapper room = GuiActivator.getMUCService().findChatRoomWrapperFromSourceContact(contact);
                if (room == null) {
                    ProtocolProviderService pps = ((ContactDetail)mucDetails.get(0)).getPreferredProtocolProvider(OperationSetMultiUserChat.class);
                    room = GuiActivator.getMUCService().findChatRoomWrapperFromChatRoomID(contact.getContactAddress(), pps);
                    if (room == null) {
                        GuiActivator.getMUCService().createChatRoom(contact.getContactAddress(), pps, new ArrayList(), "", false, false, false);
                    }
                }
                if (room != null) {
                    GuiActivator.getMUCService().openChatRoom(room);
                }
            } else {
                List smsDetails = contact.getContactDetails(OperationSetSmsMessaging.class);
                if (smsDetails != null && smsDetails.size() > 0) {
                    GuiActivator.getUIService().getChatWindowManager().startChat(contact.getContactAddress(), true);
                }
            }
        }
    }

    public void groupClicked(ContactListEvent evt) {
    }

    public void groupSelected(ContactListEvent evt) {
    }

    public void contactSelected(ContactListEvent evt) {
    }

    public void messageReceived(MessageReceivedEvent evt) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("MESSAGE RECEIVED from contact: " + evt.getSourceContact().getAddress()));
        }
        Contact protocolContact = evt.getSourceContact();
        ContactResource contactResource = evt.getContactResource();
        Message message = evt.getSourceMessage();
        int eventType = evt.getEventType();
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(protocolContact);
        if (metaContact != null) {
            this.messageReceived(protocolContact, contactResource, metaContact, message, eventType, evt.getTimestamp(), evt.getCorrectedMessageUID(), evt.isPrivateMessaging(), evt.getPrivateMessagingContactRoom());
        } else if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("MetaContact not found for protocol contact: " + protocolContact + "."));
        }
    }

    private void messageReceived(final Contact protocolContact, final ContactResource contactResource, final MetaContact metaContact, final Message message, final int eventType, final Date timestamp, final String correctedMessageUID, final boolean isPrivateMessaging, final ChatRoom privateContactRoom) {
        String resourceName;
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContactListPane.this.messageReceived(protocolContact, contactResource, metaContact, message, eventType, timestamp, correctedMessageUID, isPrivateMessaging, privateContactRoom);
                }
            });
            return;
        }
        ChatPanel chatPanel = this.chatWindowManager.getContactChat(metaContact, protocolContact, contactResource, message.getMessageUID());
        if (!chatPanel.isChatFocused()) {
            this.contactList.setActiveContact(metaContact, true);
        }
        String messageType = null;
        if (eventType == 1) {
            messageType = "IncomingMessage";
        } else if (eventType == 2) {
            messageType = "SystemMessage";
        } else if (eventType == 3) {
            messageType = "SmsMessage";
        }
        String contactAddress = contactResource != null ? protocolContact.getAddress() + " (" + contactResource.getResourceName() + ")" : protocolContact.getAddress();
        chatPanel.addMessage(contactAddress, protocolContact.getDisplayName(), timestamp, messageType, message.getContent(), message.getContentType(), message.getMessageUID(), correctedMessageUID);
        String string = resourceName = contactResource != null ? contactResource.getResourceName() : null;
        if (isPrivateMessaging) {
            this.chatWindowManager.openPrivateChatForChatRoomMember(privateContactRoom, protocolContact);
        } else {
            this.chatWindowManager.openChat(chatPanel, false);
        }
        ChatTransport chatTransport = chatPanel.getChatSession().findChatTransportForDescriptor(protocolContact, resourceName);
        chatPanel.setSelectedChatTransport(chatTransport, true);
    }

    public void messageDelivered(MessageDeliveredEvent evt) {
        ChatPanel chatPanel;
        Contact contact = evt.getDestinationContact();
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(contact);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("MESSAGE DELIVERED to contact: " + contact.getAddress()));
        }
        if ((chatPanel = this.chatWindowManager.getContactChat(metaContact, false)) != null) {
            Message msg = evt.getSourceMessage();
            ProtocolProviderService protocolProvider = contact.getProtocolProvider();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("MESSAGE DELIVERED: process message to chat for contact: " + contact.getAddress() + " MESSAGE: " + msg.getContent()));
            }
            chatPanel.addMessage(this.mainFrame.getAccountAddress(protocolProvider), this.mainFrame.getAccountDisplayName(protocolProvider), evt.getTimestamp(), "OutgoingMessage", msg.getContent(), msg.getContentType(), msg.getMessageUID(), evt.getCorrectedMessageUID());
            if (evt.isSmsMessage() && !ConfigurationUtils.isSmsNotifyTextDisabled()) {
                chatPanel.addMessage(contact.getDisplayName(), new Date(), "ActionMessage", GuiActivator.getResources().getI18NString("service.gui.SMS_SUCCESSFULLY_SENT"), "text");
            }
        }
    }

    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
        this.logger.error((Object)evt.getReason());
        String errorMsg = null;
        Message sourceMessage = (Message)evt.getSource();
        Contact sourceContact = evt.getDestinationContact();
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(sourceContact);
        errorMsg = evt.getErrorCode() == 5 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_NOT_SUPPORTED", new String[]{sourceContact.getDisplayName()}) : (evt.getErrorCode() == 2 ? GuiActivator.getResources().getI18NString("service.gui.MSG_NOT_DELIVERED") : (evt.getErrorCode() == 3 ? GuiActivator.getResources().getI18NString("service.gui.MSG_SEND_CONNECTION_PROBLEM") : (evt.getErrorCode() == 4 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_INTERNAL_ERROR") : (evt.getErrorCode() == 7 ? GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_UNSUPPORTED_OPERATION") : GuiActivator.getResources().getI18NString("service.gui.MSG_DELIVERY_ERROR")))));
        String reason = evt.getReason();
        if (reason != null) {
            errorMsg = errorMsg + " " + GuiActivator.getResources().getI18NString("service.gui.ERROR_WAS", new String[]{reason});
        }
        ChatPanel chatPanel = this.chatWindowManager.getContactChat(metaContact, sourceContact);
        chatPanel.addMessage(sourceContact.getAddress(), metaContact.getDisplayName(), new Date(), "OutgoingMessage", sourceMessage.getContent(), sourceMessage.getContentType(), sourceMessage.getMessageUID(), evt.getCorrectedMessageUID());
        chatPanel.addErrorMessage(metaContact.getDisplayName(), errorMsg);
        this.chatWindowManager.openChat(chatPanel, false);
    }

    public void typingNotificationReceived(TypingNotificationEvent evt) {
        if (this.typingTimer.isRunning()) {
            this.typingTimer.stop();
        }
        String notificationMsg = "";
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(evt.getSourceContact());
        String contactName = metaContact.getDisplayName() + " ";
        if (contactName.equals("")) {
            contactName = GuiActivator.getResources().getI18NString("service.gui.UNKNOWN") + " ";
        }
        int typingState = evt.getTypingState();
        ChatPanel chatPanel = this.chatWindowManager.getContactChat(metaContact, false);
        if (typingState == 1) {
            notificationMsg = GuiActivator.getResources().getI18NString("service.gui.CONTACT_TYPING", new String[]{contactName});
            if (!this.chatWindowManager.isChatOpenedFor(metaContact)) {
                return;
            }
            if (chatPanel != null) {
                chatPanel.addTypingNotification(notificationMsg);
            }
            this.typingTimer.setMetaContact(metaContact);
            this.typingTimer.start();
        } else if (typingState == 3) {
            notificationMsg = GuiActivator.getResources().getI18NString("service.gui.CONTACT_PAUSED_TYPING", new String[]{contactName});
            if (chatPanel != null) {
                chatPanel.addTypingNotification(notificationMsg);
            }
            this.typingTimer.setMetaContact(metaContact);
            this.typingTimer.start();
        } else if (chatPanel != null) {
            chatPanel.removeTypingNotification();
        }
    }

    public void typingNotificationDeliveryFailed(TypingNotificationEvent evt) {
        if (this.typingTimer.isRunning()) {
            this.typingTimer.stop();
        }
        String notificationMsg = "";
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(evt.getSourceContact());
        String contactName = metaContact.getDisplayName();
        if (contactName.equals("")) {
            contactName = GuiActivator.getResources().getI18NString("service.gui.UNKNOWN") + " ";
        }
        ChatPanel chatPanel = this.chatWindowManager.getContactChat(metaContact, false);
        notificationMsg = GuiActivator.getResources().getI18NString("service.gui.CONTACT_TYPING_SEND_FAILED", new String[]{contactName});
        if (!this.chatWindowManager.isChatOpenedFor(metaContact)) {
            return;
        }
        if (chatPanel != null) {
            chatPanel.addErrorSendingTypingNotification(notificationMsg);
        }
        this.typingTimer.setMetaContact(metaContact);
        this.typingTimer.start();
    }

    public void fileTransferRequestReceived(FileTransferRequestEvent event) {
        IncomingFileTransferRequest request = event.getRequest();
        Contact sourceContact = request.getSender();
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(sourceContact);
        ChatPanel chatPanel = this.chatWindowManager.getContactChat(metaContact, sourceContact);
        chatPanel.addIncomingFileTransferRequest(event.getFileTransferOperationSet(), request, event.getTimestamp());
        ChatTransport chatTransport = chatPanel.getChatSession().findChatTransportForDescriptor(sourceContact, null);
        chatPanel.setSelectedChatTransport(chatTransport, true);
        this.chatWindowManager.openChat(chatPanel, false);
    }

    public void fileTransferCreated(FileTransferCreatedEvent event) {
    }

    public void fileTransferRequestRejected(FileTransferRequestEvent event) {
    }

    public void fileTransferRequestCanceled(FileTransferRequestEvent event) {
    }

    public CommonRightButtonMenu getCommonRightButtonMenu() {
        return this.commonRightButtonMenu;
    }

    private void initPluginComponents() {
        Collection serRefs;
        String osgiFilter = "(CONTAINER_ID=" + Container.CONTAINER_CONTACT_LIST.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class, osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            serRefs = null;
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)ex);
        }
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                PluginComponent component = factory.getPluginComponentInstance((Object)this);
                Object selectedValue = this.getContactList().getSelectedValue();
                if (selectedValue instanceof MetaContact) {
                    component.setCurrentContact((MetaContact)selectedValue);
                } else if (selectedValue instanceof MetaContactGroup) {
                    component.setCurrentContactGroup((MetaContactGroup)selectedValue);
                }
                String pluginConstraints = factory.getConstraints();
                Object constraints = pluginConstraints != null ? UIServiceImpl.getBorderLayoutConstraintsFromContainer(pluginConstraints) : "South";
                this.add((Component)component.getComponent(), constraints);
                this.repaint();
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)Container.CONTAINER_CONTACT_LIST)) {
            return;
        }
        Object constraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
        if (constraints == null) {
            constraints = "South";
        }
        PluginComponent pluginComponent = factory.getPluginComponentInstance((Object)this);
        this.add((Component)pluginComponent.getComponent(), constraints);
        Object selectedValue = this.getContactList().getSelectedValue();
        if (selectedValue instanceof MetaContact) {
            pluginComponent.setCurrentContact((MetaContact)selectedValue);
        } else if (selectedValue instanceof MetaContactGroup) {
            pluginComponent.setCurrentContactGroup((MetaContactGroup)selectedValue);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)Container.CONTAINER_CONTACT_LIST)) {
            return;
        }
        this.remove((Component)factory.getPluginComponentInstance((Object)this).getComponent());
    }

    private class TypingTimer
    extends Timer {
        private static final long serialVersionUID = 0L;
        private MetaContact metaContact;

        public TypingTimer() {
            super(5000, null);
            this.addActionListener(new TimerActionListener());
        }

        private void setMetaContact(MetaContact metaContact) {
            this.metaContact = metaContact;
        }

        private class TimerActionListener
        implements ActionListener {
            private TimerActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPanel chatPanel = ContactListPane.this.chatWindowManager.getContactChat(TypingTimer.this.metaContact, false);
                if (chatPanel != null) {
                    chatPanel.removeTypingNotification();
                }
            }
        }
    }
}

