/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.lang.reflect.InvocationTargetException;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.service.gui.UIGroup;

public class ContactListTreeModel
extends DefaultTreeModel {
    private final GroupNode rootGroupNode;
    private final JTree parentTree;

    public ContactListTreeModel(JTree tree) {
        super(null);
        this.parentTree = tree;
        RootUIGroup rootDescriptor = new RootUIGroup();
        this.rootGroupNode = new GroupNode(this, rootDescriptor);
        ((UIGroupImpl)rootDescriptor).setGroupNode(this.rootGroupNode);
        this.setRoot(this.rootGroupNode);
    }

    @Override
    public GroupNode getRoot() {
        return this.rootGroupNode;
    }

    public ContactNode findFirstContactNode() {
        return this.findFirstContactNode(this.rootGroupNode);
    }

    public void clear() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ContactListTreeModel.this.clear();
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            return;
        }
        int childCount = this.rootGroupNode.getChildCount();
        int[] removedIndexs = new int[childCount];
        Object[] removedNodes = new Object[childCount];
        for (int i = 0; i < childCount; ++i) {
            removedIndexs[i] = i;
            removedNodes[i] = this.rootGroupNode.getChildAt(i);
        }
        this.rootGroupNode.clear();
        this.nodesWereRemoved(this.rootGroupNode, removedIndexs, removedNodes);
    }

    public JTree getParentTree() {
        return this.parentTree;
    }

    @Override
    public void nodeChanged(final TreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContactListTreeModel.super.nodeChanged(node);
            }
        });
    }

    private ContactNode findFirstContactNode(GroupNode parentNode) {
        if (parentNode.getChildCount() == 0) {
            return null;
        }
        TreeNode treeNode = parentNode.getFirstChild();
        if (treeNode instanceof GroupNode) {
            return this.findFirstContactNode((GroupNode)treeNode);
        }
        return (ContactNode)treeNode;
    }

    private static class RootUIGroup
    extends UIGroupImpl {
        private GroupNode groupNode;

        private RootUIGroup() {
        }

        public UIGroup getParentGroup() {
            return null;
        }

        public int getSourceIndex() {
            return 0;
        }

        public boolean isGroupCollapsed() {
            return false;
        }

        public String getDisplayName() {
            return null;
        }

        public int countChildContacts() {
            return 0;
        }

        public int countOnlineChildContacts() {
            return 0;
        }

        public Object getDescriptor() {
            return "RootGroup";
        }

        public String getId() {
            return null;
        }

        @Override
        public GroupNode getGroupNode() {
            return this.groupNode;
        }

        @Override
        public void setGroupNode(GroupNode groupNode) {
            this.groupNode = groupNode;
        }

        public JPopupMenu getRightButtonMenu() {
            return null;
        }
    }
}

