/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Color;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.lookandfeel.ExtendedTreeUI;
import net.java.sip.communicator.impl.gui.main.chat.ChatContact;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTransferHandler;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTreeCellRenderer;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTooltip;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.util.skin.Skinnable;

public class DefaultTreeContactList
extends JTree
implements Skinnable {
    private static final long serialVersionUID = 0L;
    private static final String uiClassID = DefaultTreeContactList.class.getName() + "TreeUI";
    private TreeSelectionEvent myCachedSelectionEvent;
    private ContactListTreeCellRenderer renderer;

    public DefaultTreeContactList() {
        this.setBackground(Color.WHITE);
        this.setDragEnabled(true);
        this.setTransferHandler((TransferHandler)((Object)new ContactListTransferHandler(this)));
        this.getSelectionModel().setSelectionMode(1);
        this.renderer = new ContactListTreeCellRenderer();
        this.setCellRenderer(this.renderer);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (DefaultTreeContactList.this.myCachedSelectionEvent == null) {
                    return;
                }
                DefaultTreeContactList.super.fireValueChanged(DefaultTreeContactList.this.myCachedSelectionEvent);
                DefaultTreeContactList.this.myCachedSelectionEvent = null;
            }
        });
    }

    public Object getSelectedValue() {
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath != null) {
            return selectionPath.getLastPathComponent();
        }
        return null;
    }

    public boolean isContactActive(UIContact contact) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContactActive(MetaContact metaContact) {
        UIContactImpl uiContact;
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
        }
        if (uiContact != null) {
            return this.isContactActive(uiContact);
        }
        return false;
    }

    @Override
    public JToolTip createToolTip() {
        Point currentMouseLocation = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(currentMouseLocation, this);
        TreePath path = this.getClosestPathForLocation(currentMouseLocation.x, currentMouseLocation.y);
        Object element = path.getLastPathComponent();
        ExtendedTooltip tip = null;
        if (element instanceof ContactNode) {
            Component cellComponent = this.findTreeCellComponent(currentMouseLocation);
            if (cellComponent instanceof SIPCommButton && (((SIPCommButton)cellComponent).getToolTipText() != null && ((SIPCommButton)cellComponent).getToolTipText().length() > 0 || ((SIPCommButton)cellComponent).getTooltip() != null)) {
                SIPCommButton button = (SIPCommButton)cellComponent;
                tip = button.getTooltip();
                if (tip == null) {
                    tip = new ExtendedTooltip(true);
                    tip.setTitle(button.getToolTipText());
                }
            } else {
                UIContactImpl contact = ((ContactNode)element).getContactDescriptor();
                tip = contact.getToolTip();
                if (tip == null) {
                    tip = new ExtendedTooltip(true);
                    tip.setTitle(contact.getDisplayName());
                }
            }
        } else if (element instanceof GroupNode) {
            Component cellComponent = this.findTreeCellComponent(currentMouseLocation);
            if (cellComponent instanceof SIPCommButton && ((SIPCommButton)cellComponent).getToolTipText() != null && ((SIPCommButton)cellComponent).getToolTipText().length() > 0) {
                tip = new ExtendedTooltip(true);
                tip.setTitle(((SIPCommButton)cellComponent).getToolTipText());
            } else {
                UIGroupImpl group = ((GroupNode)element).getGroupDescriptor();
                tip = new ExtendedTooltip(true);
                tip.setTitle(group.getDisplayName());
            }
        } else if (element instanceof ChatContact) {
            ChatContact chatContact = (ChatContact)element;
            ImageIcon avatarImage = chatContact.getAvatar();
            tip = new ExtendedTooltip(true);
            if (avatarImage != null) {
                tip.setImage(avatarImage);
            }
            tip.setTitle(chatContact.getName());
        }
        tip.setComponent((JComponent)this);
        return tip;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        TreePath path = this.getClosestPathForLocation(event.getX(), event.getY());
        if (path != null) {
            Object element = path.getLastPathComponent();
            String buttonString = "";
            Component mouseComponent = this.findTreeCellComponent(event.getPoint());
            if (mouseComponent instanceof SIPCommButton) {
                buttonString = Integer.toString(mouseComponent.hashCode());
            }
            String uniqueToolTipString = "className= " + element.getClass().getName() + ", hashCode= " + element.hashCode() + ", toString= " + element.toString();
            return buttonString.length() > 0 ? uniqueToolTipString + ", onButton=" + buttonString : uniqueToolTipString;
        }
        return null;
    }

    public void loadSkin() {
        this.renderer.loadSkin();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected Component findTreeCellComponent(Point point) {
        TreePath path = this.getClosestPathForLocation(point.x, point.y);
        if (path == null) {
            return null;
        }
        Object element = path.getLastPathComponent();
        ContactListTreeCellRenderer renderer = (ContactListTreeCellRenderer)this.getCellRenderer().getTreeCellRendererComponent(this, element, true, true, true, this.getRowForPath(path), true);
        Rectangle r = this.getPathBounds(path);
        int translatedX = point.x - r.x;
        int translatedY = point.y - r.y;
        return renderer.findComponentAt(translatedX, translatedY);
    }

    static {
        UIManager.getDefaults().put(uiClassID, ExtendedTreeUI.class.getName());
    }
}

