/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactSearchFieldUI;
import net.java.sip.communicator.plugin.desktoputil.SIPCommTextField;
import net.java.sip.communicator.plugin.desktoputil.event.TextFieldChangeListener;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.ContactListSearchFilter;
import net.java.sip.communicator.service.gui.FilterQuery;
import net.java.sip.communicator.service.gui.event.FilterQueryListener;
import net.java.sip.communicator.util.skin.Skinnable;

public class SearchField
extends SIPCommTextField
implements TextFieldChangeListener,
FilterQueryListener,
Skinnable {
    private static final String uiClassID = SearchField.class.getName() + "FieldUI";
    private ContactList contactList;
    private FilterQuery currentFilterQuery = null;
    private final MainFrame mainFrame;
    private final ContactListSearchFilter searchFilter;

    public SearchField(MainFrame frame, ContactListSearchFilter searchFilter, boolean isCallButtonEnabled, boolean isSMSButtonEnabled) {
        super(GuiActivator.getResources().getI18NString("service.gui.ENTER_NAME_OR_NUMBER"));
        this.mainFrame = frame;
        this.searchFilter = searchFilter;
        if (this.getUI() instanceof ContactSearchFieldUI) {
            ((ContactSearchFieldUI)((Object)this.getUI())).setupListeners();
            ((ContactSearchFieldUI)((Object)this.getUI())).setDeleteButtonEnabled(true);
            ((ContactSearchFieldUI)((Object)this.getUI())).setCallButtonEnabled(isCallButtonEnabled);
            ((ContactSearchFieldUI)((Object)this.getUI())).setSMSButtonEnabled(isSMSButtonEnabled);
        }
        this.setBorder(null);
        this.setOpaque(false);
        this.setDragEnabled(true);
        this.addTextChangeListener(this);
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke(27, 0), "escape");
        ActionMap amap = this.getActionMap();
        amap.put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchField.this.setText("");
                if (SearchField.this.mainFrame != null) {
                    SearchField.this.mainFrame.requestFocusInContactList();
                }
            }
        });
        this.loadSkin();
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void enableUnknownContactView(final boolean isEnabled) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SearchField.this.mainFrame != null) {
                    SearchField.this.mainFrame.enableUnknownContactView(isEnabled);
                }
            }
        });
    }

    public void filterQueryFailed(FilterQuery query) {
        if (this.currentFilterQuery.equals(query)) {
            this.filterQueryFinished(query, false);
        }
    }

    private void filterQueryFinished(FilterQuery query, boolean hasResults) {
        this.enableUnknownContactView(!hasResults);
        query.setQueryListener(null);
    }

    public void filterQuerySucceeded(FilterQuery query) {
        if (this.currentFilterQuery.equals(query)) {
            this.filterQueryFinished(query, true);
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void loadSkin() {
        if (this.getUI() instanceof ContactSearchFieldUI) {
            ((ContactSearchFieldUI)((Object)this.getUI())).loadSkin();
        }
    }

    public void setContactList(ContactList contactList) {
        this.contactList = contactList;
    }

    public void textInserted() {
        String filterString = this.getText();
        if (filterString == null || filterString.length() <= 0) {
            return;
        }
        this.updateContactListView();
    }

    public void textRemoved() {
        this.updateContactListView();
    }

    private void updateContactListView() {
        String filterString = this.getText();
        boolean isDefaultFilter = false;
        this.searchFilter.setFilterString(filterString.trim());
        if (this.currentFilterQuery != null) {
            this.filterQueryFinished(this.currentFilterQuery, true);
        }
        if (filterString != null && filterString.length() > 0) {
            this.currentFilterQuery = this.contactList.applyFilter((ContactListFilter)this.searchFilter);
        } else {
            this.currentFilterQuery = this.contactList.applyDefaultFilter();
            isDefaultFilter = true;
        }
        if (this.currentFilterQuery != null && !this.currentFilterQuery.isCanceled()) {
            if (isDefaultFilter || this.currentFilterQuery.isSucceeded()) {
                this.enableUnknownContactView(false);
            } else {
                this.currentFilterQuery.setQueryListener((FilterQueryListener)this);
            }
        } else {
            this.filterQueryFinished(this.currentFilterQuery, !this.contactList.isEmpty());
        }
    }

    public void dispose() {
        if (this.getUI() instanceof ContactSearchFieldUI) {
            ((ContactSearchFieldUI)((Object)this.getUI())).removeListeners();
        }
    }

    static {
        UIManager.getDefaults().put(uiClassID, ContactSearchFieldUI.class.getName());
    }
}

