/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.util.Iterator;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.ExtendedContactSourceService;
import net.java.sip.communicator.service.gui.ContactList;
import net.java.sip.communicator.service.gui.ContactListSearchFilter;
import net.java.sip.communicator.service.gui.FilterQuery;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactSource;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.gui.event.MetaContactQuery;
import net.java.sip.communicator.service.gui.event.MetaContactQueryListener;

public class SearchFilter
implements ContactListSearchFilter {
    protected String filterString;
    protected Pattern filterPattern;
    private final MetaContactListSource mclSource;
    protected ContactList sourceContactList;
    protected String DISABLE_CALL_HISTORY_SEARCH_PROP = "net.java.sip.communicator.impl.gui.DISABLE_CALL_HISTORY_SEARCH_IN_CONTACT_LIST";
    private boolean isSearchingPhoneNumber = false;

    public SearchFilter(MetaContactListSource contactListSource) {
        this.mclSource = contactListSource;
    }

    public SearchFilter(ContactList sourceContactList) {
        this.mclSource = null;
        this.sourceContactList = sourceContactList;
    }

    public void applyFilter(FilterQuery filterQuery) {
        if (this.sourceContactList == null) {
            this.sourceContactList = GuiActivator.getContactList();
        }
        Iterator filterSources = this.sourceContactList.getContactSources().iterator();
        if (this.sourceContactList.getDefaultFilter().equals(TreeContactList.presenceFilter)) {
            MetaContactQuery defaultQuery = new MetaContactQuery();
            defaultQuery.addContactQueryListener((MetaContactQueryListener)this.sourceContactList);
            filterQuery.addContactQuery((Object)defaultQuery);
            this.mclSource.startQuery(defaultQuery, this.filterPattern);
        } else if (this.sourceContactList.getDefaultFilter().equals(TreeContactList.historyFilter)) {
            filterSources = this.sourceContactList.getContactSources(2).iterator();
        }
        if (filterQuery.isCanceled()) {
            return;
        }
        if (this.sourceContactList instanceof TreeContactList) {
            ((TreeContactList)this.sourceContactList).setAutoSectionAllowed(true);
        }
        while (filterSources.hasNext()) {
            UIContactSource filterSource = (UIContactSource)filterSources.next();
            if (this.sourceContactList.getDefaultFilter().equals(TreeContactList.presenceFilter) && GuiActivator.getConfigurationService().getBoolean(this.DISABLE_CALL_HISTORY_SEARCH_PROP, false) && filterSource.getContactSourceService().getType() == 2) continue;
            if (this.sourceContactList.getDefaultFilter().equals(TreeContactList.presenceFilter) && filterSource.getContactSourceService().getType() == 3) {
                filterSource.setContactSourceIndex(this.mclSource.getIndex() + 1);
            }
            if (filterQuery.isCanceled()) {
                return;
            }
            this.applyFilter(filterSource, filterQuery);
        }
        if (filterQuery.isRunning()) {
            filterQuery.close();
        }
    }

    protected ContactQuery applyFilter(UIContactSource contactSource, FilterQuery filterQuery) {
        ContactSourceService sourceService = contactSource.getContactSourceService();
        ContactQuery contactQuery = sourceService instanceof ExtendedContactSourceService ? ((ExtendedContactSourceService)sourceService).createContactQuery(this.filterPattern) : sourceService.createContactQuery(this.filterString);
        if (contactQuery == null) {
            return null;
        }
        contactQuery.addContactQueryListener((ContactQueryListener)this.sourceContactList);
        if (contactQuery.getStatus() == 3) {
            filterQuery.addContactQuery((Object)contactQuery);
        }
        contactQuery.start();
        return contactQuery;
    }

    public boolean isMatching(UIContact uiContact) {
        Iterator searchStrings = uiContact.getSearchStrings();
        if (searchStrings != null) {
            while (searchStrings.hasNext()) {
                if (!this.isMatching((String)searchStrings.next())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatching(UIGroup uiGroup) {
        return false;
    }

    public void setFilterString(String filter) {
        this.filterString = filter;
        this.filterPattern = Pattern.compile(Pattern.quote(this.filterString), 74);
        this.isSearchingPhoneNumber = GuiActivator.getPhoneNumberI18nService().isPhoneNumber(filter);
    }

    private boolean isMatching(String text) {
        if (this.filterPattern != null && this.filterPattern.matcher(text).find()) {
            return true;
        }
        if (this.isSearchingPhoneNumber && this.filterString != null) {
            return GuiActivator.getPhoneNumberI18nService().phoneNumbersMatch(this.filterString, text);
        }
        return true;
    }
}

