/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.contactlist.ChooseUIContactDetailPopupMenu;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListTreeModel;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.GroupNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.UIGroupImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIGroup;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.SIPCommButton;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.event.MetaContactAvatarUpdateEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactGroupEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.contactlist.event.MetaContactModifiedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactMovedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactRenamedEvent;
import net.java.sip.communicator.service.contactlist.event.ProtoContactEvent;
import net.java.sip.communicator.service.customcontactactions.ContactAction;
import net.java.sip.communicator.service.customcontactactions.CustomContactActionsService;
import net.java.sip.communicator.service.gui.ContactListFilter;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.gui.UIContactDetailAction;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.gui.event.MetaContactQuery;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ContactPresenceStatusListener;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class MetaContactListSource
implements ContactPresenceStatusListener,
MetaContactListListener {
    public static final String UI_CONTACT_DATA_KEY = MetaUIContact.class.getName() + ".uiContactDescriptor";
    public static final String UI_GROUP_DATA_KEY = MetaUIGroup.class.getName() + ".uiGroupDescriptor";
    private static final String GROUP_IS_NEW_KEY = MetaUIGroup.class.getName() + ".groupIsNew";
    private static final int INITIAL_CONTACT_COUNT = 30;
    private static Map<ContactAction<Contact>, SIPCommButton> customActionButtons;
    private static MetaUIContact customActionContact;
    private int index = 0;
    private static final Logger logger;

    public static UIContactImpl getUIContact(MetaContact metaContact) {
        return (UIContactImpl)((Object)metaContact.getData((Object)UI_CONTACT_DATA_KEY));
    }

    public static UIGroupImpl getUIGroup(MetaContactGroup metaGroup) {
        return (UIGroupImpl)((Object)metaGroup.getData((Object)UI_GROUP_DATA_KEY));
    }

    public static boolean isNewGroup(MetaContactGroup metaGroup) {
        Object data = metaGroup.getData((Object)GROUP_IS_NEW_KEY);
        return data == null ? false : (Boolean)data;
    }

    public static UIContactImpl createUIContact(MetaContact metaContact) {
        MetaUIContact descriptor = new MetaUIContact(metaContact);
        metaContact.setData((Object)UI_CONTACT_DATA_KEY, (Object)descriptor);
        return descriptor;
    }

    public static void removeUIContact(MetaContact metaContact) {
        metaContact.setData((Object)UI_CONTACT_DATA_KEY, null);
    }

    public static UIGroup createUIGroup(MetaContactGroup metaGroup) {
        MetaUIGroup descriptor = new MetaUIGroup(metaGroup);
        metaGroup.setData((Object)UI_GROUP_DATA_KEY, (Object)descriptor);
        return descriptor;
    }

    public static void removeUIGroup(MetaContactGroup metaGroup) {
        metaGroup.setData((Object)UI_GROUP_DATA_KEY, null);
    }

    public static boolean isRootGroup(MetaContactGroup group) {
        return group.equals(GuiActivator.getContactListService().getRoot());
    }

    public void startQuery(final MetaContactQuery query, final Pattern filterPattern) {
        new Thread(){

            @Override
            public void run() {
                int resultCount = 0;
                MetaContactListSource.this.queryMetaContactSource(filterPattern, GuiActivator.getContactListService().getRoot(), query, resultCount);
                if (!query.isCanceled()) {
                    query.fireQueryEvent(0);
                } else {
                    query.fireQueryEvent(1);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryMetaContactSource(Pattern filterPattern, MetaContactGroup parentGroup, MetaContactQuery query, int resultCount) {
        Iterator childContacts = parentGroup.getChildContacts();
        while (childContacts.hasNext() && !query.isCanceled()) {
            MetaContact metaContact = (MetaContact)childContacts.next();
            if (!this.isMatching(filterPattern, metaContact)) continue;
            if (++resultCount <= 30) {
                UIGroupImpl uiGroup = null;
                if (!MetaContactListSource.isRootGroup(parentGroup)) {
                    MetaContactGroup metaContactGroup = parentGroup;
                    synchronized (metaContactGroup) {
                        uiGroup = MetaContactListSource.getUIGroup(parentGroup);
                        if (uiGroup == null) {
                            uiGroup = MetaContactListSource.createUIGroup(parentGroup);
                        }
                    }
                }
                MetaContact metaContact2 = metaContact;
                synchronized (metaContact2) {
                    UIContactImpl newUIContact = MetaContactListSource.getUIContact(metaContact);
                    if (newUIContact == null) {
                        newUIContact = MetaContactListSource.createUIContact(metaContact);
                    }
                    GuiActivator.getContactList().addContact(newUIContact, uiGroup, true, true);
                }
                query.setInitialResultCount(resultCount);
                continue;
            }
            query.fireQueryEvent(metaContact);
        }
        if (query.isCanceled()) {
            return;
        }
        Iterator subgroups = parentGroup.getSubgroups();
        while (subgroups.hasNext() && !query.isCanceled()) {
            MetaContactGroup subgroup = (MetaContactGroup)subgroups.next();
            this.queryMetaContactSource(filterPattern, subgroup, query, resultCount);
        }
    }

    private boolean isMatching(Pattern filterPattern, MetaContact metaContact) {
        Matcher matcher = filterPattern.matcher(metaContact.getDisplayName());
        if (matcher.find()) {
            return true;
        }
        Iterator contacts = metaContact.getContacts();
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            matcher = filterPattern.matcher(contact.getDisplayName());
            if (matcher.find()) {
                return true;
            }
            matcher = filterPattern.matcher(contact.getAddress());
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public boolean isMatching(Pattern filterPattern, MetaContactGroup metaGroup) {
        Iterator contacts = metaGroup.getChildContacts();
        while (contacts.hasNext()) {
            MetaContact metaContact = (MetaContact)contacts.next();
            if (!this.isMatching(filterPattern, metaContact)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contactPresenceStatusChanged(ContactPresenceStatusChangeEvent evt) {
        UIContactImpl uiContact;
        if (evt.getOldStatus() == evt.getNewStatus() && !evt.isResourceChanged()) {
            return;
        }
        Contact sourceContact = evt.getSourceContact();
        MetaContact metaContact = GuiActivator.getContactListService().findMetaContactByContact(sourceContact);
        if (metaContact == null) {
            return;
        }
        boolean uiContactCreated = false;
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact == null) {
                uiContact = MetaContactListSource.createUIContact(metaContact);
                uiContactCreated = true;
            }
        }
        ContactListFilter currentFilter = GuiActivator.getContactList().getCurrentFilter();
        if (uiContactCreated) {
            if (currentFilter != null && currentFilter.isMatching((UIContact)uiContact)) {
                MetaContactGroup parentGroup = metaContact.getParentMetaContactGroup();
                UIGroupImpl uiGroup = null;
                if (!MetaContactListSource.isRootGroup(parentGroup)) {
                    MetaContactGroup metaContactGroup = parentGroup;
                    synchronized (metaContactGroup) {
                        uiGroup = MetaContactListSource.getUIGroup(parentGroup);
                        if (uiGroup == null) {
                            uiGroup = MetaContactListSource.createUIGroup(parentGroup);
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Add matching contact due to status change: " + uiContact.getDisplayName()));
                }
                GuiActivator.getContactList().addContact(uiContact, uiGroup, true, true);
            } else {
                MetaContactListSource.removeUIContact(metaContact);
            }
        } else if (currentFilter != null && !currentFilter.isMatching((UIContact)uiContact)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Remove unmatching contact due to status change: " + uiContact.getDisplayName()));
            }
            GuiActivator.getContactList().removeContact(uiContact);
        } else {
            UIContactImpl uIContactImpl = uiContact;
            synchronized (uIContactImpl) {
                GuiActivator.getContactList().nodeChanged(uiContact.getContactNode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childContactsReordered(MetaContactGroupEvent evt) {
        UIGroupImpl uiGroup;
        MetaContactGroup metaGroup = evt.getSourceMetaContactGroup();
        ContactListTreeModel treeModel = GuiActivator.getContactList().getTreeModel();
        Object object = metaGroup;
        synchronized (object) {
            uiGroup = MetaContactListSource.getUIGroup(metaGroup);
            if (MetaContactListSource.isRootGroup(metaGroup) && uiGroup == null) {
                uiGroup = treeModel.getRoot().getGroupDescriptor();
            }
        }
        if (uiGroup != null) {
            object = uiGroup;
            synchronized (object) {
                GroupNode groupNode = uiGroup.getGroupNode();
                if (groupNode != null) {
                    groupNode.sort(treeModel);
                }
            }
        }
    }

    public void metaContactAdded(MetaContactEvent evt) {
        this.metaContactAdded(evt.getSourceMetaContact(), evt.getParentGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaContactAdded(MetaContact metaContact, MetaContactGroup parentGroup) {
        UIContactImpl uiContact;
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact != null) {
                return;
            }
            uiContact = MetaContactListSource.createUIContact(metaContact);
        }
        ContactListFilter currentFilter = GuiActivator.getContactList().getCurrentFilter();
        if (currentFilter.isMatching((UIContact)uiContact)) {
            UIGroupImpl uiGroup = null;
            if (!MetaContactListSource.isRootGroup(parentGroup)) {
                uiGroup = MetaContactListSource.getUIGroup(parentGroup);
                MetaContactGroup metaContactGroup = parentGroup;
                synchronized (metaContactGroup) {
                    if (uiGroup == null) {
                        uiGroup = MetaContactListSource.createUIGroup(parentGroup);
                    }
                }
            }
            GuiActivator.getContactList().addContact(uiContact, uiGroup, true, true);
        } else {
            MetaContactListSource.removeUIContact(metaContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactGroupAdded(MetaContactGroupEvent evt) {
        ContactListFilter currentFilter;
        UIGroupImpl uiGroup;
        MetaContactGroup metaGroup;
        MetaContactGroup metaContactGroup = metaGroup = evt.getSourceMetaContactGroup();
        synchronized (metaContactGroup) {
            uiGroup = MetaContactListSource.getUIGroup(metaGroup);
            if (uiGroup != null) {
                return;
            }
            uiGroup = MetaContactListSource.createUIGroup(metaGroup);
        }
        if (metaGroup.countChildContacts() == 0) {
            metaGroup.setData((Object)GROUP_IS_NEW_KEY, (Object)Boolean.TRUE);
        }
        if ((currentFilter = GuiActivator.getContactList().getCurrentFilter()).isMatching((UIGroup)uiGroup)) {
            GuiActivator.getContactList().addGroup(uiGroup, true);
        } else {
            MetaContactListSource.removeUIGroup(metaGroup);
        }
        Iterator iterContacts = metaGroup.getChildContacts();
        while (iterContacts.hasNext()) {
            this.metaContactAdded((MetaContact)iterContacts.next(), metaGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactGroupModified(MetaContactGroupEvent evt) {
        UIGroupImpl uiGroup;
        MetaContactGroup metaGroup;
        Object object = metaGroup = evt.getSourceMetaContactGroup();
        synchronized (object) {
            uiGroup = MetaContactListSource.getUIGroup(metaGroup);
        }
        if (uiGroup != null) {
            object = uiGroup;
            synchronized (object) {
                GroupNode groupNode = uiGroup.getGroupNode();
                if (groupNode != null) {
                    GuiActivator.getContactList().getTreeModel().nodeChanged(groupNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactGroupRemoved(MetaContactGroupEvent evt) {
        UIGroupImpl uiGroup;
        MetaContactGroup metaGroup;
        MetaContactGroup metaContactGroup = metaGroup = evt.getSourceMetaContactGroup();
        synchronized (metaContactGroup) {
            uiGroup = MetaContactListSource.getUIGroup(metaGroup);
        }
        if (uiGroup != null) {
            GuiActivator.getContactList().removeGroup(uiGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactModified(MetaContactModifiedEvent evt) {
        UIContactImpl uiContact;
        MetaContact metaContact;
        Object object = metaContact = evt.getSourceMetaContact();
        synchronized (object) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact == null) {
                return;
            }
        }
        object = uiContact;
        synchronized (object) {
            ContactNode contactNode = uiContact.getContactNode();
            if (contactNode != null) {
                GuiActivator.getContactList().nodeChanged(contactNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactMoved(final MetaContactMovedEvent evt) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MetaContactListSource.this.metaContactMoved(evt);
                }
            });
            return;
        }
        MetaContact metaContact = evt.getSourceMetaContact();
        MetaContactGroup oldParent = evt.getOldParent();
        MetaContactGroup newParent = evt.getNewParent();
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            UIGroupImpl oldUIGroup;
            UIContactImpl uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact == null) {
                return;
            }
            if (MetaContactListSource.isRootGroup(oldParent)) {
                oldUIGroup = GuiActivator.getContactList().getTreeModel().getRoot().getGroupDescriptor();
            } else {
                MetaContactGroup metaContactGroup = oldParent;
                synchronized (metaContactGroup) {
                    oldUIGroup = MetaContactListSource.getUIGroup(oldParent);
                }
            }
            if (oldUIGroup != null) {
                GuiActivator.getContactList().removeContact(uiContact);
            }
            uiContact = MetaContactListSource.createUIContact(metaContact);
            UIGroupImpl newUIGroup = null;
            if (!MetaContactListSource.isRootGroup(newParent)) {
                MetaContactGroup metaContactGroup = newParent;
                synchronized (metaContactGroup) {
                    newUIGroup = MetaContactListSource.getUIGroup(newParent);
                    if (newUIGroup == null) {
                        newUIGroup = MetaContactListSource.createUIGroup(newParent);
                    }
                }
            }
            ContactListFilter currentFilter = GuiActivator.getContactList().getCurrentFilter();
            UIContactImpl uIContactImpl = uiContact;
            synchronized (uIContactImpl) {
                if (currentFilter.isMatching((UIContact)uiContact) && uiContact.getContactNode() == null) {
                    GuiActivator.getContactList().addContact(uiContact, newUIGroup, true, true);
                } else {
                    MetaContactListSource.removeUIContact(metaContact);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactRemoved(MetaContactEvent evt) {
        UIContactImpl uiContact;
        MetaContact metaContact;
        MetaContact metaContact2 = metaContact = evt.getSourceMetaContact();
        synchronized (metaContact2) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
        }
        if (uiContact != null) {
            GuiActivator.getContactList().removeContact(uiContact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactRenamed(MetaContactRenamedEvent evt) {
        UIContactImpl uiContact;
        MetaContact metaContact;
        Object object = metaContact = evt.getSourceMetaContact();
        synchronized (object) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact == null) {
                return;
            }
        }
        object = uiContact;
        synchronized (object) {
            ContactNode contactNode = uiContact.getContactNode();
            if (contactNode != null) {
                GuiActivator.getContactList().nodeChanged(contactNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void metaContactAvatarUpdated(MetaContactAvatarUpdateEvent evt) {
        UIContactImpl uiContact;
        MetaContact metaContact;
        Object object = metaContact = evt.getSourceMetaContact();
        synchronized (object) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
        }
        if (uiContact != null) {
            object = uiContact;
            synchronized (object) {
                ContactNode contactNode = uiContact.getContactNode();
                if (contactNode != null) {
                    GuiActivator.getContactList().nodeChanged(contactNode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protoContactAdded(ProtoContactEvent evt) {
        UIContactImpl parentUIContact;
        MetaContact metaContact = evt.getNewParent();
        boolean parentUIContactCreated = false;
        MetaContact metaContact2 = metaContact;
        synchronized (metaContact2) {
            parentUIContact = MetaContactListSource.getUIContact(metaContact);
            if (parentUIContact == null) {
                parentUIContactCreated = true;
                parentUIContact = MetaContactListSource.createUIContact(metaContact);
            }
        }
        if (parentUIContact != null && parentUIContactCreated) {
            ContactListFilter currentFilter = GuiActivator.getContactList().getCurrentFilter();
            if (currentFilter.isMatching((UIContact)parentUIContact)) {
                MetaContactGroup parentGroup = metaContact.getParentMetaContactGroup();
                UIGroupImpl uiGroup = null;
                if (!MetaContactListSource.isRootGroup(parentGroup)) {
                    MetaContactGroup metaContactGroup = parentGroup;
                    synchronized (metaContactGroup) {
                        uiGroup = MetaContactListSource.getUIGroup(parentGroup);
                        if (uiGroup == null) {
                            uiGroup = MetaContactListSource.createUIGroup(parentGroup);
                        }
                    }
                }
                GuiActivator.getContactList().addContact(parentUIContact, uiGroup, true, true);
            } else {
                MetaContactListSource.removeUIContact(metaContact);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protoContactModified(ProtoContactEvent evt) {
        UIContactImpl uiContact;
        MetaContact metaContact;
        Object object = metaContact = evt.getNewParent();
        synchronized (object) {
            uiContact = MetaContactListSource.getUIContact(metaContact);
            if (uiContact == null) {
                return;
            }
        }
        object = uiContact;
        synchronized (object) {
            ContactNode contactNode = uiContact.getContactNode();
            if (contactNode != null) {
                GuiActivator.getContactList().nodeChanged(contactNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protoContactMoved(ProtoContactEvent evt) {
        UIContactImpl newUIContact;
        UIContactImpl oldUIContact;
        MetaContact oldParent = evt.getOldParent();
        MetaContact newParent = evt.getNewParent();
        MetaContact metaContact = oldParent;
        synchronized (metaContact) {
            oldUIContact = MetaContactListSource.getUIContact(oldParent);
        }
        if (oldUIContact != null && !GuiActivator.getContactList().getCurrentFilter().isMatching((UIContact)oldUIContact)) {
            GuiActivator.getContactList().removeContact(oldUIContact);
        }
        boolean newUIContactCreated = false;
        MetaContact metaContact2 = newParent;
        synchronized (metaContact2) {
            newUIContact = MetaContactListSource.getUIContact(newParent);
            if (newUIContact == null) {
                newUIContactCreated = true;
                newUIContact = MetaContactListSource.createUIContact(newParent);
            }
        }
        if (newUIContact != null && newUIContactCreated) {
            if (GuiActivator.getContactList().getCurrentFilter().isMatching((UIContact)newUIContact)) {
                MetaContactGroup parentGroup = newParent.getParentMetaContactGroup();
                UIGroupImpl uiGroup = null;
                if (!MetaContactListSource.isRootGroup(parentGroup)) {
                    uiGroup = MetaContactListSource.getUIGroup(parentGroup);
                    MetaContactGroup metaContactGroup = parentGroup;
                    synchronized (metaContactGroup) {
                        if (uiGroup == null) {
                            uiGroup = MetaContactListSource.createUIGroup(parentGroup);
                        }
                    }
                }
                GuiActivator.getContactList().addContact(newUIContact, uiGroup, true, true);
            } else {
                MetaContactListSource.removeUIContact(newParent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void protoContactRemoved(ProtoContactEvent evt) {
        UIContactImpl oldUIContact;
        MetaContact oldParent;
        Object object = oldParent = evt.getOldParent();
        synchronized (object) {
            oldUIContact = MetaContactListSource.getUIContact(oldParent);
            if (oldUIContact == null) {
                return;
            }
        }
        object = oldUIContact;
        synchronized (object) {
            ContactNode contactNode = oldUIContact.getContactNode();
            if (contactNode != null) {
                GuiActivator.getContactList().nodeChanged(contactNode);
            }
        }
    }

    public static Collection<SIPCommButton> getContactCustomActionButtons(MetaUIContact metaContact) {
        customActionContact = metaContact;
        if (customActionButtons == null) {
            MetaContactListSource.initCustomActionButtons();
        }
        Iterator<ContactAction<Contact>> customActionsIter = customActionButtons.keySet().iterator();
        LinkedList<SIPCommButton> availableCustomActionButtons = new LinkedList<SIPCommButton>();
        while (customActionsIter.hasNext()) {
            ContactAction<Contact> contactAction = customActionsIter.next();
            SIPCommButton actionButton = customActionButtons.get(contactAction);
            if (!MetaContactListSource.isContactActionVisible(contactAction, (MetaContact)metaContact.getDescriptor())) continue;
            availableCustomActionButtons.add(actionButton);
        }
        return availableCustomActionButtons;
    }

    private static boolean isContactActionVisible(ContactAction<Contact> contactAction, MetaContact metaContact) {
        Iterator contactDetails = metaContact.getContacts();
        while (contactDetails.hasNext()) {
            if (!contactAction.isVisible(contactDetails.next())) continue;
            return true;
        }
        return false;
    }

    private static void initCustomActionButtons() {
        customActionButtons = new LinkedHashMap<ContactAction<Contact>, SIPCommButton>();
        for (CustomContactActionsService<Contact> ccas : MetaContactListSource.getContactActionsServices()) {
            Iterator actionIterator = ccas.getCustomContactActions();
            while (actionIterator != null && actionIterator.hasNext()) {
                final ContactAction ca = (ContactAction)actionIterator.next();
                SIPCommButton actionButton = customActionButtons.get(ca);
                if (actionButton != null) continue;
                actionButton = new SIPCommButton();
                actionButton.setToolTipText(ca.getToolTipText());
                actionButton.setIconImage(new ImageIcon(ca.getIcon()).getImage());
                actionButton.setRolloverIcon(new ImageIcon(ca.getRolloverIcon()).getImage());
                actionButton.setPressedIcon(new ImageIcon(ca.getPressedIcon()).getImage());
                actionButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        List<UIContactDetail> contactDetails = customActionContact.getContactDetails();
                        UIContactDetailCustomAction contactAction = new UIContactDetailCustomAction((ContactAction<Contact>)ca);
                        if (contactDetails.size() > 1) {
                            ChooseUIContactDetailPopupMenu detailsPopupMenu = new ChooseUIContactDetailPopupMenu((JButton)e.getSource(), customActionContact.getContactDetails(), contactAction);
                            detailsPopupMenu.showPopupMenu();
                        } else if (contactDetails.size() == 1) {
                            JButton button = (JButton)e.getSource();
                            Point location = new Point(button.getX(), button.getY() + button.getHeight());
                            SwingUtilities.convertPointToScreen(location, GuiActivator.getContactList());
                            location.y += GuiActivator.getContactList().getPathBounds((TreePath)GuiActivator.getContactList().getSelectionPath()).y;
                            contactAction.actionPerformed(contactDetails.get(0), location.x, location.y);
                        }
                    }
                });
                customActionButtons.put((ContactAction<Contact>)ca, actionButton);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    private static List<CustomContactActionsService<Contact>> getContactActionsServices() {
        ArrayList<CustomContactActionsService<Contact>> contactActionsServices = new ArrayList<CustomContactActionsService<Contact>>();
        ServiceReference[] serRefs = null;
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(CustomContactActionsService.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            logger.error((Object)("GuiActivator : " + (Object)((Object)e)));
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                CustomContactActionsService customActionService = (CustomContactActionsService)GuiActivator.bundleContext.getService(serRef);
                if (!customActionService.getContactSourceClass().equals(Contact.class)) continue;
                contactActionsServices.add((CustomContactActionsService<Contact>)customActionService);
            }
        }
        return contactActionsServices;
    }

    static {
        logger = Logger.getLogger(MetaContactListSource.class);
    }

    private static class UIContactDetailCustomAction
    implements UIContactDetailAction {
        private final ContactAction<Contact> contactAction;

        public UIContactDetailCustomAction(ContactAction<Contact> contactAction) {
            this.contactAction = contactAction;
        }

        public void actionPerformed(UIContactDetail contactDetail, int x, int y) {
            try {
                this.contactAction.actionPerformed((Object)((Contact)contactDetail.getDescriptor()), x, y);
            }
            catch (OperationFailedException e) {
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), e.getMessage());
            }
        }
    }
}

