/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.Component;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenu;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class PluginContainer
implements PluginComponentListener {
    private static final Logger logger = Logger.getLogger(PluginContainer.class);
    private final JComponent container;
    private final Container containerId;
    private final List<PluginComponent> pluginComponents = new LinkedList<PluginComponent>();

    public PluginContainer(JComponent container, Container containerId) {
        this.container = container;
        this.containerId = containerId;
        this.initPluginComponents();
    }

    protected void addComponentToContainer(Component component, JComponent container, int preferredIndex) {
        if (0 <= preferredIndex && preferredIndex < this.getComponentCount(container)) {
            container.add(component, preferredIndex);
        } else {
            container.add(component);
        }
    }

    private synchronized void addPluginComponent(PluginComponentFactory factory) {
        PluginComponent c = factory.getPluginComponentInstance((Object)this);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Will add plugin component: " + c));
        }
        int cIndex = factory.getPositionIndex();
        int index = -1;
        int i = 0;
        for (PluginComponent pluginComponent : this.pluginComponents) {
            if (pluginComponent.equals(c)) {
                return;
            }
            if (-1 == index) {
                int pluginComponentIndex = factory.getPositionIndex();
                if (0 == cIndex || -1 == cIndex) {
                    if (0 != pluginComponentIndex && cIndex != pluginComponentIndex) {
                        index = i;
                    }
                } else if (cIndex < pluginComponentIndex) {
                    index = i;
                }
            }
            ++i;
        }
        int pluginComponentCount = this.pluginComponents.size();
        if (-1 == index) {
            index = this.pluginComponents.size();
        }
        int containerComponentCount = this.getComponentCount(this.container);
        this.addComponentToContainer((Component)c.getComponent(), this.container, containerComponentCount > pluginComponentCount ? index + (containerComponentCount - pluginComponentCount) : index);
        this.pluginComponents.add(index, c);
        this.container.revalidate();
        this.container.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        GuiActivator.getUIService().removePluginComponentListener(this);
        PluginContainer pluginContainer = this;
        synchronized (pluginContainer) {
            for (PluginComponent pluginComponent : this.pluginComponents) {
                this.container.remove((Component)pluginComponent.getComponent());
            }
            this.pluginComponents.clear();
        }
    }

    protected int getComponentCount(JComponent container) {
        return container instanceof JMenu ? ((JMenu)container).getMenuComponentCount() : container.getComponentCount();
    }

    public Iterable<PluginComponent> getPluginComponents() {
        return this.pluginComponents;
    }

    private void initPluginComponents() {
        GuiActivator.getUIService().addPluginComponentListener(this);
        ServiceReference[] serRefs = null;
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class.getName(), "(CONTAINER_ID=" + this.containerId.getID() + ")");
        }
        catch (InvalidSyntaxException exc) {
            logger.error((Object)"Could not obtain plugin reference.", (Throwable)exc);
        }
        if (serRefs != null) {
            for (ServiceReference serRef : serRefs) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRef);
                this.addPluginComponent(factory);
            }
        }
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (factory.getContainer().equals((Object)this.containerId)) {
            this.addPluginComponent(factory);
        }
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (factory.getContainer().equals((Object)this.containerId)) {
            this.removePluginComponent(factory);
        }
    }

    private synchronized void removePluginComponent(PluginComponentFactory factory) {
        Iterator<PluginComponent> iterator = this.pluginComponents.iterator();
        while (iterator.hasNext()) {
            PluginComponent c = iterator.next();
            if (!c.getParentFactory().equals(factory)) continue;
            iterator.remove();
            this.container.remove((Component)c.getComponent());
        }
    }
}

