/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.contactsource;

import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.contactsource.ContactChangedEvent;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactQueryStatusEvent;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.ContactRemovedEvent;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;

public abstract class AbstractContactQuery<T extends ContactSourceService>
implements ContactQuery {
    private final T contactSource;
    private final List<ContactQueryListener> listeners = new LinkedList<ContactQueryListener>();
    private int status = 3;

    protected AbstractContactQuery(T contactSource) {
        this.contactSource = contactSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContactQueryListener(ContactQueryListener l) {
        if (l == null) {
            throw new NullPointerException("l");
        }
        List<ContactQueryListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }
    }

    @Override
    public void cancel() {
        if (this.getStatus() == 3) {
            this.setStatus(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactReceived(SourceContact contact, boolean showMoreEnabled) {
        ContactQueryListener[] ls;
        List<ContactQueryListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ContactQueryListener[this.listeners.size()]);
        }
        ContactReceivedEvent ev = new ContactReceivedEvent(this, contact, showMoreEnabled);
        for (ContactQueryListener l : ls) {
            l.contactReceived(ev);
        }
    }

    protected void fireContactReceived(SourceContact contact) {
        this.fireContactReceived(contact, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactRemoved(SourceContact contact) {
        ContactQueryListener[] ls;
        List<ContactQueryListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ContactQueryListener[this.listeners.size()]);
        }
        ContactRemovedEvent ev = new ContactRemovedEvent(this, contact);
        for (ContactQueryListener l : ls) {
            l.contactRemoved(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireContactChanged(SourceContact contact) {
        ContactQueryListener[] ls;
        List<ContactQueryListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ContactQueryListener[this.listeners.size()]);
        }
        ContactChangedEvent ev = new ContactChangedEvent(this, contact);
        for (ContactQueryListener l : ls) {
            l.contactChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireQueryStatusChanged(int eventType) {
        ContactQueryListener[] ls;
        List<ContactQueryListener> list = this.listeners;
        synchronized (list) {
            ls = this.listeners.toArray(new ContactQueryListener[this.listeners.size()]);
        }
        ContactQueryStatusEvent ev = new ContactQueryStatusEvent(this, eventType);
        for (ContactQueryListener l : ls) {
            l.queryStatusChanged(ev);
        }
    }

    public T getContactSource() {
        return this.contactSource;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContactQueryListener(ContactQueryListener l) {
        if (l != null) {
            List<ContactQueryListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(l);
            }
        }
    }

    public void setStatus(int status) {
        if (this.status != status) {
            int eventType;
            switch (status) {
                case 1: {
                    eventType = 1;
                    break;
                }
                case 0: {
                    eventType = 0;
                    break;
                }
                case 2: {
                    eventType = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("status");
                }
            }
            this.status = status;
            this.fireQueryStatusChanged(eventType);
        }
    }
}

