/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia;

import java.util.Objects;
import org.jitsi.service.neomedia.ByteArrayBuffer;

public class ByteArrayBufferImpl
implements ByteArrayBuffer {
    private byte[] buffer;
    private int offset;
    private int length;

    public ByteArrayBufferImpl(byte[] buffer, int offset, int length) {
        this.buffer = Objects.requireNonNull(buffer, "buffer");
        if (offset + length > buffer.length || length < 0 || offset < 0) {
            throw new IllegalArgumentException("length or offset");
        }
        this.offset = offset;
        this.length = length;
    }

    public ByteArrayBufferImpl(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size");
        }
        this.buffer = new byte[size];
        this.offset = 0;
        this.length = size;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        if (this.offset + length > this.buffer.length || length < 0) {
            throw new IllegalArgumentException("length");
        }
        this.length = length;
    }

    @Override
    public void setOffset(int offset) {
        if (offset + this.length > this.buffer.length || offset < 0) {
            throw new IllegalArgumentException("offset");
        }
        this.offset = offset;
    }

    public void setOffsetLength(int offset, int length) {
        if (offset + length > this.buffer.length || length < 0 || offset < 0) {
            throw new IllegalArgumentException("length or offset");
        }
        this.offset = offset;
        this.length = length;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }
}

