/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.recording;

import com.sun.media.util.Registry;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.media.CaptureDeviceInfo;
import javax.media.Codec;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Effect;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NoProcessorException;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.UnsupportedPlugInException;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushBufferStream;
import javax.media.protocol.PushSourceStream;
import javax.media.protocol.SourceTransferHandler;
import javax.media.rtp.OutputDataStream;
import javax.media.rtp.RTPConnector;
import javax.media.rtp.RTPManager;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.event.TimeoutEvent;
import org.jitsi.impl.neomedia.ActiveSpeakerDetectorImpl;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.audiolevel.AudioLevelEffect;
import org.jitsi.impl.neomedia.codec.SilenceEffect;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.impl.neomedia.recording.PacketBuffer;
import org.jitsi.impl.neomedia.recording.SynchronizerImpl;
import org.jitsi.impl.neomedia.recording.WebmDataSink;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.rtp.translator.RTCPFeedbackMessageSender;
import org.jitsi.impl.neomedia.rtp.translator.RTPTranslatorImpl;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.REDTransformEngine;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.impl.neomedia.transform.TransformEngineChain;
import org.jitsi.impl.neomedia.transform.fec.FECTransformEngine;
import org.jitsi.impl.neomedia.transform.rtcp.CompoundPacketEngine;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.ActiveSpeakerDetector;
import org.jitsi.service.neomedia.MediaException;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.control.FlushableControl;
import org.jitsi.service.neomedia.control.KeyFrameControlAdapter;
import org.jitsi.service.neomedia.event.ActiveSpeakerChangedListener;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.recording.Recorder;
import org.jitsi.service.neomedia.recording.RecorderEvent;
import org.jitsi.service.neomedia.recording.RecorderEventHandler;
import org.jitsi.service.neomedia.recording.Synchronizer;
import org.jitsi.util.Logger;

public class RecorderRtpImpl
implements Recorder,
ReceiveStreamListener,
ActiveSpeakerChangedListener,
ControllerListener {
    private static final Logger logger = Logger.getLogger(RecorderRtpImpl.class);
    private static final ConfigurationService cfg = LibJitsi.getConfigurationService();
    private static final byte redPayloadType = 116;
    private static final byte ulpfecPayloadType = 117;
    private static final byte vp8PayloadType = 100;
    private static final byte opusPayloadType = 111;
    private static final Format redFormat = new VideoFormat("red");
    private static final Format ulpfecFormat = new VideoFormat("ulpfec");
    private static final Format vp8RtpFormat = new VideoFormat("VP8/rtp");
    private static final Format vp8Format = new VideoFormat("VP8");
    private static final Format opusFormat = new AudioFormat("opus/rtp", 48000.0, -1, -1);
    private static final String FMJ_VIDEO_JITTER_BUFFER_MIN_SIZE_PNAME = RecorderRtpImpl.class.getCanonicalName() + ".FMJ_VIDEO_JITTER_BUFFER_MIN_SIZE";
    private static final int FMJ_VIDEO_JITTER_BUFFER_MIN_SIZE = cfg.getInt(FMJ_VIDEO_JITTER_BUFFER_MIN_SIZE_PNAME, 300);
    private static final String FMJ_AUDIO_JITTER_BUFFER_MIN_SIZE_PNAME = RecorderRtpImpl.class.getCanonicalName() + ".FMJ_AUDIO_JITTER_BUFFER_MIN_SIZE_PNAME";
    private static final int FMJ_AUDIO_JITTER_BUFFER_MIN_SIZE = cfg.getInt(FMJ_AUDIO_JITTER_BUFFER_MIN_SIZE_PNAME, 16);
    private static String PERFORM_ASD_PNAME = RecorderRtpImpl.class.getCanonicalName() + ".PERFORM_ASD";
    private static String AUDIO_CODEC_PNAME = RecorderRtpImpl.class.getCanonicalName() + ".AUDIO_CODEC";
    private static ContentDescriptor AUDIO_CONTENT_DESCRIPTOR = new ContentDescriptor("audio.mpeg");
    private static String AUDIO_FILENAME_SUFFIX = ".mp3";
    private static final String VIDEO_FILENAME_SUFFIX = ".webm";
    private RTPTranslatorImpl translator;
    private RTPConnectorImpl rtpConnector;
    private String path;
    private RTCPFeedbackMessageSender rtcpFeedbackSender;
    private RTPManager rtpManager;
    private RecorderEventHandlerImpl eventHandler;
    private final HashSet<ReceiveStreamDesc> receiveStreams = new HashSet();
    private final Set<Long> activeVideoSsrcs = new HashSet<Long>();
    private ActiveSpeakerDetector activeSpeakerDetector = null;
    private final boolean performActiveSpeakerDetection;
    StreamRTPManager streamRTPManager;
    private SynchronizerImpl synchronizer;
    private boolean started = false;
    private MediaStream mediaStream;

    public RecorderRtpImpl(RTPTranslator translator) {
        this.translator = (RTPTranslatorImpl)translator;
        boolean performActiveSpeakerDetection = false;
        if (cfg != null) {
            performActiveSpeakerDetection = cfg.getBoolean(PERFORM_ASD_PNAME, performActiveSpeakerDetection);
            String audioCodec = cfg.getString(AUDIO_CODEC_PNAME);
            if ("wav".equalsIgnoreCase(audioCodec)) {
                AUDIO_FILENAME_SUFFIX = ".wav";
                AUDIO_CONTENT_DESCRIPTOR = new ContentDescriptor("audio.x_wav");
            }
        }
        this.performActiveSpeakerDetection = performActiveSpeakerDetection;
    }

    @Override
    public void addListener(Recorder.Listener listener) {
    }

    @Override
    public void removeListener(Recorder.Listener listener) {
    }

    @Override
    public List<String> getSupportedFormats() {
        return null;
    }

    @Override
    public void setMute(boolean mute) {
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public void setEventHandler(RecorderEventHandler eventHandler) {
        if (this.eventHandler == null || this.eventHandler != eventHandler && this.eventHandler.handler != eventHandler) {
            if (this.eventHandler == null) {
                this.eventHandler = new RecorderEventHandlerImpl(eventHandler);
            } else {
                this.eventHandler.handler = eventHandler;
            }
        }
    }

    @Override
    public void start(String format, String dirname) throws IOException, MediaException {
        if (logger.isInfoEnabled()) {
            logger.info("Starting, format=" + format + " " + this.hashCode());
        }
        this.path = dirname;
        MediaService mediaService = LibJitsi.getMediaService();
        if (this.performActiveSpeakerDetection) {
            this.activeSpeakerDetector = new ActiveSpeakerDetectorImpl();
            this.activeSpeakerDetector.addActiveSpeakerChangedListener(this);
        }
        this.rtpConnector = new RTPConnectorImpl(116, 117);
        this.rtpManager = RTPManager.newInstance();
        this.rtpManager.addFormat(vp8RtpFormat, 100);
        this.rtpManager.addFormat(opusFormat, 111);
        this.rtpManager.addReceiveStreamListener((ReceiveStreamListener)this);
        this.rtpManager.initialize((RTPConnector)this.rtpConnector);
        this.mediaStream = mediaService.createMediaStream(new MediaDeviceImpl(new CaptureDeviceInfo(), MediaType.VIDEO));
        this.streamRTPManager = new StreamRTPManager(this.mediaStream, this.translator);
        this.streamRTPManager.initialize(this.rtpConnector);
        this.rtcpFeedbackSender = this.translator.getRtcpFeedbackMessageSender();
        this.translator.addFormat(this.streamRTPManager, opusFormat, 111);
        this.started = true;
    }

    @Override
    public MediaStream getMediaStream() {
        return this.mediaStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.started) {
            if (logger.isInfoEnabled()) {
                logger.info("Stopping " + this.hashCode());
            }
            if (this.streamRTPManager != null) {
                this.streamRTPManager.dispose();
            }
            HashSet<ReceiveStreamDesc> streamsToRemove = new HashSet<ReceiveStreamDesc>();
            HashSet<ReceiveStreamDesc> hashSet = this.receiveStreams;
            synchronized (hashSet) {
                streamsToRemove.addAll(this.receiveStreams);
            }
            for (ReceiveStreamDesc r : streamsToRemove) {
                this.removeReceiveStream(r, false);
            }
            this.rtpConnector.rtcpPacketTransformer.close();
            this.rtpConnector.rtpPacketTransformer.close();
            this.rtpManager.dispose();
            if (this.activeSpeakerDetector != null) {
                this.activeSpeakerDetector.removeActiveSpeakerChangedListener(this);
            }
            this.started = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ReceiveStreamEvent event) {
        if (event == null) {
            return;
        }
        ReceiveStream receiveStream = event.getReceiveStream();
        if (event instanceof NewReceiveStreamEvent) {
            int streamCount;
            Format format;
            DataSource dataSource;
            if (receiveStream == null) {
                logger.warn("NewReceiveStreamEvent: null");
                return;
            }
            final long ssrc = this.getReceiveStreamSSRC(receiveStream);
            ReceiveStreamDesc receiveStreamDesc = this.findReceiveStream(ssrc);
            if (receiveStreamDesc != null) {
                String s = "NewReceiveStreamEvent for an existing SSRC. ";
                if (receiveStream != receiveStreamDesc.receiveStream) {
                    s = s + "(but different ReceiveStream object)";
                }
                logger.warn(s);
                return;
            }
            receiveStreamDesc = new ReceiveStreamDesc(receiveStream);
            if (logger.isInfoEnabled()) {
                logger.info("New ReceiveStream, ssrc=" + ssrc);
            }
            if ((dataSource = receiveStream.getDataSource()) instanceof PushBufferDataSource) {
                PushBufferStream pbs;
                format = null;
                PushBufferDataSource pbds = (PushBufferDataSource)dataSource;
                PushBufferStream[] pushBufferStreamArray = pbds.getStreams();
                int n = pushBufferStreamArray.length;
                for (int i = 0; i < n && (format = (pbs = pushBufferStreamArray[i]).getFormat()) == null; ++i) {
                }
                if (format == null) {
                    logger.error("Failed to handle new ReceiveStream: Failed to determine format");
                    return;
                }
            } else {
                logger.error("Failed to handle new ReceiveStream: Unsupported DataSource");
                return;
            }
            receiveStreamDesc.format = format;
            int rtpClockRate = -1;
            if (receiveStreamDesc.format instanceof AudioFormat) {
                rtpClockRate = (int)((AudioFormat)receiveStreamDesc.format).getSampleRate();
            } else if (receiveStreamDesc.format instanceof VideoFormat) {
                rtpClockRate = 90000;
            }
            this.getSynchronizer().setRtpClockRate(ssrc, rtpClockRate);
            Processor processor = null;
            try {
                processor = Manager.createProcessor((DataSource)receiveStream.getDataSource());
            }
            catch (NoProcessorException npe) {
                logger.error("Failed to create Processor: ", npe);
                return;
            }
            catch (IOException ioe) {
                logger.error("Failed to create Processor: ", ioe);
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Created processor for SSRC=" + ssrc);
            }
            processor.addControllerListener((ControllerListener)this);
            receiveStreamDesc.processor = processor;
            HashSet<ReceiveStreamDesc> hashSet = this.receiveStreams;
            synchronized (hashSet) {
                this.receiveStreams.add(receiveStreamDesc);
                streamCount = this.receiveStreams.size();
            }
            if (receiveStreamDesc.format instanceof AudioFormat) {
                final Processor p = processor;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            int ms = 450 * (streamCount - 1);
                            logger.warn("Sleeping for " + ms + "ms before configuring processor for SSRC=" + ssrc + " " + System.currentTimeMillis());
                            Thread.sleep(ms);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        p.configure();
                    }
                }.run();
            } else {
                processor.configure();
            }
        } else if (event instanceof TimeoutEvent) {
            if (receiveStream == null) {
                logger.warn("TimeoutEvent: null.");
                return;
            }
            ReceiveStreamDesc receiveStreamDesc = this.findReceiveStream(this.getReceiveStreamSSRC(receiveStream));
            if (receiveStreamDesc != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("ReceiveStream timeout, ssrc=" + receiveStreamDesc.ssrc);
                }
                this.removeReceiveStream(receiveStreamDesc, true);
            } else if (logger.isInfoEnabled()) {
                logger.info("ReceiveStream timeout for an unknown stream (already removed?) " + this.getReceiveStreamSSRC(receiveStream));
            }
        } else if (event != null && logger.isInfoEnabled()) {
            logger.info("Unhandled ReceiveStreamEvent (" + event.getClass().getName() + "): " + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReceiveStream(ReceiveStreamDesc receiveStream, boolean emptyJB) {
        DataSource dataSource;
        long ssrc = receiveStream.ssrc;
        if (receiveStream.format instanceof VideoFormat) {
            this.rtpConnector.packetBuffer.disable(ssrc);
            this.emptyPacketBuffer(ssrc);
            this.getSynchronizer().removeMapping(ssrc);
            this.rtpConnector.packetBuffer.reset(ssrc);
        }
        if (receiveStream.dataSink != null) {
            try {
                receiveStream.dataSink.stop();
            }
            catch (IOException e) {
                logger.error("Failed to stop DataSink " + e);
            }
            receiveStream.dataSink.close();
        }
        if (receiveStream.processor != null) {
            receiveStream.processor.stop();
            receiveStream.processor.close();
        }
        if ((dataSource = receiveStream.receiveStream.getDataSource()) != null) {
            try {
                dataSource.stop();
            }
            catch (IOException ioe) {
                logger.warn("Failed to stop DataSource");
            }
            dataSource.disconnect();
        }
        Set<Object> set = this.receiveStreams;
        synchronized (set) {
            this.receiveStreams.remove(receiveStream);
        }
        set = this.activeVideoSsrcs;
        synchronized (set) {
            if (this.activeVideoSsrcs.contains(ssrc)) {
                this.activeVideoSsrcs.remove(ssrc);
            }
        }
    }

    public void controllerUpdate(ControllerEvent ev) {
        if (ev == null || ev.getSourceController() == null) {
            return;
        }
        Processor processor = (Processor)ev.getSourceController();
        ReceiveStreamDesc desc = this.findReceiveStream(processor);
        if (desc == null) {
            logger.warn("Event from an orphaned processor, ignoring: " + ev);
            return;
        }
        if (ev instanceof ConfigureCompleteEvent) {
            ContentDescriptor cd;
            boolean audio;
            if (logger.isInfoEnabled()) {
                logger.info("Configured processor for ReceiveStream ssrc=" + desc.ssrc + " (" + desc.format + ") " + System.currentTimeMillis());
            }
            if ((audio = desc.format instanceof AudioFormat) && !AUDIO_CONTENT_DESCRIPTOR.equals((Object)(cd = processor.setContentDescriptor(AUDIO_CONTENT_DESCRIPTOR)))) {
                logger.error("Failed to set the Processor content descriptor to " + AUDIO_CONTENT_DESCRIPTOR + ". Actual result: " + cd);
                this.removeReceiveStream(desc, false);
                return;
            }
            for (TrackControl track : processor.getTrackControls()) {
                Format trackFormat = track.getFormat();
                if (audio) {
                    LinkedList<Effect> codecList = new LinkedList<Effect>();
                    final long ssrc = desc.ssrc;
                    SilenceEffect silenceEffect = "opus/rtp".equals(desc.format.getEncoding()) ? new SilenceEffect(48000) : new SilenceEffect();
                    silenceEffect.setListener(new SilenceEffect.Listener(){
                        boolean first = true;

                        @Override
                        public void onSilenceNotInserted(long timestamp) {
                            if (this.first) {
                                this.first = false;
                                RecorderRtpImpl.this.audioRecordingStarted(ssrc, timestamp);
                            } else {
                                RecorderRtpImpl.this.resetRecording(ssrc, timestamp);
                            }
                        }
                    });
                    desc.silenceEffect = silenceEffect;
                    codecList.add(silenceEffect);
                    if (this.performActiveSpeakerDetection) {
                        AudioLevelEffect audioLevelEffect = new AudioLevelEffect();
                        audioLevelEffect.setAudioLevelListener(new SimpleAudioLevelListener(){

                            @Override
                            public void audioLevelChanged(int level) {
                                RecorderRtpImpl.this.activeSpeakerDetector.levelChanged(ssrc, level);
                            }
                        });
                        codecList.add(audioLevelEffect);
                    }
                    try {
                        track.setCodecChain(codecList.toArray(new Codec[codecList.size()]));
                    }
                    catch (UnsupportedPlugInException upie) {
                        logger.warn("Failed to insert silence effect: " + (Object)((Object)upie));
                    }
                    continue;
                }
                if (trackFormat.matches(vp8RtpFormat)) {
                    track.setFormat(vp8Format);
                    continue;
                }
                logger.error("Unsupported track format: " + trackFormat + " for ssrc=" + desc.ssrc);
                this.removeReceiveStream(desc, false);
                return;
            }
            processor.realize();
        } else if (ev instanceof RealizeCompleteEvent) {
            WebmDataSink dataSink;
            desc.dataSource = processor.getDataOutput();
            long ssrc = desc.ssrc;
            boolean audio = desc.format instanceof AudioFormat;
            String suffix = audio ? AUDIO_FILENAME_SUFFIX : VIDEO_FILENAME_SUFFIX;
            String filename = this.getNextFilename(this.path + "/" + ssrc, suffix);
            desc.filename = filename;
            if (audio) {
                try {
                    dataSink = Manager.createDataSink((DataSource)desc.dataSource, (MediaLocator)new MediaLocator("file:" + filename));
                }
                catch (NoDataSinkException ndse) {
                    logger.error("Could not create DataSink: " + (Object)((Object)ndse));
                    this.removeReceiveStream(desc, false);
                    return;
                }
            } else {
                dataSink = new WebmDataSink(filename, desc.dataSource);
            }
            if (logger.isInfoEnabled()) {
                logger.info("Created DataSink (" + dataSink + ") for SSRC=" + ssrc + ". Output filename: " + filename);
            }
            try {
                dataSink.open();
            }
            catch (IOException e) {
                logger.error("Failed to open DataSink (" + dataSink + ") for SSRC=" + ssrc + ": " + e);
                this.removeReceiveStream(desc, false);
                return;
            }
            if (!audio) {
                final WebmDataSink webmDataSink = dataSink;
                webmDataSink.setSsrc(ssrc);
                webmDataSink.setEventHandler(this.eventHandler);
                webmDataSink.setKeyFrameControl(new KeyFrameControlAdapter(){

                    @Override
                    public boolean requestKeyFrame(boolean urgent) {
                        return RecorderRtpImpl.this.requestFIR(webmDataSink);
                    }
                });
            }
            try {
                dataSink.start();
            }
            catch (IOException e) {
                logger.error("Failed to start DataSink (" + dataSink + ") for SSRC=" + ssrc + ". " + e);
                this.removeReceiveStream(desc, false);
                return;
            }
            if (logger.isInfoEnabled()) {
                logger.info("Started DataSink for SSRC=" + ssrc);
            }
            desc.dataSink = dataSink;
            processor.start();
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unhandled ControllerEvent from the Processor for ssrc=" + desc.ssrc + ": " + ev);
        }
    }

    private void resetRecording(long ssrc, long timestamp) {
        ReceiveStreamDesc receiveStream = this.findReceiveStream(ssrc);
        if (receiveStream != null && receiveStream.format instanceof AudioFormat) {
            String newFilename = this.getNextFilename(this.path + "/" + ssrc, AUDIO_FILENAME_SUFFIX);
            Processor p = receiveStream.processor;
            if (p != null) {
                for (TrackControl tc : p.getTrackControls()) {
                    Object o = tc.getControl(FlushableControl.class.getName());
                    if (o == null) continue;
                    ((FlushableControl)o).flush();
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Restarting recording for SSRC=" + ssrc + ". New filename: " + newFilename);
            }
            receiveStream.dataSink.close();
            receiveStream.dataSink = null;
            receiveStream.filename = newFilename;
            try {
                receiveStream.dataSink = Manager.createDataSink((DataSource)receiveStream.dataSource, (MediaLocator)new MediaLocator("file:" + newFilename));
            }
            catch (NoDataSinkException ndse) {
                logger.warn("Could not reset recording for SSRC=" + ssrc + ": " + (Object)((Object)ndse));
                this.removeReceiveStream(receiveStream, false);
            }
            try {
                receiveStream.dataSink.open();
                receiveStream.dataSink.start();
            }
            catch (IOException ioe) {
                logger.warn("Could not reset recording for SSRC=" + ssrc + ": " + ioe);
                this.removeReceiveStream(receiveStream, false);
            }
            this.audioRecordingStarted(ssrc, timestamp);
        }
    }

    private void audioRecordingStarted(long ssrc, long timestamp) {
        ReceiveStreamDesc desc = this.findReceiveStream(ssrc);
        if (desc == null) {
            return;
        }
        RecorderEvent event = new RecorderEvent();
        event.setType(RecorderEvent.Type.RECORDING_STARTED);
        event.setMediaType(MediaType.AUDIO);
        event.setSsrc(ssrc);
        event.setRtpTimestamp(timestamp);
        event.setFilename(desc.filename);
        if (this.eventHandler != null) {
            this.eventHandler.handleEvent(event);
        }
    }

    private boolean requestFIR(WebmDataSink dataSink) {
        ReceiveStreamDesc desc = this.findReceiveStream(dataSink);
        if (desc != null && this.rtcpFeedbackSender != null) {
            return this.rtcpFeedbackSender.sendFIR((int)desc.ssrc);
        }
        return false;
    }

    private String getNextFilename(String prefix, String suffix) {
        if (!new File(prefix + suffix).exists()) {
            return prefix + suffix;
        }
        int i = 1;
        do {
            String s;
            if (new File(s = prefix + "-" + i + suffix).exists()) continue;
            return s;
        } while (++i < 1000);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveStreamDesc findReceiveStream(Processor processor) {
        if (processor == null) {
            return null;
        }
        HashSet<ReceiveStreamDesc> hashSet = this.receiveStreams;
        synchronized (hashSet) {
            for (ReceiveStreamDesc r : this.receiveStreams) {
                if (!processor.equals(r.processor)) continue;
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveStreamDesc findReceiveStream(DataSink dataSink) {
        if (dataSink == null) {
            return null;
        }
        HashSet<ReceiveStreamDesc> hashSet = this.receiveStreams;
        synchronized (hashSet) {
            for (ReceiveStreamDesc r : this.receiveStreams) {
                if (!dataSink.equals(r.dataSink)) continue;
                return r;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiveStreamDesc findReceiveStream(long ssrc) {
        HashSet<ReceiveStreamDesc> hashSet = this.receiveStreams;
        synchronized (hashSet) {
            for (ReceiveStreamDesc r : this.receiveStreams) {
                if (ssrc != r.ssrc) continue;
                return r;
            }
        }
        return null;
    }

    private long getReceiveStreamSSRC(ReceiveStream receiveStream) {
        return 0xFFFFFFFFL & receiveStream.getSSRC();
    }

    @Override
    public void activeSpeakerChanged(long ssrc) {
        if (this.performActiveSpeakerDetection && this.eventHandler != null) {
            RecorderEvent e = new RecorderEvent();
            e.setAudioSsrc(ssrc);
            e.setInstant(System.currentTimeMillis());
            e.setType(RecorderEvent.Type.SPEAKER_CHANGED);
            e.setMediaType(MediaType.VIDEO);
            this.eventHandler.handleEvent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRtpPacket(RawPacket pkt) {
        long ssrc;
        if (pkt != null && pkt.getPayloadType() == 100 && !this.activeVideoSsrcs.contains(ssrc = pkt.getSSRCAsLong())) {
            Set<Long> set = this.activeVideoSsrcs;
            synchronized (set) {
                if (!this.activeVideoSsrcs.contains(ssrc)) {
                    this.activeVideoSsrcs.add(ssrc);
                    this.rtcpFeedbackSender.sendFIR((int)ssrc);
                }
            }
        }
    }

    private void handleRtcpPacket(RawPacket pkt) {
        this.getSynchronizer().addRTCPPacket(pkt);
        this.eventHandler.nudge();
    }

    @Override
    public SynchronizerImpl getSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new SynchronizerImpl();
        }
        return this.synchronizer;
    }

    @Override
    public void setSynchronizer(Synchronizer synchronizer) {
        if (synchronizer instanceof SynchronizerImpl) {
            this.synchronizer = (SynchronizerImpl)synchronizer;
        }
    }

    public void connect(Recorder recorder) {
        if (!(recorder instanceof RecorderRtpImpl)) {
            return;
        }
        ((RecorderRtpImpl)recorder).setSynchronizer(this.getSynchronizer());
    }

    private void emptyPacketBuffer(long ssrc) {
        RTPConnectorImpl.OutputDataStreamImpl dataStream;
        RawPacket[] pkts = this.rtpConnector.packetBuffer.emptyBuffer(ssrc);
        try {
            dataStream = this.rtpConnector.getDataOutputStream();
        }
        catch (IOException ioe) {
            logger.error("Failed to empty packet buffer for SSRC=" + ssrc + ": " + ioe);
            return;
        }
        for (RawPacket pkt : pkts) {
            dataStream.write(pkt.getBuffer(), pkt.getOffset(), pkt.getLength(), false);
        }
    }

    static {
        Registry.set((String)"video_jitter_buffer_MIN_SIZE", (Object)FMJ_VIDEO_JITTER_BUFFER_MIN_SIZE);
        Registry.set((String)"adaptive_jitter_buffer_MIN_SIZE", (Object)FMJ_AUDIO_JITTER_BUFFER_MIN_SIZE);
    }

    private class ReceiveStreamDesc {
        private ReceiveStream receiveStream;
        long ssrc;
        private Processor processor;
        private DataSink dataSink;
        private DataSource dataSource;
        private String filename;
        private Format format;
        private SilenceEffect silenceEffect;

        private ReceiveStreamDesc(ReceiveStream receiveStream) {
            this.receiveStream = receiveStream;
            this.ssrc = RecorderRtpImpl.this.getReceiveStreamSSRC(receiveStream);
        }
    }

    private class RecorderEventHandlerImpl
    implements RecorderEventHandler {
        private RecorderEventHandler handler;
        private final Set<RecorderEvent> pendingEvents = new HashSet<RecorderEvent>();

        private RecorderEventHandlerImpl(RecorderEventHandler handler) {
            this.handler = handler;
        }

        @Override
        public boolean handleEvent(RecorderEvent ev) {
            if (ev == null) {
                return true;
            }
            if (RecorderEvent.Type.RECORDING_STARTED.equals((Object)ev.getType())) {
                long instant = RecorderRtpImpl.this.getSynchronizer().getLocalTime(ev.getSsrc(), ev.getRtpTimestamp());
                if (instant != -1L) {
                    ev.setInstant(instant);
                    return this.handler.handleEvent(ev);
                }
                this.pendingEvents.add(ev);
                return true;
            }
            return this.handler.handleEvent(ev);
        }

        private void nudge() {
            Iterator<RecorderEvent> iter = this.pendingEvents.iterator();
            while (iter.hasNext()) {
                RecorderEvent ev = iter.next();
                long instant = RecorderRtpImpl.this.getSynchronizer().getLocalTime(ev.getSsrc(), ev.getRtpTimestamp());
                if (instant == -1L) continue;
                iter.remove();
                ev.setInstant(instant);
                this.handler.handleEvent(ev);
            }
        }

        @Override
        public void close() {
            for (RecorderEvent ev : this.pendingEvents) {
                this.handler.handleEvent(ev);
            }
        }
    }

    private class RTPConnectorImpl
    implements RTPConnector {
        private PushSourceStreamImpl controlInputStream;
        private OutputDataStreamImpl controlOutputStream;
        private PushSourceStreamImpl dataInputStream;
        private OutputDataStreamImpl dataOutputStream;
        private SourceTransferHandler dataTransferHandler;
        private SourceTransferHandler controlTransferHandler;
        private RawPacket pendingDataPacket = new RawPacket();
        private RawPacket pendingControlPacket = new RawPacket();
        private PacketTransformer rtpPacketTransformer = null;
        private PacketTransformer rtcpPacketTransformer = null;
        private PacketBuffer packetBuffer;

        private RTPConnectorImpl(byte redPT, byte ulpfecPT) {
            this.packetBuffer = new PacketBuffer();
            TransformEngineChain transformEngine = new TransformEngineChain(new TransformEngine[]{this.packetBuffer, new TransformEngineImpl(), new CompoundPacketEngine(), new FECTransformEngine(ulpfecPT, -1), new REDTransformEngine(redPT, -1)});
            this.rtpPacketTransformer = transformEngine.getRTPTransformer();
            this.rtcpPacketTransformer = transformEngine.getRTCPTransformer();
        }

        private RTPConnectorImpl() {
        }

        public void close() {
            try {
                if (this.dataOutputStream != null) {
                    this.dataOutputStream.close();
                }
                if (this.controlOutputStream != null) {
                    this.controlOutputStream.close();
                }
            }
            catch (IOException ioe) {
                throw new UndeclaredThrowableException(ioe);
            }
        }

        public PushSourceStream getControlInputStream() throws IOException {
            if (this.controlInputStream == null) {
                this.controlInputStream = new PushSourceStreamImpl(true);
            }
            return this.controlInputStream;
        }

        public OutputDataStream getControlOutputStream() throws IOException {
            if (this.controlOutputStream == null) {
                this.controlOutputStream = new OutputDataStreamImpl(true);
            }
            return this.controlOutputStream;
        }

        public PushSourceStream getDataInputStream() throws IOException {
            if (this.dataInputStream == null) {
                this.dataInputStream = new PushSourceStreamImpl(false);
            }
            return this.dataInputStream;
        }

        public OutputDataStreamImpl getDataOutputStream() throws IOException {
            if (this.dataOutputStream == null) {
                this.dataOutputStream = new OutputDataStreamImpl(false);
            }
            return this.dataOutputStream;
        }

        public double getRTCPBandwidthFraction() {
            return -1.0;
        }

        public double getRTCPSenderBandwidthFraction() {
            return -1.0;
        }

        public int getReceiveBufferSize() {
            return 0;
        }

        public int getSendBufferSize() {
            return 0;
        }

        public void setReceiveBufferSize(int arg0) throws IOException {
        }

        public void setSendBufferSize(int arg0) throws IOException {
        }

        private class TransformEngineImpl
        implements TransformEngine {
            SinglePacketTransformer rtpTransformer = new SinglePacketTransformerAdapter(){

                @Override
                public RawPacket reverseTransform(RawPacket pkt) {
                    RecorderRtpImpl.this.handleRtpPacket(pkt);
                    return pkt;
                }

                @Override
                public void close() {
                }
            };
            SinglePacketTransformer rtcpTransformer = new SinglePacketTransformerAdapter(){

                @Override
                public RawPacket reverseTransform(RawPacket pkt) {
                    RecorderRtpImpl.this.handleRtcpPacket(pkt);
                    if (pkt != null && pkt.getRTCPPacketType() == 203) {
                        ReceiveStreamDesc receiveStream;
                        long ssrc = pkt.getRTCPSSRC();
                        if (logger.isInfoEnabled()) {
                            logger.info("RTCP BYE for SSRC=" + ssrc);
                        }
                        if ((receiveStream = RecorderRtpImpl.this.findReceiveStream(ssrc)) != null) {
                            RecorderRtpImpl.this.removeReceiveStream(receiveStream, false);
                        }
                    } else if (pkt != null && pkt.getRTCPPacketType() == 201) {
                        return null;
                    }
                    return pkt;
                }

                @Override
                public void close() {
                }
            };

            private TransformEngineImpl() {
            }

            @Override
            public PacketTransformer getRTPTransformer() {
                return this.rtpTransformer;
            }

            @Override
            public PacketTransformer getRTCPTransformer() {
                return this.rtcpTransformer;
            }
        }

        private class PushSourceStreamImpl
        implements PushSourceStream {
            private boolean isControlStream = false;

            public PushSourceStreamImpl(boolean isControlStream) {
                this.isControlStream = isControlStream;
            }

            public boolean endOfStream() {
                return false;
            }

            public ContentDescriptor getContentDescriptor() {
                return null;
            }

            public long getContentLength() {
                return 0L;
            }

            public Object getControl(String arg0) {
                return null;
            }

            public Object[] getControls() {
                return null;
            }

            public int getMinimumTransferSize() {
                if (this.isControlStream) {
                    if (RTPConnectorImpl.this.pendingControlPacket.getBuffer() != null) {
                        return RTPConnectorImpl.this.pendingControlPacket.getLength();
                    }
                } else if (RTPConnectorImpl.this.pendingDataPacket.getBuffer() != null) {
                    return RTPConnectorImpl.this.pendingDataPacket.getLength();
                }
                return 0;
            }

            public int read(byte[] buffer, int offset, int length) throws IOException {
                RawPacket pendingPacket = this.isControlStream ? RTPConnectorImpl.this.pendingControlPacket : RTPConnectorImpl.this.pendingDataPacket;
                int bytesToRead = 0;
                byte[] pendingPacketBuffer = pendingPacket.getBuffer();
                if (pendingPacketBuffer != null) {
                    int pendingPacketLength = pendingPacket.getLength();
                    bytesToRead = length > pendingPacketLength ? pendingPacketLength : length;
                    System.arraycopy(pendingPacketBuffer, pendingPacket.getOffset(), buffer, offset, bytesToRead);
                }
                return bytesToRead;
            }

            public void setTransferHandler(SourceTransferHandler transferHandler) {
                if (this.isControlStream) {
                    if (RTPConnectorImpl.this.controlTransferHandler == null) {
                        RTPConnectorImpl.this.controlTransferHandler = transferHandler;
                    }
                } else if (RTPConnectorImpl.this.dataTransferHandler == null) {
                    RTPConnectorImpl.this.dataTransferHandler = transferHandler;
                }
            }
        }

        private class OutputDataStreamImpl
        implements OutputDataStream {
            boolean isControlStream;
            private RawPacket[] rawPacketArray = new RawPacket[1];

            public OutputDataStreamImpl(boolean isControlStream) {
                this.isControlStream = isControlStream;
            }

            public synchronized int write(byte[] buffer, int offset, int length) {
                return this.write(buffer, offset, length, true);
            }

            public synchronized int write(byte[] buffer, int offset, int length, boolean transform) {
                PushSourceStream pushSourceStream;
                SourceTransferHandler transferHandler;
                RawPacket pkt = this.rawPacketArray[0];
                if (pkt == null) {
                    pkt = new RawPacket();
                }
                this.rawPacketArray[0] = pkt;
                byte[] pktBuf = pkt.getBuffer();
                if (pktBuf == null || pktBuf.length < length) {
                    pktBuf = new byte[length];
                    pkt.setBuffer(pktBuf);
                }
                System.arraycopy(buffer, offset, pktBuf, 0, length);
                pkt.setOffset(0);
                pkt.setLength(length);
                if (transform) {
                    PacketTransformer packetTransformer;
                    PacketTransformer packetTransformer2 = packetTransformer = this.isControlStream ? RTPConnectorImpl.this.rtcpPacketTransformer : RTPConnectorImpl.this.rtpPacketTransformer;
                    if (packetTransformer != null) {
                        this.rawPacketArray = packetTransformer.reverseTransform(this.rawPacketArray);
                    }
                }
                try {
                    if (this.isControlStream) {
                        transferHandler = RTPConnectorImpl.this.controlTransferHandler;
                        pushSourceStream = RTPConnectorImpl.this.getControlInputStream();
                    } else {
                        transferHandler = RTPConnectorImpl.this.dataTransferHandler;
                        pushSourceStream = RTPConnectorImpl.this.getDataInputStream();
                    }
                }
                catch (IOException ioe) {
                    throw new UndeclaredThrowableException(ioe);
                }
                for (int i = 0; i < this.rawPacketArray.length; ++i) {
                    RawPacket packet = this.rawPacketArray[i];
                    if (i != 0) {
                        this.rawPacketArray[i] = null;
                    }
                    if (packet == null) continue;
                    if (this.isControlStream) {
                        RTPConnectorImpl.this.pendingControlPacket = packet;
                    } else {
                        RTPConnectorImpl.this.pendingDataPacket = packet;
                    }
                    if (transferHandler == null) continue;
                    transferHandler.transferData(pushSourceStream);
                }
                return length;
            }

            public void close() throws IOException {
            }
        }
    }
}

