/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.rtcp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.media.rtp.ReceiveStream;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.SSRCCache;
import net.sf.fmj.media.rtp.SSRCInfo;
import org.jitsi.impl.neomedia.MediaStreamImpl;
import org.jitsi.impl.neomedia.RTCPPacketPredicate;
import org.jitsi.impl.neomedia.RawPacket;
import org.jitsi.impl.neomedia.rtcp.RTCPHeaderUtils;
import org.jitsi.impl.neomedia.rtcp.RTCPIterator;
import org.jitsi.impl.neomedia.rtcp.RTCPREMBPacket;
import org.jitsi.impl.neomedia.rtp.StreamRTPManager;
import org.jitsi.impl.neomedia.transform.PacketTransformer;
import org.jitsi.impl.neomedia.transform.SinglePacketTransformerAdapter;
import org.jitsi.impl.neomedia.transform.TransformEngine;
import org.jitsi.service.neomedia.ByteArrayBuffer;
import org.jitsi.service.neomedia.TransmissionFailedException;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.rtp.RemoteBitrateEstimator;
import org.jitsi.util.ArrayUtils;
import org.jitsi.util.Logger;
import org.jitsi.util.concurrent.PeriodicRunnable;
import org.jitsi.util.function.RTCPGenerator;

public class RTCPReceiverFeedbackTermination
extends PeriodicRunnable
implements TransformEngine {
    private static final int MAX_RTCP_REPORT_BLOCKS = 31;
    private static final int MIN_RTCP_REPORT_BLOCKS = 0;
    private static final long REPORT_PERIOD_MS = 500L;
    private final RTCPGenerator generator = new RTCPGenerator();
    private static final RTCPReportBlock[] MIN_RTCP_REPORT_BLOCKS_ARRAY = new RTCPReportBlock[0];
    private static final Logger logger = Logger.getLogger(RTCPReceiverFeedbackTermination.class);
    private final MediaStreamImpl stream;
    private final RTCPTransformer rtcpTransformer = new RTCPTransformer();

    public RTCPReceiverFeedbackTermination(MediaStreamImpl stream) {
        super(500L);
        this.stream = stream;
    }

    @Override
    public void run() {
        super.run();
        long senderSSRC = this.getSenderSSRC();
        if (senderSSRC == -1L) {
            return;
        }
        RTCPRRPacket[] rrs = this.makeRRs(senderSSRC);
        if (ArrayUtils.isNullOrEmpty(rrs)) {
            return;
        }
        RTCPREMBPacket remb = this.makeREMB(senderSSRC);
        RTCPPacket[] rtcpPackets = new RTCPPacket[rrs.length + (remb == null ? 0 : 1)];
        System.arraycopy(rrs, 0, rtcpPackets, 0, rrs.length);
        if (remb != null) {
            rtcpPackets[rrs.length] = remb;
        }
        RTCPCompoundPacket compound = new RTCPCompoundPacket(rtcpPackets);
        RawPacket pkt = this.generator.apply(compound);
        try {
            this.stream.injectPacket(pkt, false, this);
        }
        catch (TransmissionFailedException e) {
            logger.error("transmission of an RTCP packet failed.", e);
        }
    }

    private long getSenderSSRC() {
        StreamRTPManager streamRTPManager = this.stream.getStreamRTPManager();
        if (streamRTPManager == null) {
            return -1L;
        }
        return this.stream.getStreamRTPManager().getLocalSSRC();
    }

    private RTCPRRPacket[] makeRRs(long senderSSRC) {
        RTCPReportBlock[] reportBlocks = this.makeReportBlocks();
        if (ArrayUtils.isNullOrEmpty(reportBlocks)) {
            return null;
        }
        int mod = reportBlocks.length % 31;
        int div = reportBlocks.length / 31;
        RTCPRRPacket[] rrs = new RTCPRRPacket[mod == 0 ? div : div + 1];
        if (reportBlocks.length > 31) {
            int rrIdx = 0;
            for (int off = 0; off < reportBlocks.length; off += 31) {
                int blockCount = Math.min(reportBlocks.length - off, 31);
                RTCPReportBlock[] blocks = new RTCPReportBlock[blockCount];
                System.arraycopy(reportBlocks, off, blocks, 0, blocks.length);
                rrs[rrIdx++] = new RTCPRRPacket((int)senderSSRC, blocks);
            }
        } else {
            rrs[0] = new RTCPRRPacket((int)senderSSRC, reportBlocks);
        }
        return rrs;
    }

    private RTCPReportBlock[] makeReportBlocks() {
        if (this.stream == null) {
            logger.warn("stream is null.");
            return MIN_RTCP_REPORT_BLOCKS_ARRAY;
        }
        StreamRTPManager streamRTPManager = this.stream.getStreamRTPManager();
        if (streamRTPManager == null) {
            logger.warn("streamRTPManager is null.");
            return MIN_RTCP_REPORT_BLOCKS_ARRAY;
        }
        Collection<ReceiveStream> receiveStreams = this.stream.getReceiveStreams();
        if (receiveStreams == null || receiveStreams.isEmpty()) {
            logger.debug("There are no receive streams to build report blocks for.");
            return MIN_RTCP_REPORT_BLOCKS_ARRAY;
        }
        SSRCCache cache = this.stream.getRTPTranslator().getSSRCCache();
        if (cache == null) {
            logger.info("cache is null.");
            return MIN_RTCP_REPORT_BLOCKS_ARRAY;
        }
        ArrayList<RTCPReportBlock> reportBlocks = new ArrayList<RTCPReportBlock>();
        for (ReceiveStream receiveStream : receiveStreams) {
            SSRCInfo info = (SSRCInfo)cache.cache.get((int)receiveStream.getSSRC());
            if (info == null) {
                logger.warn("We have a ReceiveStream but not an SSRCInfo for that ReceiveStream.");
                continue;
            }
            if (info.ours || !info.sender) continue;
            RTCPReportBlock reportBlock = info.makeReceiverReport(this.getLastProcessTime());
            reportBlocks.add(reportBlock);
        }
        return reportBlocks.toArray(new RTCPReportBlock[reportBlocks.size()]);
    }

    private RTCPREMBPacket makeREMB(long senderSSRC) {
        RemoteBitrateEstimator remoteBitrateEstimator = ((VideoMediaStream)((Object)this.stream)).getRemoteBitrateEstimator();
        Collection<Integer> ssrcs = remoteBitrateEstimator.getSsrcs();
        long[] dest = new long[ssrcs.size()];
        int i = 0;
        for (Integer ssrc : ssrcs) {
            dest[i++] = (long)ssrc.intValue() & 0xFFFFFFFFL;
        }
        long bitrate = remoteBitrateEstimator.getLatestEstimate();
        if (logger.isDebugEnabled()) {
            logger.debug("Estimated bitrate (bps): " + bitrate + ", dest: " + Arrays.toString(dest) + ", time (ms): " + System.currentTimeMillis());
        }
        if (bitrate == -1L) {
            return null;
        }
        return new RTCPREMBPacket(senderSSRC, 0L, bitrate, dest);
    }

    @Override
    public PacketTransformer getRTPTransformer() {
        return null;
    }

    @Override
    public PacketTransformer getRTCPTransformer() {
        return this.rtcpTransformer;
    }

    class RTCPTransformer
    extends SinglePacketTransformerAdapter {
        RTCPTransformer() {
            super(RTCPPacketPredicate.INSTANCE);
        }

        @Override
        public RawPacket transform(RawPacket pkt) {
            return this.reverseTransform(pkt);
        }

        @Override
        public RawPacket reverseTransform(RawPacket pkt) {
            RTCPIterator it = new RTCPIterator(pkt);
            while (it.hasNext()) {
                ByteArrayBuffer baf = it.next();
                int pt = RTCPHeaderUtils.getPacketType(baf);
                if (pt != 201 && !RTCPREMBPacket.isREMBPacket(baf)) continue;
                it.remove();
            }
            return pkt;
        }
    }
}

