/*
 * Decompiled with CFR 0.152.
 */
package org.dhcp4java;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.logging.Logger;
import org.dhcp4java.DHCPBadPacketException;
import org.dhcp4java.DHCPConstants;
import org.dhcp4java.DHCPOption;
import org.dhcp4java.DHCPPacket;

public final class DHCPResponseFactory {
    private static final Logger logger = Logger.getLogger(DHCPResponseFactory.class.getName().toLowerCase());

    private DHCPResponseFactory() {
        throw new UnsupportedOperationException();
    }

    public static final DHCPPacket makeDHCPOffer(DHCPPacket request, InetAddress offeredAddress, int leaseTime, InetAddress serverIdentifier, String message, DHCPOption[] options) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        if (!request.isDhcp()) {
            throw new DHCPBadPacketException("request is BOOTP");
        }
        Byte requestMessageType = request.getDHCPMessageType();
        if (requestMessageType == null) {
            throw new DHCPBadPacketException("request has no message type");
        }
        if (requestMessageType != 1) {
            throw new DHCPBadPacketException("request is not DHCPDISCOVER");
        }
        if (offeredAddress == null) {
            throw new IllegalArgumentException("offeredAddress must not be null");
        }
        if (!(offeredAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("offeredAddress must be IPv4");
        }
        DHCPPacket resp = new DHCPPacket();
        resp.setOp((byte)2);
        resp.setHtype(request.getHtype());
        resp.setHlen(request.getHlen());
        resp.setXid(request.getXid());
        resp.setFlags(request.getFlags());
        resp.setYiaddr(offeredAddress);
        resp.setGiaddrRaw(request.getGiaddrRaw());
        resp.setChaddr(request.getChaddr());
        resp.setDHCPMessageType((byte)2);
        resp.setOptionAsInt((byte)51, leaseTime);
        resp.setOptionAsInetAddress((byte)54, serverIdentifier);
        resp.setOptionAsString((byte)56, message);
        if (options != null) {
            for (DHCPOption opt : options) {
                resp.setOption(opt.applyOption(request));
            }
        }
        resp.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(request, (byte)2));
        return resp;
    }

    public static final DHCPPacket makeDHCPAck(DHCPPacket request, InetAddress offeredAddress, int leaseTime, InetAddress serverIdentifier, String message, DHCPOption[] options) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        if (!request.isDhcp()) {
            throw new DHCPBadPacketException("request is BOOTP");
        }
        Byte requestMessageType = request.getDHCPMessageType();
        if (requestMessageType == null) {
            throw new DHCPBadPacketException("request has no message type");
        }
        if (requestMessageType != 3 && requestMessageType != 8) {
            throw new DHCPBadPacketException("request is not DHCPREQUEST/DHCPINFORM");
        }
        if (offeredAddress == null) {
            throw new IllegalArgumentException("offeredAddress must not be null");
        }
        if (!(offeredAddress instanceof Inet4Address)) {
            throw new IllegalArgumentException("offeredAddress must be IPv4");
        }
        DHCPPacket resp = new DHCPPacket();
        resp.setOp((byte)2);
        resp.setHtype(request.getHtype());
        resp.setHlen(request.getHlen());
        resp.setXid(request.getXid());
        resp.setFlags(request.getFlags());
        resp.setCiaddrRaw(request.getCiaddrRaw());
        if (requestMessageType != 8) {
            resp.setYiaddr(offeredAddress);
        }
        resp.setGiaddrRaw(request.getGiaddrRaw());
        resp.setChaddr(request.getChaddr());
        resp.setDHCPMessageType((byte)5);
        if (requestMessageType == 3) {
            resp.setOptionAsInt((byte)51, leaseTime);
        }
        resp.setOptionAsInetAddress((byte)54, serverIdentifier);
        resp.setOptionAsString((byte)56, message);
        if (options != null) {
            for (DHCPOption opt : options) {
                resp.setOption(opt.applyOption(request));
            }
        }
        resp.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(request, (byte)5));
        return resp;
    }

    public static final DHCPPacket makeDHCPNak(DHCPPacket request, InetAddress serverIdentifier, String message) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        if (!request.isDhcp()) {
            throw new DHCPBadPacketException("request is BOOTP");
        }
        Byte requestMessageType = request.getDHCPMessageType();
        if (requestMessageType == null) {
            throw new DHCPBadPacketException("request has no message type");
        }
        if (requestMessageType != 3) {
            throw new DHCPBadPacketException("request is not DHCPREQUEST");
        }
        DHCPPacket resp = new DHCPPacket();
        resp.setOp((byte)2);
        resp.setHtype(request.getHtype());
        resp.setHlen(request.getHlen());
        resp.setXid(request.getXid());
        resp.setFlags(request.getFlags());
        resp.setGiaddrRaw(request.getGiaddrRaw());
        resp.setChaddr(request.getChaddr());
        resp.setDHCPMessageType((byte)6);
        resp.setOptionAsInetAddress((byte)54, serverIdentifier);
        resp.setOptionAsString((byte)56, message);
        resp.setAddrPort(DHCPResponseFactory.getDefaultSocketAddress(request, (byte)6));
        return resp;
    }

    public static InetSocketAddress getDefaultSocketAddress(DHCPPacket request, byte responseType) {
        InetSocketAddress sockAdr;
        if (request == null) {
            throw new IllegalArgumentException("request is null");
        }
        InetAddress giaddr = request.getGiaddr();
        InetAddress ciaddr = request.getCiaddr();
        switch (responseType) {
            case 2: 
            case 5: {
                if (DHCPConstants.INADDR_ANY.equals(giaddr)) {
                    if (DHCPConstants.INADDR_ANY.equals(ciaddr)) {
                        sockAdr = new InetSocketAddress(DHCPConstants.INADDR_BROADCAST, 68);
                        break;
                    }
                    sockAdr = new InetSocketAddress(ciaddr, 68);
                    break;
                }
                sockAdr = new InetSocketAddress(giaddr, 67);
                break;
            }
            case 6: {
                if (DHCPConstants.INADDR_ANY.equals(giaddr)) {
                    sockAdr = new InetSocketAddress(DHCPConstants.INADDR_BROADCAST, 68);
                    break;
                }
                sockAdr = new InetSocketAddress(giaddr, 67);
                break;
            }
            default: {
                throw new IllegalArgumentException("responseType not valid");
            }
        }
        return sockAdr;
    }
}

