/*
 * Decompiled with CFR 0.152.
 */
package mork.gui;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import mork.ExceptionHandler;
import mozilla.thunderbird.Address;
import mozilla.thunderbird.AddressBook;
import mozilla.thunderbird.AddressComparator;

public class Controller {
    private final Container parent;
    private int x = 10;
    private int y = 10;

    public Controller(Container parent) {
        this.parent = parent;
    }

    public void openFile(File morkFile) {
        System.out.println("Reading " + morkFile.getAbsolutePath());
        final ArrayList modelExceptions = new ArrayList();
        AddressBook book = new AddressBook();
        book.setExceptionHandler(new ExceptionHandler(){

            @Override
            public void handle(Throwable t) {
                modelExceptions.add(t);
            }
        });
        try {
            book.load(new FileInputStream(morkFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            String msg = "Unable to open " + morkFile.getAbsolutePath();
            JOptionPane.showMessageDialog(this.parent, msg, "Error", 0);
            return;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            String msg = e.getMessage();
            JOptionPane.showMessageDialog(this.parent, msg, "Error", 0);
            return;
        }
        ArrayList<Address> addresses = new ArrayList<Address>(book.getAddresses());
        Collections.sort(addresses, new AddressComparator());
        this.openInternalFrame("Addresses of " + morkFile.getName(), addresses);
        this.openInternalFrame("Errors while parsing " + morkFile.getName(), modelExceptions);
    }

    private void openInternalFrame(String title, Collection<?> model) {
        JList<Object> list = new JList<Object>(model.toArray());
        list.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Throwable) {
                    Throwable throwable = (Throwable)value;
                    this.setText("ERROR: " + throwable.getMessage());
                } else if (value instanceof Address) {
                    Address address = (Address)value;
                    String msg = String.format("%s, %s (%s) <%s>", address.getLastName(), address.getFirstName(), address.getDisplayName(), address.getPrimaryEmail());
                    this.setText(msg);
                }
                return this;
            }
        });
        list.revalidate();
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(list);
        JInternalFrame frame = new JInternalFrame(title, true, true, true, true);
        frame.add(pane);
        frame.setVisible(true);
        frame.setSize(320, 240);
        frame.setLocation(this.x += 30, this.y += 30);
        this.parent.add(frame);
    }
}

