/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.contactlist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import net.java.sip.communicator.impl.contactlist.MetaContactGroupImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.event.MetaContactModifiedEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactGroup;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetContactCapabilities;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.AvatarCacheUtils;
import net.java.sip.communicator.util.DataObject;
import net.java.sip.communicator.util.Logger;

public class MetaContactImpl
extends DataObject
implements MetaContact {
    private static final Logger logger = Logger.getLogger(MetaContactImpl.class);
    private final List<Contact> protoContacts = new Vector<Contact>();
    private final Map<String, List<Contact>> capabilities = new HashMap<String, List<Contact>>();
    private int contactsOnline = 0;
    private final String uid;
    private String displayName = "";
    private Contact defaultContact = null;
    private byte[] cachedAvatar = null;
    private boolean avatarFileCacheAlreadyQueried = false;
    private MetaContactGroupImpl parentGroup = null;
    private Map<String, List<String>> details;
    private boolean isDisplayNameUserDefined = false;

    MetaContactImpl() {
        this.uid = String.valueOf(System.currentTimeMillis()) + String.valueOf(((Object)((Object)this)).hashCode());
        this.details = null;
    }

    MetaContactImpl(String metaUID, Map<String, List<String>> details) {
        this.uid = metaUID;
        this.details = details;
    }

    public int getContactCount() {
        return this.protoContacts.size();
    }

    public Iterator<Contact> getContactsForProvider(ProtocolProviderService provider) {
        LinkedList<Contact> providerContacts = new LinkedList<Contact>();
        for (Contact contact : this.protoContacts) {
            if (contact.getProtocolProvider() != provider) continue;
            providerContacts.add(contact);
        }
        return providerContacts.iterator();
    }

    public List<Contact> getContactsForOperationSet(Class<? extends OperationSet> opSetClass) {
        LinkedList<Contact> opSetContacts = new LinkedList<Contact>();
        for (Contact contact : this.protoContacts) {
            ProtocolProviderService contactProvider = contact.getProtocolProvider();
            OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)contactProvider.getOperationSet(OperationSetContactCapabilities.class);
            if (capOpSet != null) {
                List<Contact> capContacts = this.capabilities.get(opSetClass.getName());
                if (capContacts == null || !capContacts.contains(contact)) continue;
                opSetContacts.add(contact);
                continue;
            }
            if (contactProvider.getOperationSet(opSetClass) == null) continue;
            opSetContacts.add(contact);
        }
        return opSetContacts;
    }

    public Iterator<Contact> getContactsForContactGroup(ContactGroup parentProtoGroup) {
        LinkedList<Contact> providerContacts = new LinkedList<Contact>();
        for (Contact contact : this.protoContacts) {
            if (contact.getParentContactGroup() != parentProtoGroup) continue;
            providerContacts.add(contact);
        }
        return providerContacts.iterator();
    }

    public Contact getContact(String contactAddress, ProtocolProviderService ownerProvider) {
        for (Contact contact : this.protoContacts) {
            if (contact.getProtocolProvider() != ownerProvider || !contact.getAddress().equals(contactAddress) && !contact.equals(contactAddress)) continue;
            return contact;
        }
        return null;
    }

    public Contact getContact(String contactAddress, String accountID) {
        for (Contact contact : this.protoContacts) {
            if (!contact.getProtocolProvider().getAccountID().getAccountUniqueID().equals(accountID) || !contact.getAddress().equals(contactAddress)) continue;
            return contact;
        }
        return null;
    }

    public boolean containsContact(Contact protocolContact) {
        return this.protoContacts.contains(protocolContact);
    }

    public Iterator<Contact> getContacts() {
        return new LinkedList<Contact>(this.protoContacts).iterator();
    }

    public Contact getDefaultContact() {
        if (this.defaultContact == null) {
            PresenceStatus currentStatus = null;
            for (Contact protoContact : this.protoContacts) {
                PresenceStatus contactStatus = protoContact.getPresenceStatus();
                if (currentStatus != null) {
                    if (currentStatus.getStatus() >= contactStatus.getStatus()) continue;
                    currentStatus = contactStatus;
                    this.defaultContact = protoContact;
                    continue;
                }
                currentStatus = contactStatus;
                this.defaultContact = protoContact;
            }
        }
        return this.defaultContact;
    }

    public Contact getDefaultContact(Class<? extends OperationSet> operationSet) {
        Contact defaultOpSetContact = null;
        Contact defaultContact = this.getDefaultContact();
        if (defaultContact != null) {
            ProtocolProviderService contactProvider = defaultContact.getProtocolProvider();
            OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)contactProvider.getOperationSet(OperationSetContactCapabilities.class);
            if (capOpSet != null) {
                List<Contact> capContacts = this.capabilities.get(operationSet.getName());
                if (capContacts != null && capContacts.contains(defaultContact)) {
                    defaultOpSetContact = defaultContact;
                }
            } else if (contactProvider.getOperationSet(operationSet) != null) {
                defaultOpSetContact = defaultContact;
            }
        }
        if (defaultOpSetContact == null) {
            PresenceStatus currentStatus = null;
            for (Contact protoContact : this.protoContacts) {
                List<Contact> capContacts;
                ProtocolProviderService contactProvider = protoContact.getProtocolProvider();
                OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)contactProvider.getOperationSet(OperationSetContactCapabilities.class);
                if (capOpSet != null ? (capContacts = this.capabilities.get(operationSet.getName())) == null || !capContacts.contains(protoContact) : contactProvider.getOperationSet(operationSet) == null) continue;
                PresenceStatus contactStatus = protoContact.getPresenceStatus();
                if (currentStatus != null) {
                    if (currentStatus.getStatus() >= contactStatus.getStatus()) continue;
                    currentStatus = contactStatus;
                    defaultOpSetContact = protoContact;
                    continue;
                }
                currentStatus = contactStatus;
                defaultOpSetContact = protoContact;
            }
        }
        return defaultOpSetContact;
    }

    public String getMetaUID() {
        return this.uid;
    }

    public int compareTo(MetaContact o) {
        MetaContactImpl target = (MetaContactImpl)o;
        int isOnline = this.contactsOnline > 0 ? 1 : 0;
        int targetIsOnline = target.contactsOnline > 0 ? 1 : 0;
        return (10 - isOnline - (10 - targetIsOnline)) * 100000000 + this.getDisplayName().compareToIgnoreCase(target.getDisplayName()) * 10000 + this.getMetaUID().compareTo(target.getMetaUID());
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("MetaContact[ DisplayName=").append(this.getDisplayName()).append("]");
        return buff.toString();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    boolean isDisplayNameUserDefined() {
        return this.isDisplayNameUserDefined;
    }

    void setDisplayNameUserDefined(boolean value) {
        this.isDisplayNameUserDefined = value;
    }

    private byte[] queryProtoContactAvatar(Contact contact) {
        try {
            byte[] contactImage = contact.getImage();
            if (contactImage != null && contactImage.length > 0) {
                return contactImage;
            }
        }
        catch (Exception ex) {
            logger.error((Object)("Failed to get the photo of contact " + contact), (Throwable)ex);
        }
        return null;
    }

    public byte[] getAvatar(boolean isLazy) {
        byte[] result = null;
        if (!isLazy) {
            Iterator<Contact> protoContacts = this.getContacts();
            while (protoContacts.hasNext()) {
                Contact contact = protoContacts.next();
                result = this.queryProtoContactAvatar(contact);
                if (result == null || result.length <= 0) continue;
                this.cacheAvatar(contact, result);
                return result;
            }
        }
        if (this.cachedAvatar != null && this.cachedAvatar.length > 0) {
            return this.cachedAvatar;
        }
        if (this.avatarFileCacheAlreadyQueried) {
            return null;
        }
        this.avatarFileCacheAlreadyQueried = true;
        Iterator<Contact> iter = this.getContacts();
        while (iter.hasNext()) {
            Contact protoContact = iter.next();
            this.cachedAvatar = AvatarCacheUtils.getCachedAvatar((Contact)protoContact);
            if (this.cachedAvatar == null || this.cachedAvatar.length <= 0) continue;
            return this.cachedAvatar;
        }
        return null;
    }

    public byte[] getAvatar() {
        return this.getAvatar(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDisplayName(String displayName) {
        Object object = this.getParentGroupModLock();
        synchronized (object) {
            if (this.parentGroup != null) {
                this.parentGroup.lightRemoveMetaContact(this);
            }
            String string = this.displayName = displayName == null ? "" : displayName;
            if (this.parentGroup != null) {
                this.parentGroup.lightAddMetaContact(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProtoContact(Contact contact) {
        Object object = this.getParentGroupModLock();
        synchronized (object) {
            ProtocolProviderService contactProvider;
            OperationSetContactCapabilities capOpSet;
            if (this.parentGroup != null) {
                this.parentGroup.lightRemoveMetaContact(this);
            }
            this.contactsOnline += contact.getPresenceStatus().isOnline() ? 1 : 0;
            this.protoContacts.add(contact);
            this.defaultContact = null;
            if (this.protoContacts.size() == 1 && (this.displayName == null || this.displayName.trim().length() == 0)) {
                this.displayName = contact.getDisplayName();
            }
            if (this.parentGroup != null) {
                this.parentGroup.lightAddMetaContact(this);
            }
            if ((capOpSet = (OperationSetContactCapabilities)(contactProvider = contact.getProtocolProvider()).getOperationSet(OperationSetContactCapabilities.class)) != null) {
                this.addCapabilities(contact, capOpSet.getSupportedOperationSets(contact));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reevalContact() {
        Object object = this.getParentGroupModLock();
        synchronized (object) {
            if (this.parentGroup != null) {
                this.parentGroup.lightRemoveMetaContact(this);
            }
            this.contactsOnline = 0;
            int maxContactStatus = 0;
            for (Contact contact : this.protoContacts) {
                int contactStatus = contact.getPresenceStatus().getStatus();
                if (maxContactStatus < contactStatus) {
                    maxContactStatus = contactStatus;
                    this.defaultContact = contact;
                }
                if (!contact.getPresenceStatus().isOnline()) continue;
                ++this.contactsOnline;
            }
            if (this.parentGroup != null) {
                return this.parentGroup.lightAddMetaContact(this);
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProtoContact(Contact contact) {
        Object object = this.getParentGroupModLock();
        synchronized (object) {
            ProtocolProviderService contactProvider;
            OperationSetContactCapabilities capOpSet;
            if (this.parentGroup != null) {
                this.parentGroup.lightRemoveMetaContact(this);
            }
            this.contactsOnline -= contact.getPresenceStatus().isOnline() ? 1 : 0;
            this.protoContacts.remove(contact);
            if (this.defaultContact == contact) {
                this.defaultContact = null;
            }
            if (this.protoContacts.size() > 0 && this.displayName.equals(contact.getDisplayName())) {
                this.displayName = this.getDefaultContact().getDisplayName();
            }
            if (this.parentGroup != null) {
                this.parentGroup.lightAddMetaContact(this);
            }
            if ((capOpSet = (OperationSetContactCapabilities)(contactProvider = contact.getProtocolProvider()).getOperationSet(OperationSetContactCapabilities.class)) != null) {
                this.removeCapabilities(contact, capOpSet.getSupportedOperationSets(contact));
            }
        }
    }

    boolean removeContactsForProvider(ProtocolProviderService provider) {
        boolean modified = false;
        Iterator<Contact> contactsIter = this.protoContacts.iterator();
        while (contactsIter.hasNext()) {
            Contact contact = contactsIter.next();
            if (contact.getProtocolProvider() != provider) continue;
            contactsIter.remove();
            modified = true;
        }
        if (modified && !this.protoContacts.contains(this.defaultContact)) {
            this.defaultContact = null;
        }
        return modified;
    }

    boolean removeContactsForGroup(ContactGroup protoGroup) {
        boolean modified = false;
        Iterator<Contact> contactsIter = this.protoContacts.iterator();
        while (contactsIter.hasNext()) {
            Contact contact = contactsIter.next();
            if (contact.getParentContactGroup() != protoGroup) continue;
            contactsIter.remove();
            modified = true;
        }
        if (modified && !this.protoContacts.contains(this.defaultContact)) {
            this.defaultContact = null;
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setParentGroup(MetaContactGroupImpl parentGroup) {
        if (parentGroup == null) {
            throw new NullPointerException("Do not call this method with a null argument even if a group is removing this contact from itself as this could lead to race conditions (imagine another group setting itself as the new parent and you  removing it). Use unsetParentGroup instead.");
        }
        Object object = this.getParentGroupModLock();
        synchronized (object) {
            this.parentGroup = parentGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsetParentGroup(MetaContactGroupImpl parentGrp) {
        Object object = this.getParentGroupModLock();
        synchronized (object) {
            if (this.parentGroup == parentGrp) {
                this.parentGroup = null;
            }
        }
    }

    MetaContactGroupImpl getParentGroup() {
        return this.parentGroup;
    }

    public MetaContactGroup getParentMetaContactGroup() {
        return this.getParentGroup();
    }

    public void addDetail(String name, String value) {
        List<String> values;
        if (this.details == null) {
            this.details = new Hashtable<String, List<String>>();
        }
        if ((values = this.details.get(name)) == null) {
            values = new ArrayList<String>();
            this.details.put(name, values);
        }
        values.add(value);
        this.fireMetaContactModified(name, null, value);
    }

    public void removeDetail(String name, String value) {
        if (this.details == null) {
            return;
        }
        List<String> values = this.details.get(name);
        if (values == null) {
            return;
        }
        values.remove(value);
        this.fireMetaContactModified(name, value, null);
    }

    public void removeDetails(String name) {
        if (this.details == null) {
            return;
        }
        List<String> removed = this.details.remove(name);
        this.fireMetaContactModified(name, removed, null);
    }

    public void changeDetail(String name, String oldValue, String newValue) {
        if (this.details == null) {
            return;
        }
        List<String> values = this.details.get(name);
        if (values == null) {
            return;
        }
        int changedIx = values.indexOf(oldValue);
        if (changedIx == -1) {
            return;
        }
        values.set(changedIx, newValue);
        this.fireMetaContactModified(name, oldValue, newValue);
    }

    private void fireMetaContactModified(String modificationName, Object oldValue, Object newValue) {
        MetaContactGroupImpl parentGroup = this.getParentGroup();
        if (parentGroup != null) {
            parentGroup.getMclServiceImpl().fireMetaContactEvent((MetaContactPropertyChangeEvent)new MetaContactModifiedEvent((MetaContact)this, modificationName, oldValue, newValue));
        }
    }

    public List<String> getDetails(String name) {
        List<String> values = this.details == null ? null : this.details.get(name);
        values = values == null ? new ArrayList<String>() : new ArrayList<String>(values);
        return values;
    }

    public void cacheAvatar(Contact protoContact, byte[] avatarBytes) {
        this.cachedAvatar = avatarBytes;
        this.avatarFileCacheAlreadyQueried = true;
        AvatarCacheUtils.cacheAvatar((Contact)protoContact, (byte[])avatarBytes);
    }

    public void updateCapabilities(Contact contact, Map<String, ? extends OperationSet> opSets) {
        OperationSetContactCapabilities capOpSet = (OperationSetContactCapabilities)contact.getProtocolProvider().getOperationSet(OperationSetContactCapabilities.class);
        if (capOpSet == null) {
            return;
        }
        this.removeCapabilities(contact, opSets);
        this.addCapabilities(contact, opSets);
    }

    private void removeCapabilities(Contact contact, Map<String, ? extends OperationSet> opSets) {
        Iterator<Map.Entry<String, List<Contact>>> caps = this.capabilities.entrySet().iterator();
        Set<String> contactNewCaps = opSets.keySet();
        while (caps.hasNext()) {
            Map.Entry<String, List<Contact>> entry = caps.next();
            String opSetName = entry.getKey();
            List<Contact> contactsForCap = entry.getValue();
            if (!contactsForCap.contains(contact) || contactNewCaps.contains(opSetName)) continue;
            contactsForCap.remove(contact);
            if (contactsForCap.size() != 0) continue;
            caps.remove();
        }
    }

    private void addCapabilities(Contact contact, Map<String, ? extends OperationSet> opSets) {
        for (String newCap : opSets.keySet()) {
            List<Object> capContacts = null;
            if (!this.capabilities.containsKey(newCap)) {
                capContacts = new LinkedList<Contact>();
                capContacts.add(contact);
                this.capabilities.put(newCap, capContacts);
                continue;
            }
            capContacts = this.capabilities.get(newCap);
            if (capContacts.contains(contact)) continue;
            capContacts.add(contact);
        }
    }

    private Object getParentGroupModLock() {
        return this.uid;
    }
}

