/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.api.client.auth.oauth2.Credential;
import com.google.gdata.client.AuthTokenFactory;
import com.google.gdata.client.ClientLoginAccountType;
import com.google.gdata.client.GoogleService;
import com.google.gdata.client.authn.oauth.GoogleOAuthHelper;
import com.google.gdata.client.authn.oauth.OAuthException;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.authn.oauth.TwoLeggedOAuthHelper;
import com.google.gdata.client.http.AuthSubUtil;
import com.google.gdata.client.http.HttpAuthToken;
import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.common.base.CharEscapers;
import com.google.gdata.util.common.base.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;

public class GoogleAuthTokenFactory
implements AuthTokenFactory {
    private String applicationName;
    private String serviceName;
    private String username;
    private String password;
    private String domainName;
    private String loginProtocol;
    private HttpAuthToken authToken;
    private AuthTokenFactory.TokenListener tokenListener;
    public static final String GOOGLE_ACCOUNTS_PATH = "/accounts";
    public static final String GOOGLE_LOGIN_PATH = "/accounts/ClientLogin";

    public GoogleAuthTokenFactory(String serviceName, String applicationName, AuthTokenFactory.TokenListener tokenListener) {
        this(serviceName, applicationName, "https", "www.google.com", tokenListener);
    }

    public GoogleAuthTokenFactory(String serviceName, String applicationName, String protocol, String domainName, AuthTokenFactory.TokenListener tokenListener) {
        this.serviceName = serviceName;
        this.applicationName = applicationName;
        this.domainName = domainName;
        this.loginProtocol = protocol;
        this.tokenListener = tokenListener;
    }

    public void setUserCredentials(String username, String password) throws AuthenticationException {
        this.setUserCredentials(username, password, ClientLoginAccountType.HOSTED_OR_GOOGLE);
    }

    public void setUserCredentials(String username, String password, ClientLoginAccountType accountType) throws AuthenticationException {
        this.setUserCredentials(username, password, null, null, accountType);
    }

    public void setUserCredentials(String username, String password, String captchaToken, String captchaAnswer) throws AuthenticationException {
        this.setUserCredentials(username, password, captchaToken, captchaAnswer, ClientLoginAccountType.HOSTED_OR_GOOGLE);
    }

    public void setUserCredentials(String username, String password, String captchaToken, String captchaAnswer, ClientLoginAccountType accountType) throws AuthenticationException {
        this.username = username;
        this.password = password;
        String token = this.getAuthToken(username, password, captchaToken, captchaAnswer, this.serviceName, this.applicationName, accountType);
        this.setUserToken(token);
    }

    public void setUserToken(String token) {
        this.setAuthToken(new UserToken(token));
    }

    public void setAuthSubToken(String token) {
        this.setAuthSubToken(token, null);
    }

    public void setAuthSubToken(String token, PrivateKey key) {
        this.setAuthToken(new AuthSubToken(token, key));
    }

    public void setOAuthCredentials(OAuthParameters parameters, OAuthSigner signer) throws OAuthException {
        parameters.assertOAuthConsumerKeyExists();
        this.setAuthToken(new OAuthToken(parameters, signer));
    }

    public void setOAuth2Credentials(Credential credential) {
        this.setAuthToken(new OAuth2Token(credential));
    }

    public void setAuthToken(HttpAuthToken authToken) {
        this.authToken = authToken;
        if (this.tokenListener != null) {
            this.tokenListener.tokenChanged(authToken);
        }
    }

    @Override
    public HttpAuthToken getAuthToken() {
        return this.authToken;
    }

    public String getAuthToken(String username, String password, String captchaToken, String captchaAnswer, String serviceName, String applicationName) throws AuthenticationException {
        return this.getAuthToken(username, password, captchaToken, captchaAnswer, serviceName, applicationName, ClientLoginAccountType.HOSTED_OR_GOOGLE);
    }

    public String getAuthToken(String username, String password, String captchaToken, String captchaAnswer, String serviceName, String applicationName, ClientLoginAccountType accountType) throws AuthenticationException {
        String postOutput;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Email", username);
        params.put("Passwd", password);
        params.put("source", applicationName);
        params.put("service", serviceName);
        params.put("accountType", accountType.getValue());
        if (captchaToken != null) {
            params.put("logintoken", captchaToken);
        }
        if (captchaAnswer != null) {
            params.put("logincaptcha", captchaAnswer);
        }
        try {
            URL url = new URL(this.loginProtocol + "://" + this.domainName + GOOGLE_LOGIN_PATH);
            postOutput = GoogleAuthTokenFactory.makePostRequest(url, params);
        }
        catch (IOException e) {
            AuthenticationException ae = new AuthenticationException("Error connecting with login URI");
            ae.initCause(e);
            throw ae;
        }
        HashMap<String, String> tokenPairs = StringUtil.string2Map(postOutput.trim(), "\n", "=", true);
        String token = (String)tokenPairs.get("Auth");
        if (token == null) {
            throw this.getAuthException(tokenPairs);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makePostRequest(URL url, Map<String, String> parameters) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setDoInput(true);
        urlConnection.setDoOutput(true);
        urlConnection.setUseCaches(false);
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        urlConnection.setRequestProperty("User-Agent", parameters.get("service") + " GData-Java/" + GoogleAuthTokenFactory.class.getPackage().getImplementationVersion());
        StringBuilder content = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            if (!first) {
                content.append("&");
            }
            content.append(CharEscapers.uriEscaper().escape(parameter.getKey())).append("=");
            content.append(CharEscapers.uriEscaper().escape(parameter.getValue()));
            first = false;
        }
        try (OutputStream outputStream = null;){
            outputStream = urlConnection.getOutputStream();
            outputStream.write(content.toString().getBytes("utf-8"));
            outputStream.flush();
        }
        StringBuilder outputBuilder = new StringBuilder();
        try (InputStream inputStream = null;){
            int responseCode = urlConnection.getResponseCode();
            inputStream = responseCode == 200 ? urlConnection.getInputStream() : urlConnection.getErrorStream();
            if (inputStream != null) {
                String string;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                while (null != (string = reader.readLine())) {
                    outputBuilder.append(string).append('\n');
                }
            }
        }
        return outputBuilder.toString();
    }

    private AuthenticationException getAuthException(Map<String, String> pairs) {
        String errorName = pairs.get("Error");
        if ("BadAuthentication".equals(errorName)) {
            return new GoogleService.InvalidCredentialsException("Invalid credentials");
        }
        if ("AccountDeleted".equals(errorName)) {
            return new GoogleService.AccountDeletedException("Account deleted");
        }
        if ("AccountDisabled".equals(errorName)) {
            return new GoogleService.AccountDisabledException("Account disabled");
        }
        if ("NotVerified".equals(errorName)) {
            return new GoogleService.NotVerifiedException("Not verified");
        }
        if ("TermsNotAgreed".equals(errorName)) {
            return new GoogleService.TermsNotAgreedException("Terms not agreed");
        }
        if ("ServiceUnavailable".equals(errorName)) {
            return new GoogleService.ServiceUnavailableException("Service unavailable");
        }
        if ("CaptchaRequired".equals(errorName)) {
            String captchaPath = pairs.get("CaptchaUrl");
            StringBuilder captchaUrl = new StringBuilder();
            captchaUrl.append(this.loginProtocol).append("://").append(this.domainName).append(GOOGLE_ACCOUNTS_PATH).append('/').append(captchaPath);
            return new GoogleService.CaptchaRequiredException("Captcha required", captchaUrl.toString(), pairs.get("CaptchaToken"));
        }
        return new AuthenticationException("Error authenticating (check service name)");
    }

    @Override
    public void handleSessionExpiredException(GoogleService.SessionExpiredException sessionExpired) throws GoogleService.SessionExpiredException, AuthenticationException {
        if (this.username != null && this.password != null) {
            String token = this.getAuthToken(this.username, this.password, null, null, this.serviceName, this.applicationName);
            this.setUserToken(token);
        } else if (!(this.authToken instanceof OAuth2Token) || !((OAuth2Token)this.authToken).refreshToken()) {
            throw sessionExpired;
        }
    }

    public static class OAuth2Token
    implements HttpAuthToken {
        static final String HEADER_PREFIX = "Bearer ";
        final Credential credential;

        public OAuth2Token(Credential credential) {
            this.credential = credential;
        }

        @Override
        public String getAuthorizationHeader(URL requestUrl, String requestMethod) {
            return HEADER_PREFIX + this.credential.getAccessToken();
        }

        public boolean refreshToken() throws AuthenticationException {
            try {
                return this.credential.refreshToken();
            }
            catch (IOException e) {
                AuthenticationException ae = new AuthenticationException("Failed to refresh access token: " + e.getMessage());
                ae.initCause(e);
                throw ae;
            }
        }
    }

    public static class OAuthToken
    implements HttpAuthToken {
        OAuthParameters parameters;
        final OAuthSigner signer;

        public OAuthToken(OAuthParameters parameters, OAuthSigner signer) {
            this.parameters = parameters;
            this.signer = signer;
        }

        @Override
        public String getAuthorizationHeader(URL requestUrl, String requestMethod) {
            try {
                if (this.parameters.getOAuthType() == OAuthParameters.OAuthType.TWO_LEGGED_OAUTH) {
                    TwoLeggedOAuthHelper twoLeggedOAuthHelper = new TwoLeggedOAuthHelper(this.signer, this.parameters);
                    return twoLeggedOAuthHelper.getAuthorizationHeader(requestUrl.toString(), requestMethod);
                }
                GoogleOAuthHelper oauthHelper = new GoogleOAuthHelper(this.signer);
                return oauthHelper.getAuthorizationHeader(requestUrl.toString(), requestMethod, this.parameters);
            }
            catch (OAuthException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AuthSubToken
    implements HttpAuthToken {
        private String token;
        private PrivateKey key;

        public AuthSubToken(String token, PrivateKey key) {
            this.token = token;
            this.key = key;
        }

        public String getValue() {
            return this.token;
        }

        @Override
        public String getAuthorizationHeader(URL requestUrl, String requestMethod) {
            try {
                return AuthSubUtil.formAuthorizationHeader(this.token, this.key, requestUrl, requestMethod);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public static class UserToken
    implements HttpAuthToken {
        private String token;

        public UserToken(String token) {
            this.token = token;
        }

        public String getValue() {
            return this.token;
        }

        @Override
        public String getAuthorizationHeader(URL requestUrl, String requestMethod) {
            return "GoogleLogin auth=" + this.token;
        }
    }
}

