/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsServiceImpl;
import net.java.sip.communicator.impl.googlecontacts.GoogleContactsSourceService;
import net.java.sip.communicator.service.browserlauncher.BrowserLauncherService;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.resources.ResourceManagementServiceUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class GoogleContactsActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(GoogleContactsActivator.class);
    private ServiceRegistration<?> serviceRegistration = null;
    private static BundleContext bundleContext;
    private static ConfigurationService configService;
    private static CredentialsStorageService credentialsService;
    private static ResourceManagementService resourceService;
    private static GoogleContactsServiceImpl googleContactsService;
    private static BrowserLauncherService browserLauncherService;
    private static Map<GoogleContactsSourceService, ServiceRegistration<?>> cssList;
    private static PhoneNumberI18nService phoneNumberI18nService;

    public static ConfigurationService getConfigService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public static GoogleContactsServiceImpl getGoogleContactsService() {
        return googleContactsService;
    }

    public static CredentialsStorageService getCredentialsService() {
        if (credentialsService == null) {
            credentialsService = (CredentialsStorageService)ServiceUtils.getService((BundleContext)bundleContext, CredentialsStorageService.class);
        }
        return credentialsService;
    }

    public static ResourceManagementService getResourceManagementService() {
        if (resourceService == null) {
            resourceService = ResourceManagementServiceUtils.getService((BundleContext)bundleContext);
        }
        return resourceService;
    }

    public static BrowserLauncherService getBrowserLauncherService() {
        if (browserLauncherService == null) {
            browserLauncherService = (BrowserLauncherService)ServiceUtils.getService((BundleContext)bundleContext, BrowserLauncherService.class);
        }
        return browserLauncherService;
    }

    public void start(BundleContext bundleContext) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Started.");
        }
        GoogleContactsActivator.bundleContext = bundleContext;
        googleContactsService = new GoogleContactsServiceImpl();
        this.serviceRegistration = bundleContext.registerService(GoogleContactsService.class.getName(), (Object)googleContactsService, null);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("FORM_TYPE", "CONTACT_SOURCE_TYPE");
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm("net.java.sip.communicator.impl.googlecontacts.configform.GoogleContactsConfigForm", this.getClass().getClassLoader(), "impl.googlecontacts.PLUGIN_ICON", "impl.googlecontacts.CONFIG_FORM_TITLE", 2000, false), properties);
        bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent serviceEvent) {
                GoogleContactsActivator.this.serviceChanged(serviceEvent);
            }
        });
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Google Contacts Service ... [REGISTERED]");
        }
    }

    private void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = bundleContext.getService(serviceRef);
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        if (((ProtocolProviderService)service).getProtocolName() != "Jabber") {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.handleProviderAdded((ProtocolProviderService)service);
                break;
            }
            case 4: {
                this.handleProviderRemoved((ProtocolProviderService)service);
            }
        }
    }

    private void handleProviderAdded(final ProtocolProviderService provider) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                String className = provider.getClass().getName();
                className = className.substring(0, className.lastIndexOf(46));
                String acc = ProtocolProviderFactory.findAccountPrefix((BundleContext)bundleContext, (AccountID)provider.getAccountID(), (String)className);
                if (configService.getBoolean(acc + ".GOOGLE_CONTACTS_ENABLED", true)) {
                    GoogleContactsActivator.enableContactSource(provider.getAccountID().getAccountAddress(), provider.getProtocolDisplayName().equals("Google Talk"));
                }
            }
        }).start();
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        GoogleContactsActivator.disableContactSource(provider.getAccountID().getAccountAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bundleContext) throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        for (Map.Entry<GoogleContactsSourceService, ServiceRegistration<?>> entry : cssList.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                entry.getValue().unregister();
            }
            finally {
                entry.getKey().stop();
            }
        }
        cssList.clear();
        GoogleContactsActivator.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleContactsSourceService enableContactSource(String login, boolean googleTalk) {
        GoogleContactsSourceService css = new GoogleContactsSourceService(login);
        ServiceRegistration cssServiceRegistration = null;
        css.setGoogleTalk(googleTalk);
        try {
            cssServiceRegistration = bundleContext.registerService(ContactSourceService.class.getName(), (Object)css, null);
        }
        finally {
            if (cssServiceRegistration == null) {
                css.stop();
                css = null;
            } else {
                cssList.put(css, cssServiceRegistration);
            }
        }
        return css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GoogleContactsSourceService enableContactSource(GoogleContactsConnection cnx, boolean googleTalk) {
        GoogleContactsSourceService css = new GoogleContactsSourceService(cnx);
        ServiceRegistration cssServiceRegistration = null;
        css.setGoogleTalk(googleTalk);
        try {
            cssServiceRegistration = bundleContext.registerService(ContactSourceService.class.getName(), (Object)css, null);
        }
        finally {
            if (cssServiceRegistration == null) {
                css.stop();
                css = null;
            } else {
                cssList.put(css, cssServiceRegistration);
            }
        }
        return css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableContactSource(String login) {
        GoogleContactsSourceService found = null;
        for (Map.Entry<GoogleContactsSourceService, ServiceRegistration<?>> entry : cssList.entrySet()) {
            String cssName = entry.getKey().getLogin();
            if (!cssName.equals(login)) continue;
            try {
                entry.getValue().unregister();
            }
            finally {
                entry.getKey().stop();
            }
            found = entry.getKey();
            break;
        }
        if (found != null) {
            cssList.remove(found);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disableContactSource(GoogleContactsConnection cnx) {
        GoogleContactsSourceService found = null;
        if (cnx == null) {
            return;
        }
        for (Map.Entry<GoogleContactsSourceService, ServiceRegistration<?>> entry : cssList.entrySet()) {
            String name;
            String cssName = entry.getKey().getLogin();
            if (!cssName.equals(name = cnx.getLogin())) continue;
            try {
                entry.getValue().unregister();
            }
            finally {
                entry.getKey().stop();
            }
            found = entry.getKey();
            break;
        }
        if (found != null) {
            cssList.remove(found);
        }
    }

    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = (PhoneNumberI18nService)ServiceUtils.getService((BundleContext)bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }

    static {
        cssList = new HashMap();
    }
}

