/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.googlecontacts;

import com.google.gdata.client.contacts.ContactQuery;
import com.google.gdata.client.contacts.ContactsService;
import com.google.gdata.data.contacts.ContactFeed;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import net.java.sip.communicator.impl.googlecontacts.OAuth2TokenStore;
import net.java.sip.communicator.service.googlecontacts.GoogleContactsConnection;
import net.java.sip.communicator.util.Logger;

public class GoogleContactsConnectionImpl
implements GoogleContactsConnection {
    private static final Logger logger = Logger.getLogger(GoogleContactsConnectionImpl.class);
    private final OAuth2TokenStore store = new OAuth2TokenStore();
    private String login = null;
    private boolean enabled = false;
    private String prefix = null;
    private final ContactsService googleService = new ContactsService("GoogleContacts service for Jitsi");

    public GoogleContactsConnectionImpl(String login) {
        this.login = login;
        this.googleService.useSsl();
    }

    public ContactsService getGoogleService() {
        return this.googleService;
    }

    @Override
    public String getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(String login) {
        this.login = login;
    }

    @Override
    public synchronized GoogleContactsConnection.ConnectionStatus connect() {
        try {
            this.googleService.setOAuth2Credentials(this.store.get(this.login));
            return GoogleContactsConnection.ConnectionStatus.SUCCESS;
        }
        catch (OAuth2TokenStore.FailedAcquireCredentialException e) {
            logger.error((Object)"Failed to acquire credentials.", (Throwable)e);
            return GoogleContactsConnection.ConnectionStatus.ERROR_UNKNOWN;
        }
    }

    public synchronized ContactFeed query(ContactQuery query) throws IOException, ServiceException, FailedContactQueryException, OAuth2TokenStore.FailedTokenRefreshException {
        try {
            return this.googleService.query(query, ContactFeed.class);
        }
        catch (NullPointerException e) {
            logger.info((Object)"Executing query failed with NPE. Refreshing access token and trying again.");
            this.store.refresh();
        }
        catch (Exception e) {
            logger.warn((Object)"Query failed with unexpected exception. Going to try refreshing token anyways ...", (Throwable)e);
            this.store.refresh();
        }
        try {
            return this.googleService.query(query, ContactFeed.class);
        }
        catch (Exception e) {
            throw new FailedContactQueryException(e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public static class FailedContactQueryException
    extends Exception {
        private static final long serialVersionUID = -5451421392081973669L;

        private FailedContactQueryException(Throwable cause) {
            super("Failed to query Google Contacts API.", cause);
        }
    }
}

