/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.java.sip.communicator.impl.ldap.LdapDirectoryImpl;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapPersonFound;
import net.java.sip.communicator.service.ldap.LdapQuery;

public class LdapPersonFoundImpl
implements LdapPersonFound {
    private LdapDirectoryImpl server;
    private final LdapQuery query;
    private final String dn;
    private String displayName = null;
    private String firstName = null;
    private String surname = null;
    private String organization = null;
    private String department = null;
    private byte[] photo = null;
    private final Set<String> mails = new HashSet<String>();
    private final Set<String> workPhoneNumbers = new HashSet<String>();
    private final Set<String> mobilePhoneNumbers = new HashSet<String>();
    private final Set<String> homePhoneNumbers = new HashSet<String>();

    public LdapPersonFoundImpl(LdapDirectoryImpl server, String dn, LdapQuery query) {
        if (server == null || query == null || dn == null) {
            throw new NullPointerException();
        }
        this.server = server;
        this.query = query;
        this.dn = dn;
    }

    @Override
    public LdapQuery getQuery() {
        return this.query;
    }

    @Override
    public LdapDirectory getServer() {
        return this.server;
    }

    @Override
    public void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void fetchPhoto() {
        this.photo = this.server.fetchPhotoForPerson(this.dn);
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public void setOrganization(String organization) {
        this.organization = organization;
    }

    @Override
    public String getOrganization() {
        return this.organization;
    }

    @Override
    public void setDepartment(String department) {
        this.department = department;
    }

    @Override
    public String getDepartment() {
        return this.department;
    }

    @Override
    public byte[] getPhoto() {
        if (this.photo == null) {
            this.fetchPhoto();
        }
        return this.photo;
    }

    @Override
    public void setPhoto(byte[] photo) {
        this.photo = photo;
    }

    @Override
    public void addMail(String mail) {
        this.mails.add(mail);
    }

    @Override
    public Set<String> getMail() {
        return this.mails;
    }

    @Override
    public Set<String> getAllPhone() {
        HashSet<String> allPhone = new HashSet<String>();
        allPhone.addAll(this.workPhoneNumbers);
        allPhone.addAll(this.mobilePhoneNumbers);
        allPhone.addAll(this.homePhoneNumbers);
        return allPhone;
    }

    @Override
    public void addWorkPhone(String telephoneNumber) {
        this.workPhoneNumbers.add(telephoneNumber);
    }

    @Override
    public Set<String> getWorkPhone() {
        HashSet<String> workPhone = new HashSet<String>();
        workPhone.addAll(this.workPhoneNumbers);
        return workPhone;
    }

    @Override
    public void addMobilePhone(String telephoneNumber) {
        this.mobilePhoneNumbers.add(telephoneNumber);
    }

    @Override
    public Set<String> getMobilePhone() {
        HashSet<String> mobilePhone = new HashSet<String>();
        mobilePhone.addAll(this.mobilePhoneNumbers);
        return mobilePhone;
    }

    @Override
    public void addHomePhone(String telephoneNumber) {
        this.homePhoneNumbers.add(telephoneNumber);
    }

    @Override
    public Set<String> getHomePhone() {
        HashSet<String> homePhone = new HashSet<String>();
        homePhone.addAll(this.homePhoneNumbers);
        return homePhone;
    }

    @Override
    public String getDN() {
        return this.dn;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public int compareTo(LdapPersonFound other) {
        if (this.toString().equals(other.toString())) {
            return this.getDN().compareTo(other.getDN());
        }
        return this.toString().compareTo(other.toString());
    }

    public boolean equals(Object o) {
        if (!(o instanceof LdapPersonFound) || o == null) {
            return false;
        }
        return this.toString().equals(o.toString()) && this.getDN().equals(((LdapPersonFound)o).getDN());
    }

    public int hashCode() {
        return Objects.hash(this.toString(), this.getDN());
    }
}

