/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.impl.osdependent.Resources;
import net.java.sip.communicator.impl.osdependent.jdic.StatusSelector;
import net.java.sip.communicator.impl.osdependent.jdic.StatusSimpleSelector;
import net.java.sip.communicator.plugin.desktoputil.presence.GlobalStatusMessageMenu;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusEnum;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class StatusSubMenu
implements ProviderPresenceStatusListener,
RegistrationStateChangeListener,
ActionListener,
ItemListener {
    private final Map<AccountID, Object> accountSelectors = new Hashtable<AccountID, Object>();
    private final Object menu;
    private static boolean hideAccountStatusSelectors = false;

    public StatusSubMenu(boolean swing, boolean accountMenuSupported) {
        String text = Resources.getString("impl.systray.SET_STATUS");
        if (swing) {
            JMenu menu = new JMenu(text);
            menu.setIcon(Resources.getImage("service.systray.STATUS_MENU_ICON"));
            menu.setPreferredSize(new Dimension(28, 24));
            this.menu = menu;
        } else {
            this.menu = new Menu(text);
        }
        if (accountMenuSupported) {
            String hideAccountStatusSelectorsProperty = "impl.gui.HIDE_ACCOUNT_STATUS_SELECTORS";
            String hideAccountsStatusDefaultValue = OsDependentActivator.getResources().getSettingsString(hideAccountStatusSelectorsProperty);
            if (hideAccountsStatusDefaultValue != null) {
                hideAccountStatusSelectors = Boolean.parseBoolean(hideAccountsStatusDefaultValue);
            }
            hideAccountStatusSelectors = OsDependentActivator.getConfigurationService().getBoolean(hideAccountStatusSelectorsProperty, hideAccountStatusSelectors);
        } else {
            hideAccountStatusSelectors = true;
        }
        GlobalStatusEnum offlineStatus = null;
        for (GlobalStatusEnum status : GlobalStatusEnum.globalStatusSet) {
            this.createMenuItem(status, swing);
            if (status.getStatus() >= 1) continue;
            offlineStatus = status;
        }
        this.selectItemFromStatus(offlineStatus.getStatus());
        if (accountMenuSupported) {
            this.addSeparator();
            StatusSubMenu.addMenuItem(this.menu, new GlobalStatusMessageMenu(swing).getMenu());
        }
        if (!hideAccountStatusSelectors) {
            this.addSeparator();
        }
        this.init();
    }

    public Object getMenu() {
        return this.menu;
    }

    private Object createMenuItem(GlobalStatusEnum status, boolean swing) {
        ItemSelectable menuItem = null;
        if (swing) {
            JCheckBoxMenuItem mItem = new JCheckBoxMenuItem(GlobalStatusEnum.getI18NStatusName((GlobalStatusEnum)status), new ImageIcon(status.getStatusIcon()));
            mItem.setName(status.getStatusName());
            mItem.addActionListener(this);
            menuItem = mItem;
        } else {
            CheckboxMenuItem mItem = new CheckboxMenuItem(GlobalStatusEnum.getI18NStatusName((GlobalStatusEnum)status));
            mItem.setName(status.getStatusName());
            mItem.addItemListener(this);
            menuItem = mItem;
        }
        StatusSubMenu.addMenuItem(this.getMenu(), menuItem);
        return menuItem;
    }

    private void addSeparator() {
        if (this.menu instanceof JMenu) {
            ((JMenu)this.menu).addSeparator();
        } else {
            ((Menu)this.menu).addSeparator();
        }
    }

    private void addAccount(ProtocolProviderService protocolProvider) {
        if (protocolProvider.getAccountID().isStatusMenuHidden()) {
            return;
        }
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        boolean swing = this.menu instanceof JComponent;
        if (presence == null) {
            StatusSimpleSelector simpleSelector = new StatusSimpleSelector(protocolProvider, swing);
            this.accountSelectors.put(protocolProvider.getAccountID(), simpleSelector);
            if (!hideAccountStatusSelectors) {
                StatusSubMenu.addMenuItem(this.menu, simpleSelector.getMenu());
            }
            protocolProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        } else {
            StatusSelector statusSelector = new StatusSelector(protocolProvider, presence, swing);
            this.accountSelectors.put(protocolProvider.getAccountID(), statusSelector);
            if (!hideAccountStatusSelectors) {
                StatusSubMenu.addMenuItem(this.menu, statusSelector.getMenu());
            }
            presence.addProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
        }
    }

    static void addMenuItem(Object menu, Object menuItem) {
        if (menu instanceof Container) {
            ((Container)menu).add((Component)menuItem);
        } else {
            ((Menu)menu).add((MenuItem)menuItem);
        }
    }

    private void removeAccount(ProtocolProviderService protocolProvider) {
        Object selector = this.accountSelectors.get(protocolProvider.getAccountID());
        if (selector == null) {
            return;
        }
        Object selectorMenu = selector instanceof StatusSimpleSelector ? ((StatusSimpleSelector)selector).getMenu() : ((StatusSelector)selector).getMenu();
        if (this.menu instanceof Container) {
            ((Container)this.menu).remove((Component)selectorMenu);
        } else {
            ((MenuContainer)this.menu).remove((MenuComponent)selectorMenu);
        }
        OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
        if (presence != null) {
            presence.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
        } else {
            protocolProvider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }

    private void init() {
        OsDependentActivator.bundleContext.addServiceListener((ServiceListener)new ProtocolProviderServiceListener());
        for (ProtocolProviderService provider : this.getProtocolProviders()) {
            if (provider.getAccountID().isHidden()) continue;
            this.addAccount(provider);
        }
    }

    private List<ProtocolProviderService> getProtocolProviders() {
        BundleContext bundleContext = OsDependentActivator.bundleContext;
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderService.class);
        ArrayList<ProtocolProviderService> protocolProviders = new ArrayList<ProtocolProviderService>();
        if (ppsRefs != null && !ppsRefs.isEmpty()) {
            for (ServiceReference ppsRef : ppsRefs) {
                protocolProviders.add((ProtocolProviderService)bundleContext.getService(ppsRef));
            }
        }
        return protocolProviders;
    }

    public void providerStatusChanged(ProviderPresenceStatusChangeEvent evt) {
        ProtocolProviderService pps = evt.getProvider();
        StatusSelector selectorBox = (StatusSelector)this.accountSelectors.get(pps.getAccountID());
        if (selectorBox != null) {
            selectorBox.updateStatus(evt.getNewStatus());
        }
        this.updateGlobalStatus();
    }

    public void providerStatusMessageChanged(PropertyChangeEvent evt) {
    }

    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        ProtocolProviderService pps = evt.getProvider();
        StatusSimpleSelector selectorBox = (StatusSimpleSelector)this.accountSelectors.get(pps.getAccountID());
        if (selectorBox != null) {
            selectorBox.updateStatus();
        }
        this.updateGlobalStatus();
    }

    private void updateGlobalStatus() {
        int status = 0;
        boolean hasAvailableProvider = false;
        for (ProtocolProviderService protocolProvider : this.getProtocolProviders()) {
            if (protocolProvider.getAccountID().isHidden() || !protocolProvider.isRegistered()) continue;
            OperationSetPresence presence = (OperationSetPresence)protocolProvider.getOperationSet(OperationSetPresence.class);
            if (presence == null) {
                hasAvailableProvider = true;
                continue;
            }
            int presenceStatus = presence == null ? 50 : presence.getPresenceStatus().getStatus();
            if (status >= presenceStatus) continue;
            status = presenceStatus;
        }
        if (status == 0 && hasAvailableProvider) {
            status = 50;
        }
        this.selectItemFromStatus(status);
    }

    private void selectItemFromStatus(int status) {
        block5: {
            String nameToSelect;
            block4: {
                nameToSelect = status < 20 ? "Offline" : (status < 31 ? "Do Not Disturb" : (status < 36 ? "Extended Away" : (status < 50 ? "Away" : (status < 80 ? "Online" : (status < 100 ? "Free For Chat" : "Offline")))));
                if (!(this.menu instanceof Menu)) break block4;
                Menu theMenu = (Menu)this.menu;
                for (int i = 0; i < theMenu.getItemCount(); ++i) {
                    MenuItem item = theMenu.getItem(i);
                    if (!(item instanceof CheckboxMenuItem)) continue;
                    if (item.getName().equals(nameToSelect)) {
                        ((CheckboxMenuItem)item).setState(true);
                        continue;
                    }
                    ((CheckboxMenuItem)item).setState(false);
                }
                break block5;
            }
            if (!(this.menu instanceof JMenu)) break block5;
            JMenu theMenu = (JMenu)this.menu;
            for (int i = 0; i < theMenu.getItemCount(); ++i) {
                JMenuItem item = theMenu.getItem(i);
                if (!(item instanceof JCheckBoxMenuItem)) continue;
                if (item.getName().equals(nameToSelect)) {
                    item.setSelected(true);
                    continue;
                }
                item.setSelected(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JMenuItem) {
            this.changeStatusFromName(((JMenuItem)source).getName());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object sourceItem = e.getSource();
        if (e.getStateChange() == 1) {
            if (sourceItem instanceof CheckboxMenuItem) {
                this.changeStatusFromName(((CheckboxMenuItem)sourceItem).getName());
            }
        } else if (e.getStateChange() == 2 && sourceItem instanceof CheckboxMenuItem) {
            ((CheckboxMenuItem)sourceItem).setState(true);
        }
    }

    private void changeStatusFromName(String itemName) {
        OsDependentActivator.getGlobalStatusService().publishStatus(GlobalStatusEnum.getStatusByName((String)itemName));
    }

    private class ProtocolProviderServiceListener
    implements ServiceListener {
        private ProtocolProviderServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            ServiceReference serviceRef = event.getServiceReference();
            if (serviceRef.getBundle().getState() == 16) {
                return;
            }
            Object service = OsDependentActivator.bundleContext.getService(serviceRef);
            if (!(service instanceof ProtocolProviderService)) {
                return;
            }
            ProtocolProviderService provider = (ProtocolProviderService)service;
            switch (event.getType()) {
                case 1: {
                    StatusSubMenu.this.addAccount(provider);
                    break;
                }
                case 4: {
                    StatusSubMenu.this.removeAccount(provider);
                }
            }
        }
    }
}

