/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.notificationconfiguration;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationConfigurationActivator;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationEntry;
import net.java.sip.communicator.plugin.notificationconfiguration.NotificationsTable;
import net.java.sip.communicator.plugin.notificationconfiguration.Resources;
import net.java.sip.communicator.plugin.notificationconfiguration.SoundFilter;
import net.java.sip.communicator.service.notification.NotificationAction;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.SoundNotificationAction;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.audionotifier.SCAudioClip;

public class NotificationConfigurationPanel
extends TransparentPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 5784331951722787598L;
    private final Logger logger = Logger.getLogger(NotificationConfigurationPanel.class);
    private NotificationsTable notificationList;
    private final JTextField soundFileTextField = new JTextField();
    private final JButton soundFileButton = new JButton(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.FOLDER_ICON")));
    private final JTextField programFileTextField = new JTextField();
    private final JButton programFileButton = new JButton(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.FOLDER_ICON")));
    private final JButton playSoundButton = new JButton(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.PLAY_ICON")));
    private final JButton restoreButton = new JButton(Resources.getString("plugin.notificationconfig.RESTORE"));
    private SipCommFileChooser programFileChooser;
    private SipCommFileChooser soundFileChooser;
    private static final String PROGRAM_LAST_PATH_PROP = "net.java.sip.communicator.plugin.notificationconfiguration.PROGRAM_LAST_PATH";
    private static final String SOUND_LAST_PATH_PROP = "net.java.sip.communicator.plugin.notificationconfiguration.SOUND_LAST_PATH";
    private String programLastFilePath;
    private String soundLastFilePath;
    private boolean isCurrentlyChangeEntryInTable = false;

    public NotificationConfigurationPanel() {
        super((LayoutManager)new BorderLayout());
        TransparentPanel labelsPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        JLabel soundFileLabel = new JLabel(Resources.getString("plugin.notificationconfig.SOUND_FILE"));
        JLabel programFileLabel = new JLabel(Resources.getString("plugin.notificationconfig.PROGRAM_FILE"));
        labelsPanel.add(soundFileLabel);
        labelsPanel.add(programFileLabel);
        TransparentPanel soundFilePanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        this.playSoundButton.setMinimumSize(new Dimension(30, 30));
        this.playSoundButton.setPreferredSize(new Dimension(30, 30));
        this.playSoundButton.setOpaque(false);
        this.playSoundButton.addActionListener(this);
        soundFilePanel.add(this.playSoundButton);
        this.soundFileTextField.setPreferredSize(new Dimension(200, 30));
        this.soundFileTextField.getDocument().addDocumentListener(this);
        soundFilePanel.add(this.soundFileTextField);
        this.soundFileButton.setMinimumSize(new Dimension(30, 30));
        this.soundFileButton.setPreferredSize(new Dimension(30, 30));
        this.soundFileButton.addActionListener(this);
        soundFilePanel.add(this.soundFileButton);
        TransparentPanel programFilePanel = new TransparentPanel((LayoutManager)new FlowLayout(0));
        JLabel emptyLabel = new JLabel();
        emptyLabel.setPreferredSize(new Dimension(30, 30));
        programFilePanel.add(emptyLabel);
        this.programFileTextField.setPreferredSize(new Dimension(200, 30));
        this.programFileTextField.getDocument().addDocumentListener(this);
        programFilePanel.add(this.programFileTextField);
        this.programFileButton.setMinimumSize(new Dimension(30, 30));
        this.programFileButton.setPreferredSize(new Dimension(30, 30));
        this.programFileButton.addActionListener(this);
        programFilePanel.add(this.programFileButton);
        TransparentPanel valuesPanel = new TransparentPanel((LayoutManager)new GridLayout(2, 1));
        valuesPanel.add((Component)soundFilePanel);
        valuesPanel.add((Component)programFilePanel);
        TransparentPanel southPanel = new TransparentPanel((LayoutManager)new BorderLayout());
        southPanel.add((Component)labelsPanel, "West");
        southPanel.add((Component)valuesPanel, "Center");
        this.restoreButton.addActionListener(this);
        TransparentPanel restorePanel = new TransparentPanel((LayoutManager)new FlowLayout(2, 0, 0));
        restorePanel.add(this.restoreButton);
        southPanel.add((Component)restorePanel, "South");
        this.add((Component)southPanel, "South");
        this.soundFileChooser = GenericFileDialog.create(null, (String)Resources.getString("plugin.notificationconfig.BROWSE_SOUND"), (int)0);
        this.programFileChooser = GenericFileDialog.create(null, (String)Resources.getString("plugin.notificationconfig.BROWSE_PROGRAM"), (int)0);
        String[] soundFormats = new String[]{"wav"};
        this.soundFileChooser.setFileFilter((SipCommFileFilter)new SoundFilter(soundFormats));
        this.initNotificationsList();
    }

    private void initNotificationsList() {
        String[] columnToolTips = new String[]{"plugin.notificationconfig.tableheader.ENABLE", "plugin.notificationconfig.tableheader.EXECUTE", "plugin.notificationconfig.tableheader.POPUP", "plugin.notificationconfig.tableheader.SOUND", "plugin.notificationconfig.tableheader.PLAYBACK_SOUND", "plugin.notificationconfig.tableheader.PCSPEAKER_SOUND", "plugin.notificationconfig.tableheader.DESCRIPTION"};
        JLabel icon1 = new JLabel(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.PROG_ICON")));
        JLabel icon2 = new JLabel(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.POPUP_ICON")));
        JLabel icon3 = new JLabel(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.SOUND_ICON_NOTIFY")));
        JLabel icon4 = new JLabel(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.SOUND_ICON_PLAYBACK")));
        JLabel icon5 = new JLabel(new ImageIcon(Resources.getImageInBytes("plugin.notificationconfig.SOUND_ICON")));
        Object[] column = new Object[]{"", icon1, icon2, icon3, icon4, icon5, Resources.getString("plugin.notificationconfig.DESCRIPTION")};
        this.notificationList = new NotificationsTable(column, columnToolTips, this);
        this.notificationList.setPreferredSize(new Dimension(500, 300));
        this.add(this.notificationList, "Center");
        if (this.notificationList.getRowCount() > 0) {
            this.notificationList.setSelectedRow(0);
        }
    }

    public void setNotificationEntry(NotificationEntry entry) {
        this.isCurrentlyChangeEntryInTable = true;
        this.programFileButton.setEnabled(entry.getProgram());
        this.programFileTextField.setEnabled(entry.getProgram());
        String programFile = entry.getProgramFile();
        this.programFileTextField.setText(programFile != null && programFile.length() > 0 ? programFile : "");
        this.programFileChooser.setStartPath(programFile != null && programFile.length() > 0 ? programFile : this.getLastProgramPath());
        this.soundFileButton.setEnabled(entry.getSoundNotification() || entry.getSoundPlayback());
        this.soundFileTextField.setEnabled(entry.getSoundNotification() || entry.getSoundPlayback());
        String soundFile = entry.getSoundFile();
        this.soundFileTextField.setText(soundFile != null && soundFile.length() > 0 ? soundFile : "");
        this.soundFileChooser.setStartPath(soundFile != null && soundFile.length() > 0 ? soundFile : this.getLastSoundPath());
        this.isCurrentlyChangeEntryInTable = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row = this.notificationList.getSelectedRow();
        if (e.getSource() == this.restoreButton) {
            this.notificationList.clear();
            NotificationConfigurationActivator.getNotificationService().restoreDefaults();
        } else if (e.getSource() == this.soundFileButton) {
            if (row < 0) {
                return;
            }
            NotificationEntry entry = this.notificationList.getNotificationEntry(row);
            File file = this.soundFileChooser.getFileFromDialog();
            if (file != null) {
                try {
                    this.setLastSoundPath(file.getParent());
                    String fileUri = file.toURI().toURL().toExternalForm();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Opening: " + fileUri));
                    }
                    entry.setSoundFile(fileUri);
                    this.soundFileTextField.setText(fileUri);
                }
                catch (MalformedURLException ex) {
                    this.logger.error((Object)"Error file path parsing", (Throwable)ex);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Open command cancelled by user.");
            }
        } else if (e.getSource() == this.programFileButton) {
            if (row < 0) {
                return;
            }
            NotificationEntry entry = this.notificationList.getNotificationEntry(row);
            File file = this.programFileChooser.getFileFromDialog();
            if (file != null) {
                this.setLastProgramPath(file.getParent());
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Opening: " + file.getAbsolutePath()));
                }
                entry.setProgramFile(file.getAbsolutePath());
                this.programFileTextField.setText(file.getAbsolutePath());
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Open command cancelled by user.");
            }
        } else if (e.getSource() == this.playSoundButton) {
            String soundFile = this.soundFileTextField.getText();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("****" + soundFile + "****" + soundFile.length()));
            }
            if (soundFile.length() != 0) {
                AudioNotifierService audioNotifServ = NotificationConfigurationActivator.getAudioNotifierService();
                SCAudioClip sound = audioNotifServ.createAudio(soundFile);
                sound.play();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"No file specified");
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.textFieldUpdated(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.textFieldUpdated(event);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
    }

    public void textFieldUpdated(DocumentEvent event) {
        if (this.isCurrentlyChangeEntryInTable) {
            return;
        }
        NotificationEntry entry = this.notificationList.getNotificationEntry(this.notificationList.getSelectedRow());
        if (event.getDocument().equals(this.programFileTextField.getDocument())) {
            entry.setProgramFile(this.programFileTextField.getText());
            NotificationConfigurationActivator.getNotificationService().registerNotificationForEvent(entry.getEvent(), "CommandAction", entry.getProgramFile(), "");
        }
        if (event.getDocument().equals(this.soundFileTextField.getDocument())) {
            entry.setSoundFile(this.soundFileTextField.getText());
            NotificationService notificationService = NotificationConfigurationActivator.getNotificationService();
            SoundNotificationAction origSoundAction = (SoundNotificationAction)notificationService.getEventNotificationAction(entry.getEvent(), "SoundAction");
            NotificationConfigurationActivator.getNotificationService().registerNotificationForEvent(entry.getEvent(), (NotificationAction)new SoundNotificationAction(entry.getSoundFile(), origSoundAction.getLoopInterval(), origSoundAction.isSoundNotificationEnabled(), origSoundAction.isSoundPlaybackEnabled(), origSoundAction.isSoundPCSpeakerEnabled()));
        }
    }

    private String getLastSoundPath() {
        return NotificationConfigurationActivator.getConfigurationService().getString(SOUND_LAST_PATH_PROP, "");
    }

    private void setLastSoundPath(String path) {
        NotificationConfigurationActivator.getConfigurationService().setProperty(SOUND_LAST_PATH_PROP, (Object)path);
    }

    private String getLastProgramPath() {
        return NotificationConfigurationActivator.getConfigurationService().getString(PROGRAM_LAST_PATH_PROP, "");
    }

    private void setLastProgramPath(String path) {
        NotificationConfigurationActivator.getConfigurationService().setProperty(PROGRAM_LAST_PATH_PROP, (Object)path);
    }
}

