/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.ldap.configform;

import javax.swing.table.AbstractTableModel;
import net.java.sip.communicator.plugin.ldap.LdapActivator;
import net.java.sip.communicator.plugin.ldap.configform.LdapConfigForm;
import net.java.sip.communicator.plugin.ldap.configform.Resources;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapDirectorySet;

public class LdapTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 0L;
    private LdapDirectorySet serverSet = LdapActivator.getLdapService().getServerSet();

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return Resources.getString("impl.ldap.ENABLED");
            }
            case 1: {
                return Resources.getString("impl.ldap.SERVER_NAME");
            }
            case 2: {
                return Resources.getString("impl.ldap.SERVER_HOSTNAME");
            }
            case 3: {
                return Resources.getString("impl.ldap.PHONE_PREFIX");
            }
        }
        throw new IllegalArgumentException("column not found");
    }

    @Override
    public int getRowCount() {
        return this.serverSet.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return new Boolean(this.getServerAt(row).isEnabled());
            }
            case 1: {
                return this.getServerAt(row).getSettings().getName();
            }
            case 2: {
                return this.getServerAt(row).getSettings().getHostname();
            }
            case 3: {
                return this.getServerAt(row).getSettings().getGlobalPhonePrefix();
            }
        }
        throw new IllegalArgumentException("column not found");
    }

    public LdapDirectory getServerAt(int row) {
        int i = 0;
        for (LdapDirectory server : this.serverSet) {
            if (i == row) {
                return server;
            }
            ++i;
        }
        throw new IllegalArgumentException("row not found");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Object o = this.getValueAt(0, columnIndex);
        if (o == null) {
            return String.class;
        }
        return o.getClass();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            throw new IllegalArgumentException("non editable column!");
        }
        LdapDirectory server = this.getServerAt(rowIndex);
        LdapConfigForm.RefreshContactSourceThread th = null;
        server.setEnabled(!server.isEnabled());
        th = !server.isEnabled() ? new LdapConfigForm.RefreshContactSourceThread(server, null) : new LdapConfigForm.RefreshContactSourceThread(null, server);
        th.start();
        server.getSettings().persistentSave();
    }
}

