/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import java.util.ArrayList;
import java.util.List;
import javax.sip.Dialog;
import javax.sip.SipException;
import net.java.sip.communicator.impl.protocol.sip.SipApplicationData;

public final class EventPackageUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addSubscription(Dialog dialog, Object subscription) throws SipException {
        Dialog dialog2 = dialog;
        synchronized (dialog2) {
            DialogApplicationData appData = (DialogApplicationData)SipApplicationData.getApplicationData(dialog, "subscriptions");
            if (appData == null) {
                appData = new DialogApplicationData();
                SipApplicationData.setApplicationData(dialog, "subscriptions", appData);
            }
            if (appData.addSubscription(subscription)) {
                try {
                    dialog.terminateOnBye(false);
                    return true;
                }
                catch (SipException ex) {
                    appData.removeSubscription(subscription);
                    throw ex;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isByeProcessed(Dialog dialog) {
        Dialog dialog2 = dialog;
        synchronized (dialog2) {
            DialogApplicationData applicationData = (DialogApplicationData)SipApplicationData.getApplicationData(dialog, "subscriptions");
            return applicationData == null ? false : applicationData.isByeProcessed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processByeThenIsDialogAlive(Dialog dialog) throws SipException {
        Dialog dialog2 = dialog;
        synchronized (dialog2) {
            DialogApplicationData applicationData = (DialogApplicationData)SipApplicationData.getApplicationData(dialog, "subscriptions");
            if (applicationData != null) {
                applicationData.setByeProcessed(true);
                if (applicationData.getSubscriptionCount() > 0) {
                    dialog.terminateOnBye(false);
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeSubscriptionThenIsDialogAlive(Dialog dialog, Object subscription) {
        Dialog dialog2 = dialog;
        synchronized (dialog2) {
            DialogApplicationData applicationData = (DialogApplicationData)SipApplicationData.getApplicationData(dialog, "subscriptions");
            if (applicationData != null && applicationData.removeSubscription(subscription) && applicationData.getSubscriptionCount() <= 0 && applicationData.isByeProcessed()) {
                dialog.delete();
                return false;
            }
            return true;
        }
    }

    private EventPackageUtils() {
    }

    private static class DialogApplicationData {
        private boolean byeIsProcessed;
        private final List<Object> subscriptions = new ArrayList<Object>();

        private DialogApplicationData() {
        }

        public boolean addSubscription(Object subscription) {
            if (!this.subscriptions.contains(subscription)) {
                return this.subscriptions.add(subscription);
            }
            return false;
        }

        public boolean isByeProcessed() {
            return this.byeIsProcessed;
        }

        public int getSubscriptionCount() {
            return this.subscriptions.size();
        }

        public boolean removeSubscription(Object subscription) {
            return this.subscriptions.remove(subscription);
        }

        public void setByeProcessed(boolean byeIsProcessed) {
            this.byeIsProcessed = byeIsProcessed;
        }
    }
}

