/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.protocol;

import com.lti.utils.PathUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;
import javax.media.protocol.SourceCloneable;
import net.sf.fmj.media.MimeManager;
import net.sf.fmj.utility.LoggerSingleton;
import net.sf.fmj.utility.URLUtils;

public class URLDataSource
extends PullDataSource
implements SourceCloneable {
    private static final Logger logger = LoggerSingleton.logger;
    protected URLConnection conn;
    protected boolean connected = false;
    private String contentTypeStr;
    private ContentDescriptor contentType;
    protected URLSourceStream[] sources;

    protected URLDataSource() {
    }

    public URLDataSource(URL url) {
        this.setLocator(new MediaLocator(url));
    }

    @Override
    public void connect() throws IOException {
        String newUrlStr;
        URL url = this.getLocator().getURL();
        if (url.getProtocol().equals("file") && (newUrlStr = URLUtils.createAbsoluteFileUrl(url.toExternalForm())) != null && !newUrlStr.toString().equals(url.toExternalForm())) {
            logger.warning("Changing file URL to absolute for URL.openConnection, from " + url.toExternalForm() + " to " + newUrlStr);
            url = new URL(newUrlStr);
        }
        this.conn = url.openConnection();
        if (!url.getProtocol().equals("ftp") && this.conn.getURL().getProtocol().equals("ftp")) {
            logger.warning("URL.openConnection() morphed " + url + " to " + this.conn.getURL());
            throw new IOException("URL.openConnection() returned an FTP connection for a non-ftp url: " + url);
        }
        if (this.conn instanceof HttpURLConnection) {
            String result;
            String ext;
            HttpURLConnection huc = (HttpURLConnection)this.conn;
            huc.connect();
            int code = huc.getResponseCode();
            if (code < 200 || code >= 300) {
                huc.disconnect();
                throw new IOException("HTTP response code: " + code);
            }
            logger.finer("URL: " + url);
            logger.finer("Response code: " + code);
            logger.finer("Full content type: " + this.conn.getContentType());
            boolean contentTypeSet = false;
            if (this.stripTrailer(this.conn.getContentType()).equals("text/plain") && (ext = PathUtils.extractExtension(url.getPath())) != null && (result = MimeManager.getMimeType(ext)) != null) {
                this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(result);
                contentTypeSet = true;
                logger.fine("Received content type " + this.conn.getContentType() + "; overriding based on extension, to: " + result);
            }
            if (!contentTypeSet) {
                this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.stripTrailer(this.conn.getContentType()));
            }
        } else {
            this.conn.connect();
            this.contentTypeStr = ContentDescriptor.mimeTypeToPackageName(this.conn.getContentType());
        }
        this.contentType = new ContentDescriptor(this.contentTypeStr);
        this.sources = new URLSourceStream[1];
        this.sources[0] = new URLSourceStream();
        this.connected = true;
    }

    @Override
    public DataSource createClone() {
        URLDataSource d;
        try {
            d = new URLDataSource(this.getLocator().getURL());
        }
        catch (MalformedURLException e) {
            logger.log(Level.WARNING, "" + e, e);
            return null;
        }
        if (this.connected) {
            try {
                d.connect();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "" + e, e);
                return null;
            }
        }
        return d;
    }

    @Override
    public void disconnect() {
        if (!this.connected) {
            return;
        }
        if (this.conn != null && this.conn instanceof HttpURLConnection) {
            HttpURLConnection huc = (HttpURLConnection)this.conn;
            huc.disconnect();
        }
        this.connected = false;
    }

    @Override
    public String getContentType() {
        return this.contentTypeStr;
    }

    @Override
    public Object getControl(String controlName) {
        return null;
    }

    @Override
    public Object[] getControls() {
        return new Object[0];
    }

    @Override
    public Time getDuration() {
        return Time.TIME_UNKNOWN;
    }

    @Override
    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void stop() throws IOException {
    }

    private String stripTrailer(String contentType) {
        int index = contentType.indexOf(";");
        if (index < 0) {
            return contentType;
        }
        String result = contentType.substring(0, index);
        return result;
    }

    class URLSourceStream
    implements PullSourceStream {
        private boolean endOfStream = false;

        URLSourceStream() {
        }

        @Override
        public boolean endOfStream() {
            return this.endOfStream;
        }

        @Override
        public ContentDescriptor getContentDescriptor() {
            return URLDataSource.this.contentType;
        }

        @Override
        public long getContentLength() {
            return URLDataSource.this.conn.getContentLength();
        }

        @Override
        public Object getControl(String controlType) {
            return null;
        }

        @Override
        public Object[] getControls() {
            return new Object[0];
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int result = URLDataSource.this.conn.getInputStream().read(buffer, offset, length);
            if (result == -1) {
                this.endOfStream = true;
            }
            return result;
        }

        @Override
        public boolean willReadBlock() {
            try {
                return URLDataSource.this.conn.getInputStream().available() <= 0;
            }
            catch (IOException e) {
                return true;
            }
        }
    }
}

