/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.replacement.flickr;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.service.replacement.ReplacementService;
import net.java.sip.communicator.util.Logger;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class ReplacementServiceFlickrImpl
implements ReplacementService {
    private static final Logger logger = Logger.getLogger(ReplacementServiceFlickrImpl.class);
    public static final String FLICKR_PATTERN = "(https?\\:\\/\\/(www\\.)*?flickr\\.com\\/photos\\/[0-9a-zA-Z_\\-\\@]+\\/([0-9]+)(\\/[^\"\\<]*)*)";
    public static final String API_KEY = "8b5d9cee22f0f5154bf4e9846c025484";
    public static final String FLICKR_CONFIG_LABEL = "Flickr Images";
    public static final String SOURCE_NAME = "FLICKR";

    public ReplacementServiceFlickrImpl() {
        logger.trace((Object)"Creating a Flickr Source.");
    }

    public String getReplacement(String sourceString) {
        Pattern p = Pattern.compile("\\/photos\\/[0-9a-zA-Z_\\-\\@]+\\/([0-9]+)(\\/[^\"\\<]*)*", 34);
        Matcher m = p.matcher(sourceString);
        String thumbUrl = sourceString;
        while (m.find()) {
            try {
                JSONObject result;
                String inputLine;
                String url = "http://api.flickr.com/services/rest/?method=flickr.photos.getInfo&api_key=8b5d9cee22f0f5154bf4e9846c025484&photo_id=" + m.group(1) + "&format=json&nojsoncallback=1";
                URL flickrURL = new URL(url);
                URLConnection conn = flickrURL.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                String holder = "";
                while ((inputLine = in.readLine()) != null) {
                    holder = inputLine;
                }
                in.close();
                JSONObject wrapper = (JSONObject)JSONValue.parseWithException((String)holder);
                if (!wrapper.get((Object)"stat").equals("ok") || (result = (JSONObject)wrapper.get((Object)"photo")).isEmpty()) continue;
                String farmID = String.valueOf(result.get((Object)"farm"));
                String serverID = (String)result.get((Object)"server");
                String secret = (String)result.get((Object)"secret");
                thumbUrl = "http://farm" + farmID + ".static.flickr.com/" + serverID + "/" + m.group(1) + "_" + secret + "_t.jpg";
            }
            catch (Throwable e) {
                logger.error((Object)"Error parsing", e);
            }
        }
        return thumbUrl;
    }

    public String getSourceName() {
        return SOURCE_NAME;
    }

    public String getPattern() {
        return FLICKR_PATTERN;
    }
}

