/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.globaldisplaydetails;

import java.util.Collection;
import net.java.sip.communicator.impl.globaldisplaydetails.GlobalDisplayDetailsImpl;
import net.java.sip.communicator.impl.globaldisplaydetails.GlobalStatusServiceImpl;
import net.java.sip.communicator.service.globaldisplaydetails.GlobalDisplayDetailsService;
import net.java.sip.communicator.service.gui.AlertUIService;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.service.protocol.globalstatus.GlobalStatusService;
import net.java.sip.communicator.util.ServiceUtils;
import net.java.sip.communicator.util.UtilActivator;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class GlobalDisplayDetailsActivator
implements BundleActivator,
ServiceListener {
    private static BundleContext bundleContext;
    private static ResourceManagementService resourcesService;
    private static ConfigurationService configService;
    private static AlertUIService alertUIService;
    private static UIService uiService;
    static GlobalDisplayDetailsImpl displayDetailsImpl;
    static GlobalStatusServiceImpl globalStatusService;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        displayDetailsImpl = new GlobalDisplayDetailsImpl();
        globalStatusService = new GlobalStatusServiceImpl();
        bundleContext.addServiceListener((ServiceListener)this);
        this.handleAlreadyRegisteredProviders();
        bundleContext.registerService(GlobalDisplayDetailsService.class.getName(), (Object)displayDetailsImpl, null);
        bundleContext.registerService(GlobalStatusService.class.getName(), (Object)globalStatusService, null);
    }

    private void handleAlreadyRegisteredProviders() {
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bundleContext, ProtocolProviderService.class);
        if (ppsRefs.isEmpty()) {
            return;
        }
        for (ServiceReference ppsRef : ppsRefs) {
            ProtocolProviderService pps = (ProtocolProviderService)bundleContext.getService(ppsRef);
            this.handleProviderAdded(pps);
        }
    }

    private void handleProviderAdded(ProtocolProviderService pps) {
        pps.addRegistrationStateChangeListener((RegistrationStateChangeListener)displayDetailsImpl);
        globalStatusService.handleProviderAdded(pps);
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }

    public static ResourceManagementService getResources() {
        if (resourcesService == null) {
            resourcesService = (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
        }
        return resourcesService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configService == null) {
            configService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configService;
    }

    public static AlertUIService getAlertUIService() {
        if (alertUIService == null) {
            alertUIService = (AlertUIService)ServiceUtils.getService((BundleContext)bundleContext, AlertUIService.class);
        }
        return alertUIService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        if (serviceRef.getBundle().getState() == 16) {
            return;
        }
        Object service = UtilActivator.bundleContext.getService(serviceRef);
        if (!(service instanceof ProtocolProviderService)) {
            return;
        }
        ProtocolProviderService pps = (ProtocolProviderService)service;
        switch (event.getType()) {
            case 1: {
                this.handleProviderAdded(pps);
                break;
            }
            case 4: {
                pps.removeRegistrationStateChangeListener((RegistrationStateChangeListener)displayDetailsImpl);
                globalStatusService.handleProviderRemoved(pps);
            }
        }
    }
}

