/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.chooser;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingChooser;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingEntry;

public class BindingAdaptor
extends KeyAdapter {
    private int inputEventType = 401;
    private int disablingKeyCode = 27;
    private boolean isDisablingEnabled = false;
    private final BindingChooser chooser;
    private KeyEvent buffer = null;

    BindingAdaptor(BindingChooser chooser) {
        this.chooser = chooser;
    }

    public boolean isBindingDisablingEnabled() {
        return this.isDisablingEnabled;
    }

    public void setBindingsDisableable(boolean enable) {
        this.isDisablingEnabled = enable;
    }

    public int getDisablingKeyCode() {
        return this.disablingKeyCode;
    }

    public void setDisablingKeyCode(int keycode) {
        this.disablingKeyCode = keycode;
    }

    public int getInputEventType() {
        return this.inputEventType;
    }

    public void setInputEventType(int type) {
        int[] validTypes = new int[]{401, 402, 400};
        boolean isValid = false;
        for (int validType : validTypes) {
            isValid |= type == validType;
        }
        if (!isValid) {
            StringBuilder message = new StringBuilder();
            message.append("Unrecognized event type: ");
            message.append(type);
            message.append(" (must match KEY_PRESSED, KEY_RELEASED, or KEY_TYPED)");
            throw new IllegalArgumentException(message.toString());
        }
        this.inputEventType = type;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.buffer = event;
    }

    @Override
    public void keyReleased(KeyEvent event) {
        if (this.inputEventType == 401 && this.buffer != null) {
            this.setShortcut(this.buffer);
        } else if (this.inputEventType == 402) {
            this.setShortcut(event);
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (this.inputEventType == 400) {
            this.setShortcut(event);
        }
    }

    private void setShortcut(KeyEvent event) {
        if (this.chooser.isBindingSelected()) {
            KeyStroke input = KeyStroke.getKeyStrokeForEvent(event);
            if (this.isDisablingEnabled && input.getKeyCode() == this.disablingKeyCode) {
                String action = this.chooser.getSelected().getAction();
                if (this.chooser.getBindings().contains((Object)new BindingEntry(BindingEntry.DISABLED, action))) {
                    this.chooser.setSelected(null);
                } else {
                    this.chooser.doInput(BindingEntry.DISABLED);
                }
            } else if (!this.chooser.contains(input) || this.chooser.getSelected().getShortcut().equals(input)) {
                this.chooser.doInput(input);
            }
            this.buffer = null;
        }
    }
}

