/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.globalchooser;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.keybindingchooser.KeybindingChooserActivator;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.GlobalShortcutDialog;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.GlobalShortcutEntry;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.GlobalShortcutTableModel;
import net.java.sip.communicator.plugin.keybindingchooser.globalchooser.Resources;
import net.java.sip.communicator.service.globalshortcut.GlobalShortcutService;
import net.java.sip.communicator.service.keybindings.GlobalKeybindingSet;
import net.java.sip.communicator.service.keybindings.KeybindingsService;
import net.java.sip.communicator.util.Logger;

public class GlobalShortcutConfigForm
extends TransparentPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 0L;
    private static Logger logger = Logger.getLogger(GlobalShortcutConfigForm.class);
    private JTable shortcutsTable = new JTable();
    private JScrollPane scrollPane = new JScrollPane();
    private JPanel mainPanel = this;
    private GlobalShortcutTableModel tableModel = new GlobalShortcutTableModel();

    public GlobalShortcutConfigForm() {
        super((LayoutManager)new BorderLayout());
        logger.trace((Object)"New global shortcut configuration form.");
        this.initComponents();
    }

    private void initComponents() {
        this.shortcutsTable.setRowHeight(22);
        this.shortcutsTable.setSelectionMode(0);
        this.shortcutsTable.setShowHorizontalLines(false);
        this.shortcutsTable.setShowVerticalLines(false);
        this.shortcutsTable.setModel(this.tableModel);
        this.shortcutsTable.setAutoResizeMode(4);
        this.shortcutsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    int row = GlobalShortcutConfigForm.this.shortcutsTable.getSelectedRow();
                    GlobalShortcutEntry en = GlobalShortcutConfigForm.this.tableModel.getEntryAt(row);
                    ArrayList<AWTKeyStroke> kss = new ArrayList<AWTKeyStroke>();
                    GlobalShortcutDialog dialog = new GlobalShortcutDialog((Dialog)GlobalShortcutConfigForm.this.getTopLevelAncestor(), en);
                    kss.add(en.getShortcut());
                    kss.add(en.getShortcut2());
                    KeybindingChooserActivator.getGlobalShortcutService().setEnable(false);
                    int ret = dialog.showDialog();
                    if (ret == 1) {
                        kss = new ArrayList();
                        List<GlobalShortcutEntry> lst = GlobalShortcutConfigForm.this.tableModel.getEntries();
                        for (GlobalShortcutEntry ee : lst) {
                            AWTKeyStroke s2;
                            boolean isEntry = ee == en;
                            AWTKeyStroke s1 = isEntry ? null : ee.getShortcut();
                            AWTKeyStroke aWTKeyStroke = s2 = isEntry ? null : ee.getShortcut2();
                            if (s1 != null && en.getShortcut() != null && s1.getKeyCode() == en.getShortcut().getKeyCode() && s1.getModifiers() == en.getShortcut().getModifiers()) {
                                kss.add(null);
                                kss.add(ee.getShortcut2());
                                ee.setShortcuts(kss);
                                break;
                            }
                            if (s2 == null || en.getShortcut2() == null || s2.getKeyCode() != en.getShortcut2().getKeyCode() || s2.getModifiers() != en.getShortcut2().getModifiers()) continue;
                            kss.add(ee.getShortcut());
                            kss.add(null);
                            ee.setShortcuts(kss);
                            break;
                        }
                        KeybindingChooserActivator.getGlobalShortcutService().setEnable(true);
                        GlobalShortcutConfigForm.this.saveConfig();
                        GlobalShortcutConfigForm.this.refresh();
                        KeybindingChooserActivator.getGlobalShortcutService().setEnable(true);
                    } else {
                        en.setShortcuts(kss);
                    }
                }
            }
        });
        this.scrollPane.getViewport().add(this.shortcutsTable);
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.mainPanel.setPreferredSize(new Dimension(500, 400));
        this.shortcutsTable.getSelectionModel().addListSelectionListener(this);
        this.loadConfig();
    }

    private void loadConfig() {
        KeybindingsService keybindingService = KeybindingChooserActivator.getKeybindingsService();
        GlobalKeybindingSet set = keybindingService.getGlobalBindings();
        for (Map.Entry entry : set.getBindings().entrySet()) {
            String key = (String)entry.getKey();
            List kss = (List)entry.getValue();
            GlobalShortcutEntry gke = null;
            String desc = null;
            if (key.equals("answer")) {
                desc = Resources.getString("plugin.keybindings.globalchooser.ANSWER_CALL");
            } else if (key.equals("hangup")) {
                desc = Resources.getString("plugin.keybindings.globalchooser.HANGUP_CALL");
            } else if (key.equals("answer_hangup")) {
                desc = Resources.getString("plugin.keybindings.globalchooser.ANSWER_HANGUP_CALL");
            } else if (key.equals("contactlist")) {
                desc = Resources.getString("plugin.keybindings.globalchooser.SHOW_CONTACTLIST");
            } else if (key.equals("mute")) {
                desc = Resources.getString("plugin.keybindings.globalchooser.MUTE_CALLS");
            } else {
                if (!key.equals("push_to_talk")) continue;
                desc = Resources.getString("plugin.keybindings.globalchooser.PUSH_TO_TALK");
            }
            gke = new GlobalShortcutEntry(desc, kss);
            this.tableModel.addEntry(gke);
        }
        this.refresh();
    }

    public void saveConfig() {
        KeybindingsService keybindingService = KeybindingChooserActivator.getKeybindingsService();
        GlobalShortcutService globalShortcutService = KeybindingChooserActivator.getGlobalShortcutService();
        GlobalKeybindingSet globalBindingSet = keybindingService.getGlobalBindings();
        Map gBindings = globalBindingSet.getBindings();
        List<GlobalShortcutEntry> entries = this.tableModel.getEntries();
        List kss = null;
        for (GlobalShortcutEntry entry : entries) {
            String desc = null;
            if (entry.getAction().equals(Resources.getString("plugin.keybindings.globalchooser.ANSWER_CALL"))) {
                desc = "answer";
            } else if (entry.getAction().equals(Resources.getString("plugin.keybindings.globalchooser.HANGUP_CALL"))) {
                desc = "hangup";
            } else if (entry.getAction().equals(Resources.getString("plugin.keybindings.globalchooser.ANSWER_HANGUP_CALL"))) {
                desc = "answer_hangup";
            } else if (entry.getAction().equals(Resources.getString("plugin.keybindings.globalchooser.SHOW_CONTACTLIST"))) {
                desc = "contactlist";
            } else if (entry.getAction().equals(Resources.getString("plugin.keybindings.globalchooser.MUTE_CALLS"))) {
                desc = "mute";
            } else {
                if (!entry.getAction().equals(Resources.getString("plugin.keybindings.globalchooser.PUSH_TO_TALK"))) continue;
                desc = "push_to_talk";
            }
            kss = (List)gBindings.get(desc);
            kss.clear();
            kss.add(entry.getShortcut());
            kss.add(entry.getShortcut2());
            gBindings.put(desc, kss);
        }
        keybindingService.saveGlobalShortcutFromConfiguration();
        globalShortcutService.reloadGlobalShortcuts();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }

    private void refresh() {
        this.tableModel.fireTableStructureChanged();
    }

    public boolean isAdvanced() {
        return true;
    }
}

