/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import java.util.Hashtable;
import java.util.List;
import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Message;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.slick.protocol.icq.IcqTesterAgent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class IcqSlickFixture
extends TestCase {
    public static BundleContext bc = null;
    public static AccountID icqAccountID = null;
    static IcqTesterAgent testerAgent = null;
    public static Hashtable<String, List<String>> preInstalledBuddyList = null;
    public ServiceReference icqServiceRef = null;
    public ProtocolProviderService provider = null;
    public ProtocolProviderFactory providerFactory = null;
    public String ourUserID = null;
    public static Bundle providerBundle = null;
    public static OfflineMsgCollector offlineMsgCollector = null;
    public static boolean onlineTestingDisabled = false;

    public void setUp() throws Exception {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(PROTOCOL_NAME=ICQ)";
        try {
            serRefs = bc.getServiceReferences(ProtocolProviderFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException ex) {
            IcqSlickFixture.fail((String)(osgiFilter + " is not a valid osgi filter"));
        }
        IcqSlickFixture.assertTrue((String)"Failed to find a provider factory service for protocol ICQ", (serRefs != null && serRefs.length > 0 ? 1 : 0) != 0);
        this.providerFactory = (ProtocolProviderFactory)bc.getService(serRefs[0]);
        this.ourUserID = System.getProperty("accounts.icq.TESTED_IMPL_ACCOUNT_ID");
        ServiceReference[] icqProviderRefs = bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + this.ourUserID + "))");
        IcqSlickFixture.assertNotNull((String)("No Protocol Provider was found for ICQ UIN:" + this.ourUserID), (Object)icqProviderRefs);
        IcqSlickFixture.assertTrue((String)("No Protocol Provider was found for ICQ UIN:" + this.ourUserID), (icqProviderRefs.length > 0 ? 1 : 0) != 0);
        this.icqServiceRef = icqProviderRefs[0];
        this.provider = (ProtocolProviderService)bc.getService(this.icqServiceRef);
    }

    public void tearDown() {
        bc.ungetService(this.icqServiceRef);
    }

    public static Bundle findProtocolProviderBundle(ProtocolProviderService provider) {
        Bundle[] bundles = bc.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            ServiceReference[] registeredServices = bundles[i].getRegisteredServices();
            if (registeredServices == null) continue;
            for (int j = 0; j < registeredServices.length; ++j) {
                Object service = bc.getService(registeredServices[j]);
                if (service != provider) continue;
                return bundles[i];
            }
        }
        return null;
    }

    static class OfflineMsgCollector
    implements MessageListener {
        private String offlineMessageToBeDelivered = null;
        private OperationSetBasicInstantMessaging imOper = null;
        private Message receivedMessage = null;

        OfflineMsgCollector() {
        }

        public void messageReceived(MessageReceivedEvent evt) {
            this.receivedMessage = evt.getSourceMessage();
            this.imOper.removeMessageListener((MessageListener)this);
        }

        public void messageDelivered(MessageDeliveredEvent evt) {
        }

        public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
        }

        public void setMessageText(String txt) {
            this.offlineMessageToBeDelivered = txt;
        }

        public String getMessageText() {
            return this.offlineMessageToBeDelivered;
        }

        public void register(OperationSetBasicInstantMessaging imOper) {
            this.imOper = imOper;
            imOper.addMessageListener((MessageListener)this);
        }

        public Message getReceivedMessage() {
            return this.receivedMessage;
        }
    }
}

