/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.icq;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import net.java.sip.communicator.service.protocol.AccountManagerUtils;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.slick.protocol.icq.IcqSlickFixture;
import net.java.sip.communicator.slick.protocol.icq.IcqTesterAgent;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountUninstallation
extends TestCase {
    private static final Logger logger = Logger.getLogger(TestAccountUninstallation.class);
    IcqSlickFixture fixture = new IcqSlickFixture();
    public RegistrationEventCollector regEvtCollector = new RegistrationEventCollector();
    private Object registrationLock = new Object();

    public TestAccountUninstallation(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fixture.setUp();
    }

    protected void tearDown() throws Exception {
        this.fixture.tearDown();
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        if (!IcqSlickFixture.onlineTestingDisabled) {
            suite.addTest((Test)new TestAccountUninstallation("testMultipleLogins"));
        }
        suite.addTest((Test)new TestAccountUninstallation("testInstallationPersistency"));
        suite.addTest((Test)new TestAccountUninstallation("testUninstallAccount"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultipleLogins() {
        Object lock;
        this.fixture.provider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this.regEvtCollector);
        String passwd = System.getProperty("accounts.icq.TESTED_IMPL_PWD", null);
        String uin = System.getProperty("accounts.icq.TESTED_IMPL_ACCOUNT_ID", null);
        IcqTesterAgent testerAgent = new IcqTesterAgent(uin);
        testerAgent.register(passwd);
        Object object = lock = new Object();
        synchronized (object) {
            try {
                logger.debug((Object)"Giving the aim server time to notify for our arrival!");
                lock.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        testerAgent.unregister();
        TestAccountUninstallation.assertNotNull((String)"No event was dispatched", (Object)this.regEvtCollector.stateRecieved);
        TestAccountUninstallation.assertEquals((String)"Event is not UNREGISTERED event", (Object)this.regEvtCollector.stateRecieved, (Object)RegistrationState.UNREGISTERED);
        TestAccountUninstallation.assertEquals((String)"No registration event notifying of Multiple logins dispatched ", (int)this.regEvtCollector.eventReason, (int)2);
    }

    public void testInstallationPersistency() throws Exception {
        Bundle providerBundle;
        IcqSlickFixture.providerBundle = providerBundle = IcqSlickFixture.findProtocolProviderBundle(this.fixture.provider);
        TestAccountUninstallation.assertNotNull((String)"Couldn't find a bundle for the tested provider", (Object)providerBundle);
        providerBundle.stop();
        TestAccountUninstallation.assertTrue((String)("Couldn't stop the protocol provider bundle. State was " + providerBundle.getState()), (32 != providerBundle.getState() && 16 != providerBundle.getState() ? 1 : 0) != 0);
        providerBundle.uninstall();
        TestAccountUninstallation.assertEquals((String)"Couldn't stop the protocol provider bundle.", (int)1, (int)providerBundle.getState());
        ServiceReference[] icqProviderRefs = null;
        try {
            icqProviderRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + IcqSlickFixture.icqAccountID.getUserID() + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong: " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was still regged as an osgi service for ICQ UIN:" + IcqSlickFixture.icqAccountID + "After it was explicitly uninstalled"), (icqProviderRefs == null || icqProviderRefs.length == 0 ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)("The ICQ provider factory kept a reference to the provider we just uninstalled (accID=" + IcqSlickFixture.icqAccountID + ")"), (this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(IcqSlickFixture.icqAccountID) == null ? 1 : 0) != 0);
        IcqSlickFixture.providerBundle = providerBundle = IcqSlickFixture.bc.installBundle(providerBundle.getLocation());
        TestAccountUninstallation.assertEquals((String)"Couldn't re-install protocol provider bundle.", (int)2, (int)providerBundle.getState());
        AccountManagerUtils.startBundleAndWaitStoredAccountsLoaded((BundleContext)IcqSlickFixture.bc, (Bundle)providerBundle, (String)"ICQ");
        TestAccountUninstallation.assertEquals((String)"Couldn't re-start protocol provider bundle.", (int)32, (int)providerBundle.getState());
        try {
            icqProviderRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + IcqSlickFixture.icqAccountID.getUserID() + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong: " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was not restored after beingreinstalled. ICQ UIN:" + IcqSlickFixture.icqAccountID), (icqProviderRefs != null && icqProviderRefs.length > 0 ? 1 : 0) != 0);
        ServiceReference[] icqFactoryRefs = null;
        try {
            icqFactoryRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderFactory.class.getName(), "(PROTOCOL_NAME=ICQ)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong: " + ex.getMessage()));
        }
        this.fixture.providerFactory = (ProtocolProviderFactory)IcqSlickFixture.bc.getService(icqFactoryRefs[0]);
        this.fixture.provider = (ProtocolProviderService)IcqSlickFixture.bc.getService(icqProviderRefs[0]);
        IcqSlickFixture.icqAccountID = this.fixture.provider.getAccountID();
        TestAccountUninstallation.assertTrue((String)("The ICQ provider did not restore its own reference to the provider that we just reinstalled (accID=" + IcqSlickFixture.icqAccountID + ")"), (!this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(IcqSlickFixture.icqAccountID) != null ? 1 : 0) != 0);
    }

    public void testUninstallAccount() {
        TestAccountUninstallation.assertFalse((String)"No installed accounts found", (boolean)this.fixture.providerFactory.getRegisteredAccounts().isEmpty());
        TestAccountUninstallation.assertNotNull((String)("Found no provider corresponding to account ID " + IcqSlickFixture.icqAccountID), (Object)this.fixture.providerFactory.getProviderForAccount(IcqSlickFixture.icqAccountID));
        TestAccountUninstallation.assertTrue((String)("Failed to remove a provider corresponding to acc id " + IcqSlickFixture.icqAccountID), (boolean)this.fixture.providerFactory.uninstallAccount(IcqSlickFixture.icqAccountID));
        ServiceReference[] icqProviderRefs = null;
        try {
            icqProviderRefs = IcqSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(&(PROTOCOL_NAME=ICQ)(USER_ID=" + IcqSlickFixture.icqAccountID.getUserID() + "))");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallation.fail((String)("We apparently got our filter wrong: " + ex.getMessage()));
        }
        TestAccountUninstallation.assertTrue((String)("A Protocol Provider Service was still regged as an osgi service for ICQ UIN:" + IcqSlickFixture.icqAccountID + "After it was explicitly uninstalled"), (icqProviderRefs == null || icqProviderRefs.length == 0 ? 1 : 0) != 0);
        TestAccountUninstallation.assertTrue((String)("The ICQ provider factory kept a reference to the provider we just uninstalled (accID=" + IcqSlickFixture.icqAccountID + ")"), (this.fixture.providerFactory.getRegisteredAccounts().isEmpty() && this.fixture.providerFactory.getProviderForAccount(IcqSlickFixture.icqAccountID) == null ? 1 : 0) != 0);
    }

    public class RegistrationEventCollector
    implements RegistrationStateChangeListener {
        RegistrationState stateRecieved = null;
        int eventReason = -1;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            logger.debug((Object)("Received a RegistrationStateChangeEvent: " + evt));
            if (evt.getNewState().equals((Object)RegistrationState.UNREGISTERED)) {
                logger.debug((Object)"Connection FAILED!");
                this.stateRecieved = evt.getNewState();
                this.eventReason = evt.getReasonCode();
                Object object = TestAccountUninstallation.this.registrationLock;
                synchronized (object) {
                    logger.debug((Object)".");
                    TestAccountUninstallation.this.registrationLock.notifyAll();
                    logger.debug((Object)".");
                }
            }
        }
    }
}

