/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;
import org.jetbrains.annotations.Nullable;

public class CertificateInfo
implements LiveWritable {
    public static final int CODE_DEFAULT = 1;
    private static final ByteBlock HASH_DEFAULT;
    public static final ByteBlock HASHA_DEFAULT;
    public static final ByteBlock HASHB_DEFAULT;
    private static final int TYPE_NUMCERTS = 4;
    private static final int TYPE_COMMONCERTDATA = 1;
    private static final int TYPE_ENCCERTDATA = 1;
    private static final int TYPE_SIGNCERTDATA = 2;
    private static final int TYPE_HASH_A = 5;
    private static final int TYPE_HASH_B = 6;
    private final boolean common;
    private final ByteBlock certInfoHash;
    private final ByteBlock commonCertData;
    private final ByteBlock encCertData;
    private final ByteBlock signCertData;
    private final ByteBlock hashA;
    private final ByteBlock hashB;

    public static byte[] getCertInfoHash(CertificateInfo certInfo) {
        MessageDigest digest;
        DefensiveTools.checkNull(certInfo, "certInfo");
        ByteBlock data = ByteBlock.createByteBlock(certInfo);
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException impossible) {
            return null;
        }
        byte[] hash = digest.digest(data.toByteArray());
        return hash;
    }

    @Nullable
    public static CertificateInfo readCertInfoBlock(ByteBlock block) {
        ByteBlock data;
        ExtraInfoBlock infoBlock;
        ByteBlock data2;
        ExtraInfoBlock infoBlock2;
        DefensiveTools.checkNull(block, "block");
        ImmutableTlvChain chain = TlvTools.readChain(block);
        ByteBlock hashA = null;
        Tlv hashATlv = chain.getLastTlv(5);
        if (hashATlv != null && (infoBlock2 = ExtraInfoBlock.readExtraInfoBlock(data2 = hashATlv.getData())) != null) {
            hashA = infoBlock2.getExtraData().getData();
        }
        ByteBlock hashB = null;
        Tlv hashBTlv = chain.getLastTlv(6);
        if (hashBTlv != null && (infoBlock = ExtraInfoBlock.readExtraInfoBlock(data = hashBTlv.getData())) != null) {
            hashB = infoBlock.getExtraData().getData();
        }
        ByteBlock encCertData = null;
        Tlv encCertTlv = chain.getLastTlv(1);
        if (encCertTlv != null) {
            encCertData = encCertTlv.getData();
        }
        ByteBlock signCertData = null;
        Tlv signCertTlv = chain.getLastTlv(2);
        if (signCertTlv != null) {
            signCertData = signCertTlv.getData();
        }
        ByteBlock certHash = BinaryTools.getMD5(block.subBlock(chain.getTotalSize()));
        if (signCertData == null) {
            if (encCertData == null) {
                return null;
            }
            return new CertificateInfo(certHash, encCertData, null, null, hashA, hashB);
        }
        if (encCertData == null) {
            return null;
        }
        return new CertificateInfo(certHash, encCertData, signCertData, hashA, hashB);
    }

    public CertificateInfo(ByteBlock commonCertData) {
        this(commonCertData, HASHA_DEFAULT, HASHB_DEFAULT);
    }

    public CertificateInfo(ByteBlock commonCertData, ByteBlock hashA, ByteBlock hashB) {
        this.common = true;
        this.certInfoHash = null;
        this.commonCertData = commonCertData;
        this.encCertData = null;
        this.signCertData = null;
        this.hashA = hashA;
        this.hashB = hashB;
    }

    public CertificateInfo(ByteBlock encCertData, ByteBlock signCertData) {
        this(encCertData, signCertData, HASHA_DEFAULT, HASHB_DEFAULT);
    }

    public CertificateInfo(ByteBlock encCertData, ByteBlock signCertData, ByteBlock hashA, ByteBlock hashB) {
        this(null, encCertData, signCertData, hashA, hashB);
    }

    private CertificateInfo(ByteBlock certInfoHash, ByteBlock encCertData, ByteBlock signCertData, ByteBlock hashA, ByteBlock hashB) {
        this(certInfoHash, null, encCertData, signCertData, hashA, hashB);
    }

    private CertificateInfo(ByteBlock certInfoHash, ByteBlock commonCertData, ByteBlock encCertData, ByteBlock signCertData, ByteBlock hashA, ByteBlock hashB) {
        if (commonCertData == null) {
            DefensiveTools.checkNull(signCertData, "signCertData");
            DefensiveTools.checkNull(encCertData, "encCertData");
            this.common = false;
            this.commonCertData = null;
            this.encCertData = encCertData;
            this.signCertData = signCertData;
        } else {
            if (signCertData != null || encCertData != null) {
                throw new IllegalArgumentException("commonCertData is not null, but signCertData=" + signCertData + " and encCertData=" + encCertData);
            }
            this.common = true;
            this.commonCertData = commonCertData;
            this.encCertData = null;
            this.signCertData = null;
        }
        this.certInfoHash = certInfoHash;
        this.hashA = hashA;
        this.hashB = hashB;
    }

    public final ByteBlock getCertInfoHash() {
        return this.certInfoHash;
    }

    public final boolean isCommon() {
        return this.common;
    }

    public final ByteBlock getCommonCertData() {
        return this.commonCertData;
    }

    public final ByteBlock getEncCertData() {
        return this.encCertData;
    }

    public final ByteBlock getSignCertData() {
        return this.signCertData;
    }

    public final ByteBlock getHashA() {
        return this.hashA;
    }

    public final ByteBlock getHashB() {
        return this.hashB;
    }

    private static void writeHash(OutputStream out, int tlvType, int extraInfoType, ByteBlock hash) throws IOException {
        ExtraInfoData data = new ExtraInfoData(1, hash);
        ExtraInfoBlock block = new ExtraInfoBlock(extraInfoType, data);
        new Tlv(tlvType, ByteBlock.createByteBlock(block)).write(out);
    }

    public void write(OutputStream out) throws IOException {
        int numCerts = this.common ? 1 : 2;
        Tlv.getUShortInstance(4, numCerts).write(out);
        if (numCerts == 1) {
            if (this.commonCertData != null) {
                new Tlv(1, this.commonCertData).write(out);
            }
        } else {
            new Tlv(1, this.encCertData).write(out);
            new Tlv(2, this.signCertData).write(out);
        }
        if (this.hashA != null) {
            CertificateInfo.writeHash(out, 5, 1026, this.hashA);
        }
        if (this.hashB != null) {
            CertificateInfo.writeHash(out, 6, 1027, this.hashB);
        }
    }

    public String toString() {
        return "CertificateInfo: " + (this.common ? "common cert" + (this.commonCertData == null ? " (null)" : "") : "enc cert, signing cert");
    }

    static {
        HASHB_DEFAULT = HASHA_DEFAULT = (HASH_DEFAULT = ByteBlock.wrap(new byte[]{-44, 29, -116, -39, -113, 0, -78, 4, -23, -128, 9, -104, -20, -8, 66, 126}));
    }
}

