/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.AbstractImIcbm;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.snaccmd.icbm.SendIcbm;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendImIcbm
extends AbstractImIcbm
implements SendIcbm {
    private static final int TYPE_ACK = 3;
    private static final int TYPE_OFFLINE = 6;
    private final String sn;
    private final boolean ackRequested;
    private boolean offline;

    protected SendImIcbm(SnacPacket packet) {
        super(6, packet);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = this.getChannelData();
        StringBlock snInfo = OscarTools.readScreenname(snacData);
        this.sn = snInfo.getString();
        ByteBlock rest = snacData.subBlock(snInfo.getTotalSize());
        ImmutableTlvChain imTlvs = TlvTools.readChain(rest);
        this.processImTlvs(imTlvs);
        this.ackRequested = imTlvs.hasTlv(3);
    }

    public SendImIcbm(String sn, String message) {
        this(sn, new InstantMessage(message));
    }

    public SendImIcbm(String sn, InstantMessage message) {
        this(sn, message, false);
    }

    public SendImIcbm(String sn, String message, boolean autoresponse) {
        this(sn, new InstantMessage(message), autoresponse);
    }

    public SendImIcbm(String sn, InstantMessage message, boolean autoresponse) {
        this(sn, message, autoresponse, 0L, false, null, null, FEATURES_DEFAULT, true);
    }

    public SendImIcbm(String sn, String message, boolean autoResponse, long messageId, boolean wantsIcon, OldIconHashInfo iconInfo, Collection<ExtraInfoBlock> expInfoBlocks, boolean ackRequested) {
        this(sn, new InstantMessage(message), autoResponse, messageId, wantsIcon, iconInfo, expInfoBlocks, ackRequested);
    }

    public SendImIcbm(String sn, InstantMessage message, boolean autoResponse, long messageId, boolean wantsIcon, OldIconHashInfo iconInfo, Collection<ExtraInfoBlock> expInfoBlocks, boolean ackRequested) {
        this(sn, message, autoResponse, messageId, wantsIcon, iconInfo, expInfoBlocks, FEATURES_DEFAULT, ackRequested);
    }

    public SendImIcbm(String sn, InstantMessage message, boolean autoResponse, long messageId, boolean wantsIcon, OldIconHashInfo iconInfo, Collection<ExtraInfoBlock> expInfoBlocks, ByteBlock featuresBlock, boolean ackRequested) {
        super(6, messageId, message, autoResponse, wantsIcon, iconInfo, expInfoBlocks, featuresBlock);
        DefensiveTools.checkNull(sn, "sn");
        if (ackRequested && autoResponse) {
            throw new IllegalArgumentException("ackRequested and autoResponse cannot both be true");
        }
        this.sn = sn;
        this.ackRequested = ackRequested;
    }

    @Override
    public final String getScreenname() {
        return this.sn;
    }

    public final boolean isAckRequested() {
        return this.ackRequested;
    }

    public void setOffline(boolean isOffline) {
        this.offline = isOffline;
    }

    @Override
    protected void writeChannelData(OutputStream out) throws IOException {
        OscarTools.writeScreenname(out, this.sn);
        this.writeImTlvs(out);
        if (this.ackRequested) {
            new Tlv(3).write(out);
        }
        if (this.offline) {
            new Tlv(6).write(out);
        }
    }

    @Override
    public String toString() {
        return "SendImIcbm to " + this.sn + " (id=" + this.getIcbmMessageId() + ", ackreq=" + this.ackRequested + "): " + this.getMessage();
    }
}

