/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.ssi;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.OscarTools;
import net.kano.joscar.StringBlock;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ssi.SsiCommand;

public class RemoveMeCmd
extends SsiCommand {
    private final String screenname;

    protected RemoveMeCmd(SnacPacket packet) {
        super(22);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock data = packet.getData();
        StringBlock sb = OscarTools.readScreenname(data);
        this.screenname = sb != null ? sb.getString() : null;
    }

    public RemoveMeCmd(String screenname) {
        super(22);
        this.screenname = screenname;
    }

    public final String getScreenname() {
        return this.screenname;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.screenname != null) {
            OscarTools.writeScreenname(out, this.screenname);
        }
    }

    public String toString() {
        return "SsiRemoveMeCmd: screenname=" + this.screenname;
    }
}

