/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.info;

import java.util.Iterator;
import java.util.Set;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.snac.SnacRequestAdapter;
import net.kano.joscar.snac.SnacRequestTimeoutEvent;
import net.kano.joscar.snac.SnacResponseEvent;
import net.kano.joscar.snaccmd.FullUserInfo;
import net.kano.joscar.snaccmd.InfoData;
import net.kano.joscar.snaccmd.loc.UserInfoCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.info.InfoRequestManager;
import net.kano.joustsim.oscar.oscar.service.info.InfoResponseListener;
import net.kano.joustsim.oscar.oscar.service.info.MutableInfoService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UserInfoRequestManager<V>
extends InfoRequestManager {
    public UserInfoRequestManager(MutableInfoService service) {
        super(service);
    }

    @Override
    protected void sendRequest(final Screenname sn) {
        SnacCommand cmd = this.generateSnacCommand(sn);
        this.getService().getOscarConnection().sendSnacRequest(cmd, new SnacRequestAdapter(){
            private boolean ran = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleResponse(SnacResponseEvent e) {
                SnacCommand snac = e.getSnacCommand();
                if (UserInfoRequestManager.this.shouldRunListeners(snac)) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (this.ran) {
                            return;
                        }
                        this.ran = true;
                    }
                    UserInfoRequestManager.this.runListeners(sn, UserInfoRequestManager.this.getDesiredValueFromSnac(snac));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleTimeout(SnacRequestTimeoutEvent event) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (this.ran) {
                        return;
                    }
                    this.ran = true;
                }
                UserInfoRequestManager.this.runListeners(sn, null);
            }
        });
    }

    protected boolean shouldRunListeners(SnacCommand snac) {
        return snac instanceof UserInfoCmd;
    }

    private void runListeners(Screenname sn, V value) {
        Set<InfoResponseListener> listeners = this.clearListeners(sn);
        Iterator<InfoResponseListener> i$ = listeners.iterator();
        while (i$.hasNext()) {
            InfoResponseListener listener1;
            InfoResponseListener listener = listener1 = i$.next();
            this.callListener(listener, sn, value);
        }
    }

    private V getDesiredValueFromSnac(SnacCommand snac) {
        InfoData infodata;
        UserInfoCmd uic;
        FullUserInfo userInfo;
        V value = null;
        if (snac instanceof UserInfoCmd && (userInfo = (uic = (UserInfoCmd)snac).getUserInfo()) != null && (infodata = uic.getInfoData()) != null) {
            value = this.getDesiredValue(infodata);
        }
        return value;
    }

    protected abstract SnacCommand generateSnacCommand(Screenname var1);

    protected abstract void callListener(InfoResponseListener var1, Screenname var2, V var3);

    protected abstract V getDesiredValue(InfoData var1);
}

