/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.aimaccregwizz;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.java.sip.communicator.plugin.aimaccregwizz.AimAccRegWizzActivator;
import net.java.sip.communicator.plugin.aimaccregwizz.AimAccountRegistration;
import net.java.sip.communicator.plugin.aimaccregwizz.AimAccountRegistrationWizard;
import net.java.sip.communicator.plugin.aimaccregwizz.Resources;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.TrimTextField;
import net.java.sip.communicator.service.gui.WizardPage;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class FirstWizardPage
extends TransparentPanel
implements WizardPage,
DocumentListener,
ActionListener {
    private static final long serialVersionUID = 0L;
    public static final String FIRST_PAGE_IDENTIFIER = "FirstPageIdentifier";
    public static final String USER_NAME_EXAMPLE = "Ex: johnsmith";
    private final Component uinPassPanel;
    private JTextField uinField = new TrimTextField();
    private JPasswordField passField = new JPasswordField();
    private JCheckBox rememberPassBox = new SIPCommCheckBox(Resources.getString("service.gui.REMEMBER_PASSWORD"));
    private JPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(1));
    private JButton registerButton = new JButton(Resources.getString("plugin.aimaccregwizz.REGISTER_NEW_ACCOUNT"));
    private JPanel mainPanel = new TransparentPanel();
    private Object nextPageIdentifier = "SUMMARY";
    private final AimAccountRegistrationWizard wizard;
    private boolean isCommitted = false;

    public FirstWizardPage(AimAccountRegistrationWizard wizard) {
        super((LayoutManager)new BorderLayout());
        this.wizard = wizard;
        this.setPreferredSize(new Dimension(600, 500));
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.uinPassPanel = this.createUinPassPanel();
        this.add(this.mainPanel, "North");
    }

    private void initAdvancedPanel() {
        this.mainPanel.add(this.uinPassPanel);
        this.mainPanel.add(this.createRegisterPanel());
    }

    private Component createUinPassPanel() {
        TransparentPanel uinPassPanel = new TransparentPanel((LayoutManager)new BorderLayout(10, 10));
        TransparentPanel labelsPanel = new TransparentPanel();
        TransparentPanel valuesPanel = new TransparentPanel();
        labelsPanel.setLayout(new BoxLayout((Container)labelsPanel, 1));
        valuesPanel.setLayout(new BoxLayout((Container)valuesPanel, 1));
        JLabel uinLabel = new JLabel(Resources.getString("plugin.aimaccregwizz.USERNAME"));
        TransparentPanel emptyPanel = new TransparentPanel();
        JLabel uinExampleLabel = new JLabel(USER_NAME_EXAMPLE);
        JLabel passLabel = new JLabel(Resources.getString("service.gui.PASSWORD"));
        this.uinField.getDocument().addDocumentListener(this);
        this.rememberPassBox.setSelected(this.wizard.getRegistration().isRememberPassword());
        uinExampleLabel.setForeground(Color.GRAY);
        uinExampleLabel.setFont(uinExampleLabel.getFont().deriveFont(8));
        emptyPanel.setMaximumSize(new Dimension(40, 35));
        uinExampleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        labelsPanel.add(uinLabel);
        labelsPanel.add((Component)emptyPanel);
        labelsPanel.add(passLabel);
        valuesPanel.add(this.uinField);
        valuesPanel.add(uinExampleLabel);
        valuesPanel.add(this.passField);
        uinPassPanel.add((Component)labelsPanel, "West");
        uinPassPanel.add((Component)valuesPanel, "Center");
        uinPassPanel.add((Component)this.rememberPassBox, "South");
        uinPassPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.aimaccregwizz.USERNAME_AND_PASSWORD")));
        return uinPassPanel;
    }

    private Component createRegisterPanel() {
        TransparentPanel registerPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
        this.registerButton.addActionListener(this);
        this.buttonPanel.add(this.registerButton);
        JTextArea registerArea = new JTextArea(Resources.getString("plugin.aimaccregwizz.REGISTER_NEW_ACCOUNT_TEXT"));
        registerArea.setEditable(false);
        registerArea.setLineWrap(true);
        registerArea.setWrapStyleWord(true);
        registerArea.setOpaque(false);
        registerPanel.add(registerArea);
        registerPanel.add(this.buttonPanel);
        registerPanel.setBorder(BorderFactory.createTitledBorder(Resources.getString("plugin.aimaccregwizz.REGISTER_NEW_ACCOUNT")));
        return registerPanel;
    }

    public Object getIdentifier() {
        return FIRST_PAGE_IDENTIFIER;
    }

    public Object getNextPageIdentifier() {
        return this.nextPageIdentifier;
    }

    public Object getBackPageIdentifier() {
        return null;
    }

    public Object getWizardForm() {
        this.initAdvancedPanel();
        return this;
    }

    public void pageShowing() {
        this.setNextButtonAccordingToUIN();
    }

    public void commitPage() {
        String uin = this.uinField.getText();
        if (uin == null || uin.trim().length() == 0) {
            throw new IllegalStateException("No user ID provided.");
        }
        AimAccountRegistration registration = this.wizard.getRegistration();
        registration.setUin(uin);
        registration.setPassword(new String(this.passField.getPassword()));
        registration.setRememberPassword(this.rememberPassBox.isSelected());
        this.nextPageIdentifier = "SUMMARY";
        this.isCommitted = true;
    }

    private void setNextButtonAccordingToUIN() {
        if (this.uinField.getText() == null || this.uinField.getText().equals("")) {
            this.wizard.getWizardContainer().setNextFinishButtonEnabled(false);
        } else {
            this.wizard.getWizardContainer().setNextFinishButtonEnabled(true);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setNextButtonAccordingToUIN();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setNextButtonAccordingToUIN();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void pageHiding() {
    }

    public void pageShown() {
    }

    public void pageBack() {
    }

    public void loadAccount(ProtocolProviderService protocolProvider) {
        AccountID accountID = protocolProvider.getAccountID();
        String password = AimAccRegWizzActivator.getAimProtocolProviderFactory().loadPassword(accountID);
        this.uinField.setEnabled(false);
        this.uinField.setText(accountID.getUserID());
        if (password != null) {
            this.passField.setText(password);
            this.rememberPassBox.setSelected(this.wizard.getRegistration().isRememberPassword());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.wizard.webSignup();
    }

    public Object getSimpleForm() {
        return this.uinPassPanel;
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }
}

