/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.util;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ReverseMap;
import org.xbill.DNS.TextParseException;
import sun.net.spi.nameservice.NameService;

public class JitsiDnsNameService
implements NameService {
    private static boolean v6first;
    private static Name localhostName;
    private static InetAddress[] localhostAddresses;
    private static InetAddress[] localhostNamedAddresses;
    private static boolean addressesLoaded;

    public String getHostByAddr(byte[] bytes) throws UnknownHostException {
        InetAddress addr = InetAddress.getByAddress(bytes);
        if (addr.isLoopbackAddress()) {
            return "localhost";
        }
        Name name = ReverseMap.fromAddress((InetAddress)addr);
        Lookup l = new Lookup(name, 12);
        Record[] records = l.run();
        if (records == null) {
            throw new UnknownHostException();
        }
        return ((PTRRecord)records[0]).getTarget().toString();
    }

    public InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
        Name n;
        try {
            n = new Name(host);
            if (addressesLoaded) {
                if (n.equals((Object)localhostName)) {
                    return localhostNamedAddresses;
                }
                if (host.equals("localhost")) {
                    return localhostAddresses;
                }
            }
        }
        catch (TextParseException e) {
            throw new UnknownHostException(host);
        }
        Lookup l = new Lookup(n, v6first ? 28 : 1);
        Record[] r = l.run();
        if (r == null || r.length == 0) {
            l = new Lookup(n, v6first ? 1 : 28);
            r = l.run();
        }
        if (r == null || r.length == 0) {
            throw new UnknownHostException(host);
        }
        InetAddress[] results = new InetAddress[r.length];
        for (int i = 0; i < r.length; ++i) {
            if (r[i] instanceof AAAARecord) {
                results[i] = ((AAAARecord)r[i]).getAddress();
                continue;
            }
            if (!(r[i] instanceof ARecord)) continue;
            results[i] = ((ARecord)r[i]).getAddress();
        }
        return results;
    }

    static {
        localhostName = null;
        localhostAddresses = null;
        localhostNamedAddresses = null;
        addressesLoaded = false;
        v6first = Boolean.getBoolean("java.net.preferIPv6Addresses");
        try {
            Class<?> inClass = Class.forName("java.net.InetAddressImplFactory");
            Method create = inClass.getDeclaredMethod("create", new Class[0]);
            create.setAccessible(true);
            Object impl = create.invoke(null, new Object[0]);
            Class<?> clazz = Class.forName("java.net.InetAddressImpl");
            Method hostname = clazz.getMethod("getLocalHostName", new Class[0]);
            hostname.setAccessible(true);
            localhostName = new Name((String)hostname.invoke(impl, new Object[0]));
            Method lookup = clazz.getMethod("lookupAllHostAddr", String.class);
            lookup.setAccessible(true);
            localhostNamedAddresses = (InetAddress[])lookup.invoke(impl, localhostName.toString());
            localhostAddresses = (InetAddress[])lookup.invoke(impl, "localhost");
            addressesLoaded = true;
        }
        catch (Exception e) {
            System.err.println("Could not obtain localhost: " + e);
        }
    }
}

