/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.httputil;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.URL;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import net.java.sip.communicator.service.gui.AuthenticationWindowService;
import net.java.sip.communicator.service.httputil.HttpUtilActivator;
import net.java.sip.communicator.service.httputil.SSLSocketFactoryEx;
import net.java.sip.communicator.util.Logger;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.ProxySelectorRoutePlanner;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jitsi.util.StringUtils;

public class HttpUtils {
    private static final Logger logger = Logger.getLogger(HttpUtils.class);
    private static final String HTTP_CREDENTIALS_PREFIX = "net.java.sip.communicator.util.http.credential.";
    private static final int MAX_REDIRECTS = 10;

    public static HTTPResponseResult openURLConnection(String address) {
        return HttpUtils.openURLConnection(address, null, null, null, null);
    }

    public static HTTPResponseResult openURLConnection(String address, String[] headerParamNames, String[] headerParamValues) {
        return HttpUtils.openURLConnection(address, null, null, headerParamNames, headerParamValues);
    }

    public static HTTPResponseResult openURLConnection(String address, String usernamePropertyName, String passwordPropertyName, String[] headerParamNames, String[] headerParamValues) {
        try {
            HttpEntity result;
            HttpGet httpGet = new HttpGet(address);
            DefaultHttpClient httpClient = HttpUtils.getHttpClient(usernamePropertyName, passwordPropertyName, httpGet.getURI().getHost(), null);
            if (headerParamNames != null && headerParamValues != null) {
                for (int i = 0; i < headerParamNames.length; ++i) {
                    httpGet.addHeader((Header)new BasicHeader(headerParamNames[i], headerParamValues[i]));
                }
            }
            if ((result = HttpUtils.executeMethod(httpClient, (HttpRequestBase)httpGet, null, null)) == null) {
                return null;
            }
            return new HTTPResponseResult(result, httpClient);
        }
        catch (Throwable t) {
            logger.error((Object)("Cannot open connection to:" + address), t);
            return null;
        }
    }

    private static HttpEntity executeMethod(DefaultHttpClient httpClient, HttpRequestBase req, RedirectHandler redirectHandler, List<NameValuePair> parameters) throws Throwable {
        HttpResponse response = null;
        int redirects = 0;
        while (response == null || response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403) {
            if (response != null && (response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Will retry http connect and credentials input as latest are not correct!");
                }
                throw new AuthenticationException("Authorization needed");
            }
            response = httpClient.execute((HttpUriRequest)req);
            if (!((HTTPCredentialsProvider)httpClient.getCredentialsProvider()).retry()) {
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)"User canceled credentials input.");
                break;
            }
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null || !(req instanceof HttpPost) || response.getStatusLine().getStatusCode() != 301 && response.getStatusLine().getStatusCode() != 302 && response.getStatusLine().getStatusCode() != 303 || redirects >= 10) continue;
            HttpRequestBase oldreq = req;
            oldreq.abort();
            String newLocation = locationHeader.getValue();
            if (redirectHandler != null && redirectHandler.handleRedirect(newLocation, parameters)) {
                return null;
            }
            req = new HttpGet(newLocation);
            req.setParams(oldreq.getParams());
            req.setHeaders(oldreq.getAllHeaders());
            ++redirects;
            response = httpClient.execute((HttpUriRequest)req);
        }
        if (response != null && response.getStatusLine().getStatusCode() == 200) {
            return response.getEntity();
        }
        return null;
    }

    public static HTTPResponseResult postFile(String address, String fileParamName, File file) {
        return HttpUtils.postFile(address, fileParamName, file, null, null);
    }

    public static HTTPResponseResult postFile(String address, String fileParamName, File file, String usernamePropertyName, String passwordPropertyName) {
        DefaultHttpClient httpClient = null;
        try {
            HttpPost postMethod = new HttpPost(address);
            httpClient = HttpUtils.getHttpClient(usernamePropertyName, passwordPropertyName, postMethod.getURI().getHost(), null);
            String mimeType = URLConnection.guessContentTypeFromName(file.getPath());
            if (mimeType == null) {
                mimeType = "application/octet-stream";
            }
            FileBody bin = new FileBody(file, mimeType);
            MultipartEntity reqEntity = new MultipartEntity();
            reqEntity.addPart(fileParamName, (ContentBody)bin);
            postMethod.setEntity((HttpEntity)reqEntity);
            HttpEntity resEntity = HttpUtils.executeMethod(httpClient, (HttpRequestBase)postMethod, null, null);
            if (resEntity == null) {
                return null;
            }
            return new HTTPResponseResult(resEntity, httpClient);
        }
        catch (Throwable e) {
            logger.error((Object)("Cannot post file to:" + address), e);
            return null;
        }
    }

    public static HTTPResponseResult postForm(String address, String usernamePropertyName, String passwordPropertyName, ArrayList<String> formParamNames, ArrayList<String> formParamValues, int usernameParamIx, int passwordParamIx) throws Throwable {
        return HttpUtils.postForm(address, usernamePropertyName, passwordPropertyName, formParamNames, formParamValues, usernameParamIx, passwordParamIx, null);
    }

    public static HTTPResponseResult postForm(String address, String usernamePropertyName, String passwordPropertyName, ArrayList<String> formParamNames, ArrayList<String> formParamValues, int usernameParamIx, int passwordParamIx, RedirectHandler redirectHandler) throws Throwable {
        return HttpUtils.postForm(address, usernamePropertyName, passwordPropertyName, formParamNames, formParamValues, usernameParamIx, passwordParamIx, redirectHandler, null, null);
    }

    public static HTTPResponseResult postForm(String address, List<String> headerParamNames, List<String> headerParamValues) throws Throwable {
        return HttpUtils.postForm(address, null, null, null, null, -1, -1, null, headerParamNames, headerParamValues);
    }

    public static HTTPResponseResult postForm(String address, String usernamePropertyName, String passwordPropertyName, ArrayList<String> formParamNames, ArrayList<String> formParamValues, int usernameParamIx, int passwordParamIx, RedirectHandler redirectHandler, List<String> headerParamNames, List<String> headerParamValues) throws Throwable {
        DefaultHttpClient httpClient;
        AuthenticationException authEx;
        HttpEntity resEntity = null;
        HTTPCredentialsProvider credentialsProvider = null;
        do {
            HttpPost postMethod = new HttpPost(address);
            httpClient = HttpUtils.getHttpClient(usernamePropertyName, passwordPropertyName, postMethod.getURI().getHost(), credentialsProvider);
            try {
                resEntity = HttpUtils.postForm(httpClient, postMethod, address, formParamNames, formParamValues, usernameParamIx, passwordParamIx, redirectHandler, headerParamNames, headerParamValues);
                authEx = null;
            }
            catch (AuthenticationException ex) {
                authEx = ex;
                credentialsProvider = (HTTPCredentialsProvider)httpClient.getCredentialsProvider();
                String userName = credentialsProvider.authUsername;
                credentialsProvider.clear();
                credentialsProvider.authUsername = userName;
                credentialsProvider.errorMessage = HttpUtilActivator.getResources().getI18NString("service.gui.AUTHENTICATION_FAILED", new String[]{credentialsProvider.usedScope.getHost()});
            }
        } while (authEx != null);
        if (resEntity == null) {
            return null;
        }
        return new HTTPResponseResult(resEntity, httpClient);
    }

    private static HttpEntity postForm(DefaultHttpClient httpClient, HttpPost postMethod, String address, ArrayList<String> formParamNames, ArrayList<String> formParamValues, int usernameParamIx, int passwordParamIx, RedirectHandler redirectHandler, List<String> headerParamNames, List<String> headerParamValues) throws Throwable {
        Credentials creds = null;
        if (!(usernameParamIx == -1 || usernameParamIx >= formParamNames.size() || passwordParamIx == -1 || passwordParamIx >= formParamNames.size() || formParamValues.get(usernameParamIx) != null && formParamValues.get(usernameParamIx).length() != 0 || formParamValues.get(passwordParamIx) != null && formParamValues.get(passwordParamIx).length() != 0)) {
            URL url = new URL(address);
            HTTPCredentialsProvider prov = (HTTPCredentialsProvider)httpClient.getCredentialsProvider();
            while (creds == null || creds.getUserPrincipal() == null || StringUtils.isNullOrEmpty((String)creds.getUserPrincipal().getName())) {
                creds = prov.getCredentials(new AuthScope(url.getHost(), url.getPort()));
                if (creds != null || prov.retry()) continue;
                return null;
            }
        }
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        if (formParamNames != null) {
            for (int i = 0; i < formParamNames.size(); ++i) {
                if (i == usernameParamIx && creds != null) {
                    parameters.add((NameValuePair)new BasicNameValuePair(formParamNames.get(i), creds.getUserPrincipal().getName()));
                    continue;
                }
                if (i == passwordParamIx && creds != null) {
                    parameters.add((NameValuePair)new BasicNameValuePair(formParamNames.get(i), creds.getPassword()));
                    continue;
                }
                parameters.add((NameValuePair)new BasicNameValuePair(formParamNames.get(i), formParamValues.get(i)));
            }
        }
        httpClient.setRedirectStrategy((RedirectStrategy)new CustomRedirectStrategy(redirectHandler, parameters));
        String s = URLEncodedUtils.format(parameters, (String)"UTF-8");
        StringEntity entity = new StringEntity(s, "UTF-8");
        entity.setContentType("application/x-www-form-urlencoded");
        postMethod.setEntity((HttpEntity)entity);
        if (headerParamNames != null) {
            for (int i = 0; i < headerParamNames.size(); ++i) {
                postMethod.addHeader(headerParamNames.get(i), headerParamValues.get(i));
            }
        }
        return HttpUtils.executeMethod(httpClient, (HttpRequestBase)postMethod, redirectHandler, parameters);
    }

    public static DefaultHttpClient getHttpClient(String usernamePropertyName, String passwordPropertyName, String address, CredentialsProvider credentialsProvider) throws IOException {
        SSLContext sslCtx;
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.socket.timeout", (Object)10000);
        params.setParameter("http.connection.timeout", (Object)10000);
        params.setParameter("http.protocol.max-redirects", (Object)10);
        DefaultHttpClient httpClient = new DefaultHttpClient((HttpParams)params);
        HttpProtocolParams.setUserAgent((HttpParams)httpClient.getParams(), (String)(System.getProperty("sip-communicator.application.name") + "/" + System.getProperty("sip-communicator.version")));
        try {
            sslCtx = HttpUtilActivator.getCertificateVerificationService().getSSLContext(HttpUtilActivator.getCertificateVerificationService().getTrustManager(address));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage());
        }
        try {
            Scheme sch = new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactoryEx(sslCtx));
            httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        }
        catch (Throwable t) {
            logger.error((Object)"Error creating ssl socket factory", t);
        }
        ProxySelectorRoutePlanner routePlanner = new ProxySelectorRoutePlanner(httpClient.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
        httpClient.setRoutePlanner((HttpRoutePlanner)routePlanner);
        if (credentialsProvider == null) {
            credentialsProvider = new HTTPCredentialsProvider(usernamePropertyName, passwordPropertyName);
        }
        httpClient.setCredentialsProvider(credentialsProvider);
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(3, true));
        return httpClient;
    }

    public static interface RedirectHandler {
        public boolean handleRedirect(String var1, List<NameValuePair> var2);

        public boolean hasParams(String var1);
    }

    private static class CustomRedirectStrategy
    extends DefaultRedirectStrategy {
        private final RedirectHandler handler;
        private final List<NameValuePair> parameters;

        CustomRedirectStrategy(RedirectHandler handler, List<NameValuePair> parameters) {
            this.handler = handler;
            this.parameters = parameters;
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            Header locationHeader = response.getFirstHeader("location");
            if (this.handler != null && locationHeader != null && this.handler.hasParams(locationHeader.getValue())) {
                this.handler.handleRedirect(locationHeader.getValue(), this.parameters);
                return false;
            }
            return super.isRedirected(request, response, context);
        }
    }

    public static class HTTPResponseResult {
        HttpEntity entity;
        DefaultHttpClient httpClient;

        HTTPResponseResult(HttpEntity entity, DefaultHttpClient httpClient) {
            this.entity = entity;
            this.httpClient = httpClient;
        }

        public long getContentLength() {
            return this.entity.getContentLength();
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return new HttpClientInputStream(this.entity.getContent(), (HttpClient)this.httpClient);
        }

        public String getContentString() throws IOException {
            try {
                String string = EntityUtils.toString((HttpEntity)this.entity);
                return string;
            }
            finally {
                if (this.httpClient != null) {
                    this.httpClient.getConnectionManager().shutdown();
                }
            }
        }

        public String[] getCredentials() {
            String[] cred = new String[2];
            if (this.httpClient != null) {
                HTTPCredentialsProvider prov = (HTTPCredentialsProvider)this.httpClient.getCredentialsProvider();
                cred[0] = prov.getAuthenticationUsername();
                cred[1] = prov.getAuthenticationPassword();
            }
            return cred;
        }
    }

    private static class HttpClientInputStream
    extends InputStream {
        InputStream in;
        HttpClient httpClient;

        HttpClientInputStream(InputStream in, HttpClient httpClient) {
            this.in = in;
            this.httpClient = httpClient;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    private static class HTTPCredentialsProvider
    implements CredentialsProvider {
        private boolean retry = true;
        private AuthScope usedScope = null;
        private String usernamePropertyName = null;
        private String passwordPropertyName = null;
        private String authUsername = null;
        private String authPassword = null;
        private String errorMessage = null;

        HTTPCredentialsProvider(String usernamePropertyName, String passwordPropertyName) {
            this.usernamePropertyName = usernamePropertyName;
            this.passwordPropertyName = passwordPropertyName;
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
        }

        public Credentials getCredentials(AuthScope authscope) {
            String pass;
            this.usedScope = authscope;
            if (this.passwordPropertyName == null) {
                this.passwordPropertyName = HTTPCredentialsProvider.getCredentialProperty(authscope);
            }
            if (this.usernamePropertyName == null) {
                this.usernamePropertyName = HTTPCredentialsProvider.getCredentialProperty(authscope);
            }
            if ((pass = HttpUtilActivator.getCredentialsService().loadPassword(this.passwordPropertyName)) == null) {
                AuthenticationWindowService authenticationWindowService = HttpUtilActivator.getAuthenticationWindowService();
                if (authenticationWindowService == null) {
                    logger.error((Object)"No AuthenticationWindowService implementation");
                    return null;
                }
                AuthenticationWindowService.AuthenticationWindow authWindow = authenticationWindowService.create(this.authUsername, null, authscope.getHost(), true, false, null, null, null, null, null, this.errorMessage, HttpUtilActivator.getResources().getSettingsString("plugin.provisioning.SIGN_UP_LINK"));
                authWindow.setVisible(true);
                if (!authWindow.isCanceled()) {
                    UsernamePasswordCredentials cred = new UsernamePasswordCredentials(authWindow.getUserName(), new String(authWindow.getPassword()));
                    this.authUsername = authWindow.getUserName();
                    this.authPassword = new String(authWindow.getPassword());
                    if (authWindow.isRememberPassword()) {
                        HttpUtilActivator.getConfigurationService().setProperty(this.usernamePropertyName, (Object)authWindow.getUserName());
                        HttpUtilActivator.getCredentialsService().storePassword(this.passwordPropertyName, new String(authWindow.getPassword()));
                    }
                    return cred;
                }
            } else {
                this.authUsername = HttpUtilActivator.getConfigurationService().getString(this.usernamePropertyName);
                this.authPassword = pass;
                return new UsernamePasswordCredentials(HttpUtilActivator.getConfigurationService().getString(this.usernamePropertyName), pass);
            }
            this.retry = false;
            return null;
        }

        public void clear() {
            if (this.usedScope != null) {
                if (this.passwordPropertyName == null) {
                    this.passwordPropertyName = HTTPCredentialsProvider.getCredentialProperty(this.usedScope);
                }
                if (this.usernamePropertyName == null) {
                    this.usernamePropertyName = HTTPCredentialsProvider.getCredentialProperty(this.usedScope);
                }
                HttpUtilActivator.getConfigurationService().removeProperty(this.usernamePropertyName);
                HttpUtilActivator.getCredentialsService().removePassword(this.passwordPropertyName);
            }
            this.authUsername = null;
            this.authPassword = null;
            this.errorMessage = null;
        }

        private static String getCredentialProperty(AuthScope authscope) {
            StringBuilder pref = new StringBuilder();
            pref.append(HttpUtils.HTTP_CREDENTIALS_PREFIX).append(authscope.getHost()).append(".").append(authscope.getRealm()).append(".").append(authscope.getPort());
            return pref.toString();
        }

        boolean retry() {
            return this.retry;
        }

        public String getAuthenticationUsername() {
            return this.authUsername;
        }

        public String getAuthenticationPassword() {
            return this.authPassword;
        }
    }
}

