/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.domain.messages.ClientErrorMessage;
import com.ircclouds.irc.api.domain.messages.ErrorMessage;
import com.ircclouds.irc.api.domain.messages.QuitMessage;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.state.IIRCState;
import net.java.sip.communicator.util.Logger;

public abstract class AbstractIrcMessageListener
extends VariousMessageListenerAdapter {
    private static final Logger LOGGER = Logger.getLogger(AbstractIrcMessageListener.class);
    protected final IRCApi irc;
    protected final IIRCState connectionState;

    protected AbstractIrcMessageListener(IRCApi irc, IIRCState connectionState) {
        if (irc == null) {
            throw new IllegalArgumentException("A valid irc instance must be provided.");
        }
        this.irc = irc;
        if (connectionState == null) {
            throw new IllegalArgumentException("A valid connection state instance must be provided.");
        }
        this.connectionState = connectionState;
    }

    public void onUserQuit(QuitMessage msg) {
        String nick = msg.getSource().getNick();
        if (!this.localUser(nick)) {
            return;
        }
        LOGGER.debug((Object)("Local user's QUIT message received: removing " + ((Object)((Object)this)).getClass().getCanonicalName()));
        this.irc.deleteListener((IMessageListener)this);
    }

    public void onError(ErrorMessage msg) {
        LOGGER.debug((Object)("Local user received ERROR message: removing " + ((Object)((Object)this)).getClass().getCanonicalName()));
        this.irc.deleteListener((IMessageListener)this);
    }

    public void onClientError(ClientErrorMessage msg) {
        LOGGER.debug((Object)("Local user received ERROR message: removing " + ((Object)((Object)this)).getClass().getCanonicalName()));
        this.irc.deleteListener((IMessageListener)this);
    }

    protected boolean localUser(String nick) {
        return nick != null && nick.equals(this.connectionState.getNickname());
    }
}

