/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.Result;

public class ResultTest
extends TestCase {
    public void testConstruction() {
        Result result = new Result();
        Assert.assertNotNull(result);
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertNull(result.getValue());
        Assert.assertNull(result.getException());
    }

    public void testConstructionWithInitialValue() {
        Object initial = new Object();
        Result result = new Result(initial);
        Assert.assertNotNull(result);
        Assert.assertFalse((boolean)result.isDone());
        Assert.assertSame((Object)initial, (Object)result.getValue());
        Assert.assertNull(result.getException());
    }

    public void testSetDone() {
        Result result = new Result();
        result.setDone();
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertNull(result.getValue());
        Assert.assertNull(result.getException());
    }

    public void testSetDoneWithValue() {
        Object v = new Object();
        Result result = new Result();
        result.setDone(v);
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertSame((Object)v, result.getValue());
        Assert.assertNull(result.getException());
    }

    public void testSetDoneWithException() {
        IllegalStateException e = new IllegalStateException("the world is going to explode");
        Result result = new Result();
        result.setDone(e);
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertNull(result.getValue());
        Assert.assertSame((Object)e, result.getException());
    }

    public void testSetDoneWithBoth() {
        Object v = new Object();
        IllegalStateException e = new IllegalStateException("the world is going to explode");
        Result<Object, IllegalStateException> result = new Result<Object, IllegalStateException>();
        result.setDone(v, e);
        Assert.assertTrue((boolean)result.isDone());
        Assert.assertSame((Object)v, result.getValue());
        Assert.assertSame((Object)e, result.getException());
    }
}

